/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.ReplyConverter;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFederationApi1
extends AbstractFederationApi {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFederationApi1.class);

    public AbstractFederationApi1(be.iminds.ilabt.jfed.log.Logger logger2, RetrySettings retrySettings, ApiInfo.Api api, JFedPreferences jFedPreferences) {
        super(logger2, retrySettings, api, jFedPreferences);
    }

    public abstract String getMethodObject(Method var1);

    @Nonnull
    protected <T> AbstractFederationApi.FederationApiReply<AbstractFederationApi.LookupResult<T>> genericLookup(Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nullable List<AnyCredential> credentialList, @Nullable Map<String, ?> match, @Nullable List<String> filter, @Nullable Map<String, Object> extraOptions, @Nullable List<Object> extraArguments, @Nonnull AbstractFederationApi.LookupResultConverter<T> lookupResultConverter) throws JFedException {
        ArrayList<Object> args = new ArrayList<Object>();
        if (extraArguments != null) {
            extraArguments.forEach(args::add);
        }
        if (credentialList != null) {
            args.add(AbstractFederationApi1.createCredentialsListWithTypeAndVersion(credentialList));
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (match != null) {
            options.put("match", match);
        }
        if (filter != null) {
            options.put("filter", filter);
        }
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, methodGeniName, args, resultValueObject -> new AbstractFederationApi.LookupResult(resultValueObject, lookupResultConverter));
    }

    @Nonnull
    protected <R> AbstractFederationApi.FederationApiReply<R> internalLookup(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nullable List<AnyCredential> credentialList, @Nullable Map<String, ?> match, @Nullable List<String> filter, @Nullable Map<String, Object> extraOptions, @Nullable List<Object> extraArguments, @Nonnull ReplyConverter<R> replyConverter) throws JFedException {
        if (methodParams != null) {
            methodParams.put("type", methodGeniName);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        if (extraArguments != null) {
            extraArguments.forEach(args::add);
        }
        if (credentialList != null) {
            args.add(AbstractFederationApi1.createCredentialsListWithTypeAndVersion(credentialList));
        }
        Map<String, Object> options = AbstractFederationApi1.createOptionsMap(extraOptions);
        if (match != null) {
            options.put("match", match);
        }
        if (filter != null) {
            options.put("filter", filter);
        }
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, methodGeniName, args, replyConverter);
    }

    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> genericUpdateCall(Map<String, Object> methodParams, SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nonnull List<AnyCredential> credentialList, @Nonnull String urn, @Nullable String urnType, @Nonnull Map<String, String> fields, @Nullable Map<String, Object> extraOptions) throws JFedException {
        return this.genericUpdateCall(methodParams, con, methodJavaName, methodGeniName, credentialList, urn, urnType, fields, extraOptions, null);
    }

    @Nonnull
    public AbstractFederationApi.FederationApiReply<String> genericUpdateCall(Map<String, Object> methodParams, SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nonnull List<AnyCredential> credentialList, @Nonnull String urn, @Nullable String urnType, @Nonnull Map<String, String> fields, @Nullable Map<String, Object> extraOptions, @Nullable List<Object> extraArguments) throws JFedException {
        assert (!fields.isEmpty());
        GeniUrn geniUrn = GeniUrn.parse(urn);
        if (geniUrn == null || urnType != null && !Objects.equals(geniUrn.getEncodedResourceType(), urnType)) {
            LOG.error("WARNING: URN argument to " + methodJavaName + " is not a valid " + (urnType == null ? "" : urnType) + " urn: \"" + urn + "\" (will be used anyway)");
        }
        ArrayList<Object> args = new ArrayList<Object>();
        if (extraArguments != null) {
            extraArguments.forEach(args::add);
        }
        args.add(urn);
        args.add(AbstractFederationApi1.createCredentialsListWithTypeAndVersion(credentialList));
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("fields", fields);
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, methodGeniName, args, STRING_REPLY_CONVERTER);
    }
}

