/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.ReplyConverter;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFederationApi2
extends AbstractFederationApi {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFederationApi2.class);

    public AbstractFederationApi2(be.iminds.ilabt.jfed.log.Logger logger2, RetrySettings retrySettings, ApiInfo.Api serverType, JFedPreferences jFedPreferences) {
        super(logger2, retrySettings, serverType, jFedPreferences);
    }

    @Nonnull
    protected <T> AbstractFederationApi.FederationApiReply<AbstractFederationApi.LookupResult<T>> genericLookup(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String objectTypeName, @Nullable List<AnyCredential> credentialList, @Nullable Map<String, ?> match, @Nullable List<String> filter, @Nullable Map<String, Object> extraOptions, @Nullable List<Object> extraArguments, @Nonnull AbstractFederationApi.LookupResultConverter<T> lookupResultConverter) throws JFedException {
        return this.internalLookup(methodParams, con, methodJavaName, objectTypeName, credentialList, match, filter, extraOptions, extraArguments, resultValueObject -> new AbstractFederationApi.LookupResult(resultValueObject, lookupResultConverter));
    }

    @Nonnull
    protected <R> AbstractFederationApi.FederationApiReply<R> internalLookup(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String objectTypeName, @Nullable List<AnyCredential> credentialList, @Nullable Map<String, ?> match, @Nullable List<String> filter, @Nullable Map<String, Object> extraOptions, @Nullable List<Object> extraArguments, @Nonnull ReplyConverter<R> converter) throws JFedException {
        if (methodParams != null) {
            methodParams.put("type", objectTypeName);
        }
        ArrayList<Object> args = new ArrayList<Object>(4);
        if (extraArguments != null) {
            extraArguments.forEach(args::add);
        }
        args.add(objectTypeName);
        if (credentialList != null) {
            args.add(AbstractFederationApi2.createCredentialsListWithTypeAndVersion(credentialList));
        } else {
            args.add(Collections.emptyList());
        }
        Map<String, Object> options = AbstractFederationApi2.createOptionsMap(extraOptions);
        if (match != null) {
            options.put("match", match);
        }
        if (filter != null) {
            options.put("filter", filter);
        }
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, "lookup", args, resultValueObject -> {
            if (resultValueObject == null || Objects.equals(resultValueObject, 0)) {
                return null;
            }
            return converter.convertXMLRPCCall(resultValueObject);
        });
    }

    @Nonnull
    protected AbstractFederationApi.FederationApiReply<String> update_internal(Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String objectTypeName, @Nonnull List<AnyCredential> credentialList, @Nonnull String urn, @Nullable String urnType, @Nonnull Map<String, String> fields, @Nullable Map<String, Object> extraOptions) throws JFedException {
        return this.update_internal(methodParams, con, methodJavaName, objectTypeName, credentialList, urn, urnType, fields, extraOptions, null);
    }

    @Nonnull
    protected AbstractFederationApi.FederationApiReply<String> update_internal(Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String objectTypeName, @Nonnull List<AnyCredential> credentialList, @Nonnull String urn, @Nullable String urnType, @Nonnull Map<String, String> fields, @Nullable Map<String, Object> extraOptions, @Nullable List<Object> extraArguments) throws JFedException {
        if (methodParams != null) {
            methodParams.put("type", objectTypeName);
        }
        assert (!fields.isEmpty());
        GeniUrn geniUrn = GeniUrn.parse(urn);
        if (geniUrn == null || urnType != null && !Objects.equals(geniUrn.getEncodedResourceType(), urnType)) {
            LOG.error("WARNING: URN argument to " + methodJavaName + " is not a valid " + (urnType == null ? "" : urnType) + " urn: \"" + urn + "\" (will be used anyway)");
        }
        ArrayList<Object> args = new ArrayList<Object>(4);
        if (extraArguments != null) {
            extraArguments.forEach(args::add);
        }
        args.add(objectTypeName);
        args.add(urn);
        args.add(AbstractFederationApi2.createCredentialsListWithTypeAndVersion(credentialList));
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("fields", fields);
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, "update", args, STRING_REPLY_CONVERTER);
    }

    @Nonnull
    protected <R> AbstractFederationApi.FederationApiReply<R> create_internal(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String objectTypeName, @Nonnull List<AnyCredential> credentialList, @Nonnull Map<String, String> fields, @Nullable Map<String, Object> extraOptions, @Nonnull ReplyConverter<R> replyConverter) throws JFedException {
        if (methodParams != null) {
            methodParams.put("type", objectTypeName);
        }
        assert (!fields.isEmpty());
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(objectTypeName);
        args.add(AbstractFederationApi2.createCredentialsListWithTypeAndVersion(credentialList));
        Map<String, Object> options = AbstractFederationApi2.createOptionsMap(extraOptions);
        options.put("fields", fields);
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, "create", args, replyConverter);
    }

    @Nonnull
    public AbstractFederationApi.FederationApiReply<Boolean> delete_internal(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String objectTypeName, @Nonnull List<AnyCredential> credentialList, @Nonnull String urnToDelete, @Nullable Map<String, Object> extraOptions) throws JFedException {
        if (methodParams != null) {
            methodParams.put("type", objectTypeName);
        }
        ArrayList<Object> args = new ArrayList<Object>(4);
        args.add(objectTypeName);
        args.add(urnToDelete);
        args.add(AbstractFederationApi2.createCredentialsListWithTypeAndVersion(credentialList));
        args.add(AbstractFederationApi2.createOptionsMap(extraOptions));
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, "delete", args, BOOLEAN_REPLY_CONVERTER, false);
    }

    @Nonnull
    public AbstractFederationApi.FederationApiReply<List<AnyCredential>> getCredentials_internal(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String objectTypeName, @Nonnull List<AnyCredential> credentialList, @Nonnull GeniUrn urn, @Nullable Map<String, Object> extraOptions) throws JFedException {
        if (methodParams != null) {
            methodParams.put("type", objectTypeName);
        }
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(urn.toString());
        args.add(AbstractFederationApi2.createCredentialsListWithTypeAndVersion(credentialList));
        args.add(AbstractFederationApi2.createOptionsMap(extraOptions));
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, "get_credentials", args, resultValueObject -> AbstractFederationApi2.apiSpecifiesListOfCredentials("get_credentials " + objectTypeName, resultValueObject));
    }
}

