/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_scripts;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.dropwizard.jackson.Jackson;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAllUsers {
    private static final Logger LOG = LoggerFactory.getLogger(GetAllUsers.class);
    @Nonnull
    private final be.iminds.ilabt.jfed.log.Logger logger;
    @Nonnull
    private final UserAndSliceApiWrapper samaWrapper;
    @Nonnull
    private final JFedConnectionProvider connectionProvider;
    @Nonnull
    private final FederationMemberAuthorityApi2 ma;
    @Nonnull
    private final FederationSliceAuthorityApi2 sa;
    @Nonnull
    private final GeniUserProvider geniUserProvider;

    @Inject
    public GetAllUsers(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory automaticUserAndSliceApiWrapperFactory, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedPreferences jFedPreferences, @Nonnull JFedConnectionProvider connectionProvider) {
        this.logger = logger2;
        this.geniUserProvider = geniUserProvider;
        this.connectionProvider = connectionProvider;
        if (!geniUserProvider.isUserLoggedIn()) {
            throw new IllegalArgumentException("GetProjectsForUsers requires a logged in user");
        }
        Server userServer = geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        if (userServer == null) {
            throw new IllegalArgumentException("GetProjectsForUsers requires a user with an auth server");
        }
        if (userServer.getServices() == null) {
            throw new IllegalArgumentException("Cannot initialize AutomaticUserAndSliceApiWrapper: userAuth.getServices() = null (userAuth.urn=" + userServer.getDefaultComponentManagerUrn() + ")");
        }
        if (!ApiInfo.hasService(userServer, ApiInfo.ApiName.GENI_CH_SA, 2) || !ApiInfo.hasService(userServer, ApiInfo.ApiName.GENI_CH_MA, 2)) {
            throw new IllegalArgumentException("user authority should have a \"Common Federation API\" v2 service");
        }
        this.sa = new FederationSliceAuthorityApi2(logger2, jFedPreferences);
        this.ma = new FederationMemberAuthorityApi2(logger2, jFedPreferences);
        this.samaWrapper = automaticUserAndSliceApiWrapperFactory.create();
    }

    private SfaConnection getSAConnection() throws JFedException {
        Server userServer = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        if (userServer == null) {
            throw new IllegalArgumentException("GetProjectsForUsers requires a user with an auth server");
        }
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.geniUserProvider.getLoggedInGeniUser(), userServer, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_SA, 2));
    }

    private SfaConnection getMAConnection() throws JFedException {
        Server userServer = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        if (userServer == null) {
            throw new IllegalArgumentException("GetProjectsForUsers requires a user with an auth server");
        }
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.geniUserProvider.getLoggedInGeniUser(), userServer, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 2));
    }

    @ApiMethod(order=1, hint="List all user urns as string")
    public List<String> getAllUsers() throws JFedException {
        this.samaWrapper.getLocalUserCredentials(this.logger);
        LOG.info("Got credential for user");
        List<AnyCredential> userCredentials = this.samaWrapper.getLocalUserCredentials(this.logger);
        AbstractFederationApi.FederationApiReply<AbstractFederationApi.MemberInfoList> reply = this.ma.lookupMember(this.getSAConnection(), userCredentials, null, null, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Error when querying user projects: " + reply.getGeniResponseCode() + " -> " + reply.getRawResult());
        }
        AbstractFederationApi.MemberInfoList memberInfoList = reply.getValue();
        if (memberInfoList == null) {
            throw new JFedException("No value in reply from SA");
        }
        ArrayList<String> memberUrnStrings = new ArrayList<String>();
        for (GeniUrn memberUrn : memberInfoList.keySet()) {
            memberUrnStrings.add(memberUrn.toString());
        }
        LOG.info("Got all users: {}", (Object)memberUrnStrings);
        return memberUrnStrings;
    }

    public String getAllUsersAsJson() throws JFedException {
        List<String> r = this.getAllUsers();
        try {
            return Jackson.newObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(r);
        }
        catch (JsonProcessingException e) {
            throw new JFedException("Error converting result to JSON", e);
        }
    }
}

