/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper;

import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Objects;

public class ErrorDetails {
    private final String error;
    private final GeniUrn sliverUrn;
    private final GeniUrn componentUrn;
    private final long timestamp;

    public ErrorDetails(String error, GeniUrn sliverUrn, GeniUrn componentUrn) {
        assert (error != null);
        assert (!error.isEmpty());
        this.error = error;
        this.sliverUrn = sliverUrn;
        this.componentUrn = componentUrn;
        this.timestamp = System.currentTimeMillis();
    }

    public ErrorDetails(String error, GeniUrn sliverUrn) {
        this(error, sliverUrn, null);
    }

    public ErrorDetails(String error, String sliverUrn, String componentUrn) {
        this(error, GeniUrn.parse(sliverUrn), GeniUrn.parse(componentUrn));
    }

    public ErrorDetails(String error, String sliverUrn) {
        this(error, sliverUrn, null);
    }

    public ErrorDetails(String error) {
        this.error = error;
        this.sliverUrn = null;
        this.componentUrn = null;
        this.timestamp = System.currentTimeMillis();
    }

    public ErrorDetails(String error, GeniUrn sliverUrn, GeniUrn componentUrn, long timestamp) {
        this.componentUrn = componentUrn;
        this.error = error;
        this.sliverUrn = sliverUrn;
        this.timestamp = timestamp;
    }

    public GeniUrn getSliverUrn() {
        return this.sliverUrn;
    }

    public GeniUrn getComponentUrn() {
        return this.componentUrn;
    }

    public String getError() {
        return this.error;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorDetails that = (ErrorDetails)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.componentUrn != null ? !Objects.equals(this.componentUrn, that.componentUrn) : that.componentUrn != null) {
            return false;
        }
        if (this.error != null ? !Objects.equals(this.error, that.error) : that.error != null) {
            return false;
        }
        return !(this.sliverUrn != null ? !Objects.equals(this.sliverUrn, that.sliverUrn) : that.sliverUrn != null);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.sliverUrn != null ? this.sliverUrn.hashCode() : 0);
        result = 31 * result + (this.componentUrn != null ? this.componentUrn.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ErrorDetails{timestamp=" + this.timestamp + ", error='" + this.error + "', sliverUrn=" + this.sliverUrn + ", componentUrn=" + this.componentUrn + "}";
    }
}

