/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AMv2Wrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AMv3Wrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.FakeEdgeAMWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.ProtoGeniAMExtensionsWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserWithSpeaksFor;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomaticAggregateManagerWrapper
extends AggregateManagerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(AutomaticAggregateManagerWrapper.class);
    private static final String EMULAB_TYPE = "emulab";
    public static boolean preferAMv3forNonEmulab = true;
    public static boolean preferAMv3forEmulab = true;
    protected ApiInfo.Api api;
    protected ApiInfo.Api poa_api;
    protected AggregateManagerWrapper impl;
    protected AMv2Wrapper impl_amv2;
    protected AMv3Wrapper impl_amv3;
    protected AggregateManagerWrapper poa_impl;
    protected ProtoGeniAMExtensionsWrapper protoGeniAMExtensionsWrapper;
    protected AggregateManagerWrapper last_used_impl;

    private AutomaticAggregateManagerWrapper(@Nonnull be.iminds.ilabt.jfed.log.Logger logger2, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull JFedPreferences jFedPreferences, @Nonnull Server amServer) throws AggregateManagerWrapper.NoAmException {
        super(logger2, geniUserProvider, connectionProvider, jFedPreferences, amServer);
        this.choose();
    }

    protected void choose() {
        if (this.amServer == null) {
            return;
        }
        this.choosePoaImpl();
        boolean preferAMv3 = EMULAB_TYPE.equalsIgnoreCase(this.amServer.getServerType()) ? preferAMv3forEmulab : preferAMv3forNonEmulab;
        boolean forceV2 = this.amServer.hasFlag(Server.Flag.workaroundForceAmv2All);
        boolean forceV3 = this.amServer.hasFlag(Server.Flag.workaroundForceAmv3All);
        if (ApiInfo.hasService(this.amServer, ApiInfo.ApiName.GENI_AM, 2)) {
            this.impl_amv2 = new AMv2Wrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences, this.amServer);
        }
        if (ApiInfo.hasService(this.amServer, ApiInfo.ApiName.GENI_AM, 3)) {
            this.impl_amv3 = new AMv3Wrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences, this.amServer);
        }
        if (this.impl_amv2 != null && (forceV2 || !preferAMv3 || this.impl_amv3 == null)) {
            this.api = new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2);
            LOG.trace("Choosing AMv2: forceV2 =={} || !preferAMv3=={} || impl_amv3 == null =={}", forceV2, !preferAMv3, this.impl_amv3 == null);
            this.impl = this.impl_amv2;
            this.setupProtoGeniAMExtensions();
        } else if (this.impl_amv3 != null && (forceV3 || preferAMv3 || this.impl_amv2 == null)) {
            this.api = new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3);
            LOG.trace("Choosing AMv3: forceV3 =={} || preferAMv3=={} || impl_amv2 == null =={}", forceV3, preferAMv3, this.impl_amv2 == null);
            this.impl = this.impl_amv3;
            this.setupProtoGeniAMExtensions();
        } else {
            if (this.amServer.isEdgeVlan()) {
                this.impl = new FakeEdgeAMWrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences, this.amServer);
                return;
            }
            assert (this.impl_amv2 == null && this.impl_amv3 == null || this.impl_amv2 != null && this.impl_amv3 != null) : " impl_amv2=" + this.impl_amv2 + " impl_amv3=" + this.impl_amv3;
            throw new AggregateManagerWrapper.NoAmException("There is no (supported) Aggregate Manager known for \"" + this.amServer.getName() + "\". amServer urn: " + this.amServer.getDefaultComponentManagerUrn() + ". JSON:\n" + this.amServer);
        }
    }

    protected void choosePoaImpl() {
        if (this.amServer == null) {
            return;
        }
        if (ApiInfo.hasService(this.amServer, ApiInfo.ApiName.GENI_AM, 3)) {
            this.poa_api = new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3);
            this.poa_impl = new AMv3Wrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences, this.amServer);
        }
    }

    protected void setupProtoGeniAMExtensions() {
        if (this.amServer == null) {
            return;
        }
        if (this.amServer.getServerType() == null) {
            return;
        }
        if ((this.amServer.isServerType(EMULAB_TYPE) || this.amServer.isServerType("protogeni") || this.amServer.isServerType("instageni") || this.amServer.hasFlag(Server.Flag.featurePoaExtDiskImageOps)) && (ApiInfo.hasService(this.amServer, ApiInfo.ApiName.GENI_AM, 2) || this.amServer.hasFlag(Server.Flag.featurePoaExtDiskImageOps))) {
            this.protoGeniAMExtensionsWrapper = new ProtoGeniAMExtensionsWrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences, this.amServer, ApiInfo.hasService(this.amServer, ApiInfo.ApiName.GENI_AM, 2) ? new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2) : new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3));
        }
    }

    protected AggregateManagerWrapper getImpl() {
        if (this.impl == null) {
            this.choose();
        }
        return this.impl;
    }

    @Override
    @ApiMethod(order=1, hint="Call \"GetVersion\"")
    public Map getVersion() throws JFedException {
        this.last_used_impl = this.impl;
        return this.impl.getVersion();
    }

    @Override
    @ApiMethod(order=2, hint="List all Resources at the Aggregate (optionally list only available)")
    public String listResources(@ApiMethodParameter(name="userCredentials", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> userCredentials, @ApiMethodParameter(name="available", parameterType=ApiMethodParameterType.BOOLEAN) boolean available) throws JFedException {
        this.last_used_impl = this.impl;
        return this.impl.listResources(userCredentials, available);
    }

    @Override
    @ApiMethod(order=2, hint="List all Resources at the Aggregate (optionally list only available)")
    public String listResources(@ApiMethodParameter(name="userCredentials", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> userCredentials, @ApiMethodParameter(name="available", parameterType=ApiMethodParameterType.BOOLEAN) boolean available, @ApiMethodParameter(name="type", hint="type of advertisement RSpec", parameterType=ApiMethodParameterType.STRING) @Nonnull String type, @ApiMethodParameter(name="version", hint="version of advertisement RSpec", parameterType=ApiMethodParameterType.STRING) @Nonnull String version) throws JFedException {
        this.last_used_impl = this.impl;
        return this.impl.listResources(userCredentials, available, type, version);
    }

    @Override
    @ApiMethod(order=3, hint="Create a Sliver reservation")
    public AggregateManagerWrapper.AllocateReply allocate(@ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="sliceCredentials", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> sliceCredentials, @ApiMethodParameter(name="rspec", parameterType=ApiMethodParameterType.RSPEC_STRING) @Nonnull String rspec, @ApiMethodParameter(name="startDate", parameterType=ApiMethodParameterType.DATE) Date startDate, @ApiMethodParameter(name="endDate", parameterType=ApiMethodParameterType.DATE) Date endDate) throws JFedException {
        this.last_used_impl = this.impl;
        return this.impl.allocate(sliceUrn, sliceCredentials, rspec, startDate, endDate);
    }

    @Override
    @ApiMethod(order=3, hint="Create a Sliver (includes allocating, provisioning and starting)")
    public String createSliver(@ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="sliceCredentials", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> sliceCredentials, @ApiMethodParameter(name="rspec", parameterType=ApiMethodParameterType.RSPEC_STRING) @Nonnull String rspec, @ApiMethodParameter(name="userUrns", parameterType=ApiMethodParameterType.LIST_OF_USERSPEC) List<UserSpec> userUrns, @ApiMethodParameter(name="expirationDate", parameterType=ApiMethodParameterType.DATE, required=false) Date expirationDate) throws JFedException {
        if (this.impl_amv2 != null && this.amServer.hasFlag(Server.Flag.featureReservationsNitos)) {
            LOG.debug("Forcing AMv2 for createSliver-call to {}", (Object)this.amServer.getName());
            this.last_used_impl = this.impl_amv2;
            return this.impl_amv2.createSliver(sliceUrn, sliceCredentials, rspec, userUrns, expirationDate);
        }
        this.last_used_impl = this.impl;
        return this.impl.createSliver(sliceUrn, sliceCredentials, rspec, userUrns, expirationDate);
    }

    @Override
    public boolean hasSeperateAllocateAndProvision() {
        return this.impl.hasSeperateAllocateAndProvision();
    }

    @Override
    public AggregateManagerWrapper.AllocateReply allocate(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String rspec, Date expirationDate) throws JFedException {
        this.last_used_impl = this.impl;
        return this.impl.allocate(sliceUrn, sliceCredentials, rspec, expirationDate);
    }

    @Override
    public String provisionAndStart(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, List<UserSpec> userSpecs, Date expirationDate) throws JFedException {
        this.last_used_impl = this.impl;
        return this.impl.provisionAndStart(sliceUrn, sliceCredentials, userSpecs, expirationDate);
    }

    @Override
    public AggregateManagerWrapper.ProvisionReply provision(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nullable List<UserSpec> userSpecs, @Nullable Date expirationDate) throws JFedException {
        this.last_used_impl = this.impl;
        return this.impl.provision(sliceUrn, sliceCredentials, userSpecs, expirationDate);
    }

    @Override
    public void poaStart(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        this.last_used_impl = this.impl;
        this.impl.poaStart(sliceUrn, sliceCredentials);
    }

    @Override
    @ApiMethod(order=4, hint="Delete a Sliver")
    public void deleteSliver(@ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="sliceCredentials", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        if (this.impl_amv2 != null && this.amServer != null && this.amServer.hasFlag(Server.Flag.workaroundForceAmv2Delete)) {
            this.last_used_impl = this.impl_amv2;
            this.impl_amv2.deleteSliver(sliceUrn, sliceCredentials);
        } else {
            this.last_used_impl = this.impl;
            this.impl.deleteSliver(sliceUrn, sliceCredentials);
        }
    }

    @Override
    @ApiMethod(order=5, hint="Request the status of a sliver")
    public StatusDetails status(@ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="sliceCredentials", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        LOG.debug("Calling AutomaticAggregateManagerWrapper status with " + sliceCredentials.size() + " credentials");
        if (this.impl_amv2 != null && this.amServer != null && this.amServer.hasFlag(Server.Flag.workaroundForceAmv2Status)) {
            LOG.debug("Forcing AMv2 for status-call to {}", (Object)this.amServer.getName());
            this.last_used_impl = this.impl_amv2;
            return this.impl_amv2.status(sliceUrn, sliceCredentials);
        }
        LOG.trace("Using implementation {} for status call", (Object)this.impl.getClass().getSimpleName());
        this.last_used_impl = this.impl;
        return this.impl.status(sliceUrn, sliceCredentials);
    }

    @Override
    @Nullable
    public AggregateManager3.StatusInfo status_v3(@Nonnull GeniUrn urn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        return this.impl_amv3.status_v3(urn, sliceCredentials);
    }

    @Override
    @ApiMethod(order=6, hint="Request the manifest RSpec of a sliver")
    public String describe(@ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN) @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="sliceCredentials", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        if (this.impl_amv2 != null && this.amServer != null && this.amServer.hasFlag(Server.Flag.workaroundForceAmv2Describe)) {
            this.last_used_impl = this.impl_amv2;
            return this.impl_amv2.describe(sliceUrn, sliceCredentials);
        }
        this.last_used_impl = this.impl;
        return this.impl.describe(sliceUrn, sliceCredentials);
    }

    @Override
    @ApiMethod(order=7, hint="Renew the expiration time of a sliver.")
    public List<GeniUrn> renewSlivers(@ApiMethodParameter(name="sliceUrn", parameterType=ApiMethodParameterType.SLICE_URN, required=false) GeniUrn sliceUrn, @ApiMethodParameter(name="sliverUrns", parameterType=ApiMethodParameterType.LIST_OF_SLIVER_URN, required=false) List<GeniUrn> sliverUrns, @ApiMethodParameter(name="sliceCredentials", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> sliceCredentials, @ApiMethodParameter(name="newExpire", parameterType=ApiMethodParameterType.DATE) @Nonnull Date newExpire) throws JFedException {
        this.last_used_impl = this.impl;
        return this.impl.renewSlivers(sliceUrn, sliverUrns, sliceCredentials, newExpire);
    }

    @Override
    @Nullable
    public AbstractGeniAggregateManager.AggregateManagerReply getLastReply() {
        if (this.last_used_impl == null) {
            return null;
        }
        return this.last_used_impl.getLastReply();
    }

    @Override
    public boolean isExirationdateSetByCreateSliver() {
        this.last_used_impl = this.impl;
        return this.impl.isExirationdateSetByCreateSliver();
    }

    @Override
    @ApiMethod(order=10, hint="Ask if the Share LAN option is supported")
    public boolean isShareLanSupported() {
        if (this.amServer != null && !this.amServer.hasFlag(Server.Flag.featurePoaShareLan)) {
            return false;
        }
        if (this.poa_impl != null) {
            this.last_used_impl = this.poa_impl;
            return this.poa_impl.isShareLanSupported();
        }
        return false;
    }

    @Override
    @ApiMethod(order=11, hint="Ask if Restart is supported")
    public boolean isRestartSupported() {
        if (this.amServer != null && !this.amServer.hasFlag(Server.Flag.featurePoaNodeRestart)) {
            return false;
        }
        if (this.poa_impl != null) {
            this.last_used_impl = this.poa_impl;
            return this.poa_impl.isRestartSupported();
        }
        this.last_used_impl = this.impl;
        return this.impl.isRestartSupported();
    }

    @Override
    public boolean isReloadOSSupported() {
        if (this.amServer != null && !this.amServer.hasFlag(Server.Flag.featurePoaReloadOs)) {
            return false;
        }
        if (this.poa_impl != null) {
            this.last_used_impl = this.poa_impl;
            return this.poa_impl.isRestartSupported();
        }
        this.last_used_impl = this.impl;
        return this.impl.isRestartSupported();
    }

    @Override
    public boolean isOpenConsoleSupported() {
        if (this.amServer != null && !this.amServer.hasFlag(Server.Flag.featurePoaOpenConsole)) {
            return false;
        }
        if (this.poa_impl != null) {
            this.last_used_impl = this.poa_impl;
            return this.poa_impl.isOpenConsoleSupported();
        }
        this.last_used_impl = this.impl;
        return this.impl.isOpenConsoleSupported();
    }

    @Override
    @ApiMethod(order=12, hint="Share a LAN between slices")
    public void shareLan(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String lanClientId, @Nonnull String newSharedLanName) throws JFedException {
        if (this.poa_impl == null || !this.poa_impl.isShareLanSupported()) {
            throw new RuntimeException("Aggregate Manager has no support for shared LAN");
        }
        this.last_used_impl = this.poa_impl;
        this.poa_impl.shareLan(sliceUrn, sliceCredentials, lanClientId, newSharedLanName);
    }

    @Override
    @ApiMethod(order=13, hint="Unshare a shared LAN")
    public void unshareLan(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String lanClientId, @Nonnull String sharedLanName) throws JFedException {
        if (this.poa_impl == null || !this.poa_impl.isShareLanSupported()) {
            throw new RuntimeException("Aggregate Manager has no support for shared LAN");
        }
        this.last_used_impl = this.poa_impl;
        this.poa_impl.unshareLan(sliceUrn, sliceCredentials, lanClientId, sharedLanName);
    }

    @Override
    @ApiMethod(order=14, hint="Restart all resources in a Slice")
    public void restart(@Nonnull GeniUrn sliverUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        if (this.poa_impl == null) {
            throw new RuntimeException("Aggregate Manager has no support for PerformOperationAction, and thus not for restart.");
        }
        this.last_used_impl = this.poa_impl;
        this.poa_impl.restart(sliverUrn, sliceCredentials);
    }

    @Override
    public void reloadOS(@Nonnull GeniUrn sliverUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        if (this.poa_impl == null) {
            throw new RuntimeException("Aggregate Manager has no support for PerformOperationAction, and thus not for reload.");
        }
        this.last_used_impl = this.poa_impl;
        this.poa_impl.reloadOS(sliverUrn, sliceCredentials);
    }

    @Override
    public URL openConsole(@Nonnull GeniUrn sliverUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        if (this.poa_impl != null) {
            this.last_used_impl = this.poa_impl;
            return this.poa_impl.openConsole(sliverUrn, sliceCredentials);
        }
        throw new RuntimeException("Aggregate Manager has no support for PerformOperationAction, and thus not for open console.");
    }

    @Override
    @ApiMethod(order=15, hint="Ask if SSH keys can be supported")
    public boolean isEditSshKeysSupported() {
        if (this.amServer != null && !this.amServer.hasFlag(Server.Flag.featurePoaUpdateSshKeys)) {
            return false;
        }
        if (this.poa_impl != null) {
            this.last_used_impl = this.poa_impl;
            return this.poa_impl.isEditSshKeysSupported();
        }
        this.last_used_impl = this.impl;
        return this.impl.isEditSshKeysSupported();
    }

    @Override
    @ApiMethod(order=16, hint="Add users and SSH keys to nodes within a slice")
    public void editSshKeys(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull Collection<UserSpec> userSpecs) throws JFedException {
        if (this.poa_impl == null) {
            throw new RuntimeException("Aggregate Manager has no support for PerformOperationAction, and thus not for editSshKeys");
        }
        this.last_used_impl = this.poa_impl;
        this.poa_impl.editSshKeys(sliceUrn, sliceCredentials, userSpecs);
    }

    @Override
    @ApiMethod(order=17, hint="Ask if Create Image is supported")
    public boolean areUserDiskImageFunctionsSupported() {
        if (this.amServer != null && !this.amServer.hasFlag(Server.Flag.featurePoaExtDiskImageOps)) {
            return false;
        }
        if (this.protoGeniAMExtensionsWrapper != null) {
            return true;
        }
        LOG.error("The server has the \"featurePoaExtDiskImageOps\" flag, but no protoGeniAMExtensionsWrapper was found!");
        return false;
    }

    @Override
    @ApiMethod(order=18, hint="Create a disk image from a node")
    public AggregateManagerWrapper.ImageInfo createImage(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull GeniUrn componentUrn, @Nonnull String imageName, boolean global, boolean updatePrepare) throws JFedException {
        if (this.protoGeniAMExtensionsWrapper == null) {
            throw new RuntimeException("operation is not supported");
        }
        return this.protoGeniAMExtensionsWrapper.createImage(sliceUrn, sliceCredentials, componentUrn, imageName, global, updatePrepare);
    }

    @Override
    @Nonnull
    public List<AggregateManagerWrapper.ImageInfo> listImages(@Nonnull List<AnyCredential> userCredentials) throws JFedException {
        if (this.protoGeniAMExtensionsWrapper == null) {
            throw new RuntimeException("operation is not supported");
        }
        List<? extends AggregateManagerWrapper.ImageInfo> images = this.protoGeniAMExtensionsWrapper.listImages(userCredentials);
        return new ArrayList<AggregateManagerWrapper.ImageInfo>(images);
    }

    @Override
    public boolean deleteImage(@Nonnull List<AnyCredential> userCredentials, @Nonnull GeniUrn imageUrn) throws JFedException {
        if (this.protoGeniAMExtensionsWrapper == null) {
            throw new RuntimeException("operation is not supported");
        }
        boolean success = this.protoGeniAMExtensionsWrapper.deleteImage(userCredentials, imageUrn);
        if (!success) {
            throw new JFedException("Did not successfully delete image");
        }
        return true;
    }

    @Override
    public void setExtraOptionsForCallsWithCredential(Map<String, ?> extraOptionsForCallsWithCredential) {
        super.setExtraOptionsForCallsWithCredential(extraOptionsForCallsWithCredential);
        this.impl.setExtraOptionsForCallsWithCredential(extraOptionsForCallsWithCredential);
        if (this.poa_impl != null) {
            this.poa_impl.setExtraOptionsForCallsWithCredential(extraOptionsForCallsWithCredential);
        }
        if (this.impl_amv2 != null) {
            this.impl_amv2.setExtraOptionsForCallsWithCredential(extraOptionsForCallsWithCredential);
        }
        if (this.impl_amv3 != null) {
            this.impl_amv3.setExtraOptionsForCallsWithCredential(extraOptionsForCallsWithCredential);
        }
    }

    @Override
    public void setSpeaksFor(List<AnyCredential> speaksForCredentials, @Nullable GeniUrn speakingForUrn) {
        super.setSpeaksFor(speaksForCredentials, speakingForUrn);
        this.impl.setSpeaksFor(speaksForCredentials, speakingForUrn);
        if (this.poa_impl != null) {
            this.poa_impl.setSpeaksFor(speaksForCredentials, speakingForUrn);
        }
        if (this.impl_amv2 != null) {
            this.impl_amv2.setSpeaksFor(speaksForCredentials, speakingForUrn);
        }
        if (this.impl_amv3 != null) {
            this.impl_amv3.setSpeaksFor(speaksForCredentials, speakingForUrn);
        }
    }

    public static class BasicAutomaticAggregateManagerWrapperFactory
    implements AutomaticAggregateManagerWrapperFactory {
        private final be.iminds.ilabt.jfed.log.Logger logger;
        private final GeniUserProvider geniUserProvider;
        private final JFedConnectionProvider connectionProvider;
        private final JFedPreferences jFedPreferences;
        @Nullable
        private List<AnyCredential> speaksForCredentials;
        @Nullable
        private GeniUrn speaksForUserUrn;

        @Inject
        public BasicAutomaticAggregateManagerWrapperFactory(be.iminds.ilabt.jfed.log.Logger logger2, GeniUserProvider geniUserProvider, JFedConnectionProvider connectionProvider, JFedPreferences jFedPreferences) {
            this.logger = logger2;
            this.geniUserProvider = geniUserProvider;
            this.connectionProvider = connectionProvider;
            this.jFedPreferences = jFedPreferences;
        }

        public BasicAutomaticAggregateManagerWrapperFactory(be.iminds.ilabt.jfed.log.Logger logger2, final @Nullable GeniUser geniUser, JFedConnectionProvider connectionProvider, JFedPreferences jFedPreferences) {
            this(logger2, new GeniUserProvider(){

                @Override
                @Nonnull
                public GeniUser getLoggedInGeniUser() {
                    return geniUser;
                }

                @Override
                public boolean isUserLoggedIn() {
                    return geniUser != null;
                }
            }, connectionProvider, jFedPreferences);
        }

        @Override
        @Nonnull
        public AutomaticAggregateManagerWrapper create(@Nonnull Server amServer) throws AggregateManagerWrapper.NoAmException {
            return this.create(this.logger, amServer);
        }

        @Override
        @Nonnull
        public AutomaticAggregateManagerWrapper create(@Nonnull be.iminds.ilabt.jfed.log.Logger altLogger, @Nonnull Server amServer) throws AggregateManagerWrapper.NoAmException {
            AutomaticAggregateManagerWrapper res = new AutomaticAggregateManagerWrapper(altLogger, this.geniUserProvider, this.connectionProvider, this.jFedPreferences, amServer);
            if (this.geniUserProvider.isUserLoggedIn() && this.geniUserProvider.getLoggedInGeniUser() instanceof GeniUserWithSpeaksFor) {
                GeniUserWithSpeaksFor geniUserWithSpeaksFor = (GeniUserWithSpeaksFor)this.geniUserProvider.getLoggedInGeniUser();
                this.setSpeaksFor(geniUserWithSpeaksFor.getSpeaksForCredentials(), geniUserWithSpeaksFor.getSpeaksForUrn());
            }
            if (this.speaksForCredentials != null || this.speaksForUserUrn != null) {
                res.setSpeaksFor(this.speaksForCredentials, this.speaksForUserUrn);
            }
            return res;
        }

        @Override
        public void setSpeaksFor(@Nullable List<AnyCredential> speaksForCredentials, @Nullable GeniUrn speakingForUrn) {
            this.speaksForCredentials = speaksForCredentials;
            this.speaksForUserUrn = speakingForUrn;
        }

        @Override
        public boolean isSpeaksFor() {
            return this.speaksForCredentials != null && !this.speaksForCredentials.isEmpty();
        }

        @Override
        @Nullable
        public List<AnyCredential> getSpeaksForCredentials() {
            return this.speaksForCredentials;
        }

        @Override
        @Nullable
        public GeniUrn getSpeaksForUserUrn() {
            return this.speaksForUserUrn;
        }
    }

    public static interface AutomaticAggregateManagerWrapperFactory {
        public AutomaticAggregateManagerWrapper create(Server var1) throws AggregateManagerWrapper.NoAmException;

        public AutomaticAggregateManagerWrapper create(be.iminds.ilabt.jfed.log.Logger var1, Server var2) throws AggregateManagerWrapper.NoAmException;

        public void setSpeaksFor(@Nullable List<AnyCredential> var1, @Nullable GeniUrn var2);

        public boolean isSpeaksFor();

        @Nullable
        public List<AnyCredential> getSpeaksForCredentials();

        @Nullable
        public GeniUrn getSpeaksForUserUrn();
    }
}

