/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.authority.legacy;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Objects;
import javax.annotation.Nonnull;

public class TargetAuthority {
    protected final GeniUrn origUrn;
    @Nonnull
    protected final GeniUrn rspecUrn;
    @Nonnull
    protected final Server serverForRspecComponentManager;
    @Nonnull
    protected final Server serverToConnect;

    public TargetAuthority(@Nonnull GeniUrn origUrn, @Nonnull Server serverForRspecComponentManager, @Nonnull Server serverToConnect) {
        this.origUrn = origUrn;
        this.serverForRspecComponentManager = serverForRspecComponentManager;
        try {
            this.rspecUrn = new GeniUrn(serverForRspecComponentManager.getDefaultComponentManagerUrn());
        }
        catch (GeniUrn.GeniUrnParseException e) {
            throw new IllegalArgumentException("Server urn did not parse", e);
        }
        this.serverToConnect = serverToConnect;
    }

    @Nonnull
    public GeniUrn getOrigUrn() {
        return this.origUrn;
    }

    @Nonnull
    public GeniUrn getRspecUrn() {
        return this.rspecUrn;
    }

    @Nonnull
    public Server getServerForRspecComponentManager() {
        return this.serverForRspecComponentManager;
    }

    @Nonnull
    public Server getServerToConnect() {
        return this.serverToConnect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetAuthority)) {
            return false;
        }
        TargetAuthority that = (TargetAuthority)o;
        if (!Objects.equals(this.origUrn, that.origUrn)) {
            return false;
        }
        return Objects.equals(this.rspecUrn, that.rspecUrn);
    }

    public int hashCode() {
        int result = this.origUrn.hashCode();
        result = 31 * result + this.rspecUrn.hashCode();
        return result;
    }
}

