/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.connection;

import be.iminds.ilabt.jfed.lowlevel.connection.HostnameAndCertificateMismatchSSLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.util.InetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AliasAllowingHostnameVerifier
implements HostnameVerifier {
    static final int DNS_NAME_TYPE = 2;
    static final int IP_ADDRESS_TYPE = 7;
    private static final Logger LOG = LoggerFactory.getLogger(AliasAllowingHostnameVerifier.class);
    private final DefaultHostnameVerifier base = new DefaultHostnameVerifier();
    private final List<String> allowedCertificateHostnameAliases;

    AliasAllowingHostnameVerifier(List<String> allowedCertificateHostnameAliases) {
        this.allowedCertificateHostnameAliases = allowedCertificateHostnameAliases;
    }

    @Override
    public boolean verify(String host, SSLSession session) {
        try {
            Certificate[] certs = session.getPeerCertificates();
            X509Certificate x509 = (X509Certificate)certs[0];
            this.verify(host, x509);
            return true;
        }
        catch (SSLException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(ex.getMessage(), ex);
            }
            return false;
        }
    }

    public void verify(String host, X509Certificate cert) throws SSLException {
        if (this.allowedCertificateHostnameAliases.contains("*")) {
            LOG.debug("Allowing all certificates for host {}, as allowedCertificateHostnameAliases contains '*'", (Object)host);
            return;
        }
        TYPE hostFormat = TYPE.DNS;
        if (InetAddressUtils.isIPv4Address(host)) {
            hostFormat = TYPE.IPv4;
        } else {
            String s2 = host;
            if (s2.startsWith("[") && s2.endsWith("]")) {
                s2 = host.substring(1, host.length() - 1);
            }
            if (InetAddressUtils.isIPv6Address(s2)) {
                hostFormat = TYPE.IPv6;
            }
        }
        int subjectType = hostFormat == TYPE.IPv4 || hostFormat == TYPE.IPv6 ? 7 : 2;
        List<String> subjectAlts = AliasAllowingHostnameVerifier.extractSubjectAlts(cert, subjectType);
        String cn = "<NOT EXAMINED>";
        try {
            X500Principal subjectPrincipal;
            if (subjectAlts != null && !subjectAlts.isEmpty()) {
                if (subjectAlts.stream().anyMatch(this.allowedCertificateHostnameAliases::contains)) {
                    LOG.debug("Allowing certificate for host {}: a subjectAlt was found in allowedCertificateHostnameAliases", (Object)host);
                    return;
                }
            }
            if ((cn = AliasAllowingHostnameVerifier.extractCN((subjectPrincipal = cert.getSubjectX500Principal()).getName("RFC2253"))) == null) {
                throw new SSLException("Certificate subject for <" + host + "> doesn't contain a common name and does not have alternative names");
            }
            if (this.allowedCertificateHostnameAliases.contains(cn)) {
                LOG.debug("Allowing certificate for host {}: cn '{}' was found in allowedCertificateHostnameAliases", (Object)host, (Object)cn);
                return;
            }
            LOG.debug("no known alias in " + this.allowedCertificateHostnameAliases + " for " + subjectAlts + " -> using default HostnameVerifier");
            this.base.verify(host, cert);
        }
        catch (SSLException ex) {
            throw new HostnameAndCertificateMismatchSSLException(host, cn, subjectAlts, this.allowedCertificateHostnameAliases, ex);
        }
    }

    static String extractCN(String subjectPrincipal) throws SSLException {
        if (subjectPrincipal == null) {
            return null;
        }
        try {
            LdapName subjectDN = new LdapName(subjectPrincipal);
            List<Rdn> rdns = subjectDN.getRdns();
            for (int i = rdns.size() - 1; i >= 0; --i) {
                Rdn rds = rdns.get(i);
                Attributes attributes = rds.toAttributes();
                Attribute cn = attributes.get("cn");
                if (cn == null) continue;
                try {
                    Object value = cn.get();
                    if (value == null) continue;
                    return value.toString();
                }
                catch (NoSuchElementException | NamingException exception) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (InvalidNameException e) {
            throw new SSLException(subjectPrincipal + " is not a valid X500 distinguished name");
        }
    }

    static List<String> extractSubjectAlts(X509Certificate cert, int subjectType) {
        Collection<List<?>> c = null;
        try {
            c = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        ArrayList<String> subjectAltList = null;
        if (c != null) {
            for (List<?> aC : c) {
                List<?> list = aC;
                int type = (Integer)list.get(0);
                if (type != subjectType) continue;
                String s2 = (String)list.get(1);
                if (subjectAltList == null) {
                    subjectAltList = new ArrayList<String>();
                }
                subjectAltList.add(s2);
            }
        }
        return subjectAltList;
    }

    static enum TYPE {
        IPv4,
        IPv6,
        DNS;

    }
}

