/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.connection;

import be.iminds.ilabt.jfed.lowlevel.connection.AliasAllowingHostnameVerifier;
import be.iminds.ilabt.jfed.lowlevel.connection.BasicHttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.BasicSfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.CommonsHttpClientXmlRpcTransportFactory;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionBuilder;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.lowlevel.connection.HandleUntrustedCallback;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.XmlRpcTypeNil;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.LoginInfo;
import be.iminds.ilabt.jfed.util.library.SSLCertificateDownloader;
import be.iminds.ilabt.jfed.util.library.SocksProxyHelper;
import be.iminds.ilabt.jfed.util.library.SshServerProxyHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConnectionBuilder
implements ConnectionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(BasicConnectionBuilder.class);
    private static final SSLConnectionSocketFactory unsafeSslSocketFactory = BasicConnectionBuilder.createUnsafeSslConnectionSocketFactory();
    private static final String PRIVATEKEY_STORE_PASS = "someotherpass";
    private static final String KEY_STORE_PASS = "somepass";
    private URL serverUrl;
    private String serverUrlString;
    private JFedConnection.DebugInfo debugInfo;
    private JFedConnection.ProxyInfo proxyInfo;
    private ConnectionConfig.Authentication authentication;
    private LoginInfo login;
    private List<X509Certificate> clientCertChain;
    private PrivateKey privateKey;
    private ConnectionConfig.Protocol protocol;
    private JFedTrustStore conTrustStore;
    private HandleUntrustedCallback handleUntrustedCallback;
    private boolean forceSshProxyDns = false;
    private int socketConnectTimeoutMs = 10000;
    private int socketReadTimeoutMs = 120000;
    private boolean hackAllowAllServerCertificates = false;
    private List<String> hackOverrideAllowedServerCertificateAlias = null;
    private final String userAgent;
    @Nonnull
    private final List<HttpResponseInterceptor> httpResponseInterceptors = new ArrayList<HttpResponseInterceptor>();

    private static SSLConnectionSocketFactory createUnsafeSslConnectionSocketFactory() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, null, null);
            return new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not create an unsafe connection manager", e);
        }
    }

    BasicConnectionBuilder() {
        this.userAgent = null;
    }

    BasicConnectionBuilder(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public void setUrl(String serverUrlString) throws MalformedURLException {
        this.serverUrlString = serverUrlString;
        this.serverUrl = new URL(serverUrlString);
    }

    @Override
    public void setUrl(URL serverUrl) {
        this.serverUrl = serverUrl;
        this.serverUrlString = serverUrl.toExternalForm();
    }

    @Override
    public void setSocketConnectTimeoutMs(int socketConnectTimeoutMs) {
        this.socketConnectTimeoutMs = socketConnectTimeoutMs;
    }

    @Override
    public void setSocketReadTimeoutMs(int socketReadTimeoutMs) {
        this.socketReadTimeoutMs = socketReadTimeoutMs;
    }

    @Override
    public void setHackAllowAllServerCertificates(boolean hackAllowAllServerCertificates) {
        this.hackAllowAllServerCertificates = hackAllowAllServerCertificates;
    }

    @Override
    public void setHackOverrideAllowedServerCertificateAlias(List<String> hackOverrideAllowedServerCertificateAlias) {
        this.hackOverrideAllowedServerCertificateAlias = hackOverrideAllowedServerCertificateAlias;
    }

    @Override
    public void setDebugInfo(JFedConnection.DebugInfo debugInfo) {
        this.debugInfo = debugInfo;
    }

    @Override
    public void setProxy(JFedConnection.ProxyInfo proxyInfo, boolean forceSshProxyDns) {
        this.proxyInfo = proxyInfo;
        this.forceSshProxyDns = forceSshProxyDns;
    }

    @Override
    public void useNoAuthentication() {
        this.authentication = ConnectionConfig.Authentication.NONE;
    }

    @Override
    public void useHttpBasicAuthentication(LoginInfo login) {
        this.authentication = ConnectionConfig.Authentication.HTTP_BASIC;
        this.login = login;
        if (login == null) {
            throw new IllegalArgumentException("Illegal argument: login == null");
        }
    }

    @Override
    public void useSslClientAuthentication(List<X509Certificate> clientCertChain, PrivateKey privateKey) {
        this.authentication = ConnectionConfig.Authentication.SSL_CLIENT_AUTH;
        this.clientCertChain = clientCertChain;
        this.privateKey = privateKey;
        if (privateKey == null) {
            throw new IllegalArgumentException("Illegal argument: privateKey == null");
        }
        if (clientCertChain == null) {
            throw new IllegalArgumentException("Illegal argument: clientCertificateChain == null");
        }
        if (clientCertChain.isEmpty()) {
            throw new IllegalArgumentException("Illegal argument: clientCertChain is empty");
        }
    }

    @Override
    public void useHttp() {
        this.protocol = ConnectionConfig.Protocol.HTTP;
    }

    @Override
    public void useHttps(JFedTrustStore conTrustStore, HandleUntrustedCallback handleUntrustedCallback) {
        this.protocol = ConnectionConfig.Protocol.HTTPS;
        this.conTrustStore = conTrustStore;
        this.handleUntrustedCallback = handleUntrustedCallback;
        if (conTrustStore == null) {
            throw new IllegalArgumentException("Illegal argument: conTrustStore == null");
        }
    }

    public void addHttpResponseInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        this.httpResponseInterceptors.add(httpResponseInterceptor);
    }

    private void check() {
        if (this.debugInfo == null) {
            throw new RuntimeException("Configuration problem: must specify debugInfo");
        }
        if (this.serverUrlString == null || this.serverUrl == null) {
            throw new RuntimeException("Configuration problem: must specify URL");
        }
        if (this.authentication == null) {
            throw new RuntimeException("Configuration problem: must specify authentication");
        }
        if (this.protocol == null) {
            throw new RuntimeException("Configuration problem: must specify HTTP or HTTPS");
        }
        if (this.protocol != ConnectionConfig.Protocol.HTTPS && this.authentication == ConnectionConfig.Authentication.SSL_CLIENT_AUTH) {
            throw new RuntimeException("Configuration problem: incompatible options: cannot do SSL client authentication without HTTPS.");
        }
    }

    private InetAddress[] dummyDnsResolver(String host) throws UnknownHostException {
        if (!Objects.equals(host, this.serverUrl.getHost())) {
            LOG.error("This hack expected resolve of \"" + this.serverUrl.getHost() + "\" but was requested to resolve \"" + host + "\". Reverting to normal resolve.");
            return SystemDefaultDnsResolver.INSTANCE.resolve(host);
        }
        return new InetAddress[]{InetAddress.getByAddress(host, new byte[]{127, 0, 0, 1})};
    }

    private HttpConParts getConnectionHttpClientAndContext() throws JFedException {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        HttpClientContext localContext = HttpClientContext.create();
        clientBuilder.setUserAgent(this.userAgent);
        clientBuilder.setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.socketConnectTimeoutMs).setSocketTimeout(this.socketReadTimeoutMs).build());
        boolean useForceSshProxyDns = this.proxyInfo instanceof JFedConnection.SshProxyInfo && this.forceSshProxyDns;
        DnsResolver dnsResolver = !useForceSshProxyDns ? SystemDefaultDnsResolver.INSTANCE : this::dummyDnsResolver;
        RegistryBuilder<ConnectionSocketFactory> socketFactoryRegistryBuilder = RegistryBuilder.create();
        if (this.protocol == ConnectionConfig.Protocol.HTTPS) {
            try {
                SSLConnectionSocketFactory sslSocketFactory;
                HostnameVerifier hostnameVerifier;
                SSLContext sslContext;
                if (this.hackAllowAllServerCertificates) {
                    sslContext = this.createUnsafeSslContext();
                    hostnameVerifier = NoopHostnameVerifier.INSTANCE;
                } else {
                    sslContext = this.createSslContext();
                    hostnameVerifier = this.createHostnameVerifier();
                }
                if (this.proxyInfo != null && this.proxyInfo instanceof JFedConnection.SshProxyInfo) {
                    JFedConnection.SshProxyInfo sshProxyInfo = (JFedConnection.SshProxyInfo)this.proxyInfo;
                    LOG.debug("Using SSH Proxy for connection: " + sshProxyInfo.getHostname());
                    if (useForceSshProxyDns) {
                        int serverPort = this.serverUrl.getPort() <= 0 ? this.serverUrl.getDefaultPort() : this.serverUrl.getPort();
                        sslSocketFactory = new SshServerProxyHelper.SslOverSshProxySocketFactory(sslContext, hostnameVerifier, sshProxyInfo, this.serverUrl.getHost(), serverPort);
                    } else {
                        sslSocketFactory = new SshServerProxyHelper.SslOverSshProxySocketFactory(sslContext, hostnameVerifier, sshProxyInfo);
                    }
                } else {
                    sslSocketFactory = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
                }
                socketFactoryRegistryBuilder.register("https", sslSocketFactory);
            }
            catch (Exception e) {
                throw new JFedException("Error creating SSL connection to " + this.serverUrlString, e);
            }
        }
        if (this.protocol == ConnectionConfig.Protocol.HTTP) {
            ConnectionSocketFactory socketFactory;
            if (this.proxyInfo != null && this.proxyInfo instanceof JFedConnection.SshProxyInfo) {
                JFedConnection.SshProxyInfo sshProxyInfo = (JFedConnection.SshProxyInfo)this.proxyInfo;
                LOG.debug("Using SSH Proxy HTTP connection: " + sshProxyInfo.getHostname());
                int serverPort = this.serverUrl.getPort() <= 0 ? this.serverUrl.getDefaultPort() : this.serverUrl.getPort();
                socketFactory = new SshServerProxyHelper.PlainHttpOverSshProxySocketFactory(sshProxyInfo, useForceSshProxyDns ? this.serverUrl.getHost() : null, useForceSshProxyDns ? Integer.valueOf(serverPort) : null);
            } else {
                socketFactory = BasicConnectionBuilder.isSystemSocksProxyEnabled() ? new SocksProxyHelper.SOCKSConnectionSocketFactory() : PlainConnectionSocketFactory.INSTANCE;
            }
            socketFactoryRegistryBuilder.register("http", socketFactory);
        }
        PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager(socketFactoryRegistryBuilder.build(), dnsResolver);
        pool.setValidateAfterInactivity(-1);
        clientBuilder.setConnectionManager(pool);
        if (this.authentication == ConnectionConfig.Authentication.HTTP_BASIC) {
            int serverPort = this.serverUrl.getPort() <= 0 ? this.serverUrl.getDefaultPort() : this.serverUrl.getPort();
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.serverUrl.getHost(), serverPort), new UsernamePasswordCredentials(this.login.getUsername(), this.login.getPassword()));
            clientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            HttpHost targetHost = new HttpHost(this.serverUrl.getHost(), serverPort, this.protocol == ConnectionConfig.Protocol.HTTP ? "http" : "https");
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, basicAuth);
            localContext.setAuthCache(authCache);
        }
        return new HttpConParts(clientBuilder, localContext);
    }

    @Nonnull
    private HostnameVerifier createHostnameVerifier() {
        ArrayList<String> allowedCertificateHostnameAliases = this.hackOverrideAllowedServerCertificateAlias != null ? new ArrayList<String>(this.hackOverrideAllowedServerCertificateAlias) : new ArrayList<String>(this.conTrustStore.getAllowedServerCertificateHostnameAliases());
        LOG.debug("Creating HostnameVerifier with allowedCertificateHostnameAliases=" + allowedCertificateHostnameAliases + " for serverUrl=" + this.serverUrlString);
        return new AliasAllowingHostnameVerifier(allowedCertificateHostnameAliases);
    }

    private SSLContext createUnsafeSslContext() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new X509TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }}, new SecureRandom());
        return context;
    }

    private SSLContext createSslContext() throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException, JFedException, KeyManagementException, UnrecoverableKeyException {
        TrustStrategy trustStrategy;
        KeyStore trustStore = this.conTrustStore.getTrustStore();
        KeyStore keyStore = this.authentication == ConnectionConfig.Authentication.SSL_CLIENT_AUTH ? this.createKeyStore(trustStore) : null;
        if (this.handleUntrustedCallback != null) {
            TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmfactory.init(trustStore);
            TrustManager[] tms = tmfactory.getTrustManagers();
            trustStrategy = (certificates, authType) -> {
                for (int i = 0; i < tms.length; ++i) {
                    TrustManager tm = tms[i];
                    if (!(tm instanceof X509TrustManager)) continue;
                    try {
                        ((X509TrustManager)tm).checkServerTrusted(certificates, authType);
                        return true;
                    }
                    catch (CertificateException certificateException) {
                        // empty catch block
                    }
                }
                SSLCertificateDownloader.SSLCertificateJFedInfo certInfo = new SSLCertificateDownloader.SSLCertificateJFedInfo(certificates[0], this.serverUrl, this.serverUrl.getHost());
                return this.handleUntrustedCallback.trust(certInfo);
            };
            LOG.debug("using home-made trustStrategy, this is far from perfect! Might be insecure!");
            LOG.debug("adding SpyingTrustStrategy");
            trustStrategy = new SpyingTrustStrategy(trustStrategy);
        } else {
            trustStrategy = null;
        }
        return SSLContexts.custom().useProtocol("TLS").setSecureRandom(new SecureRandom()).loadKeyMaterial(keyStore, PRIVATEKEY_STORE_PASS.toCharArray()).loadTrustMaterial(trustStore, trustStrategy).build();
    }

    private static boolean isSystemSocksProxyEnabled() {
        return Objects.equals(System.getProperty("proxySet"), "true") && System.getProperty("socksProxyHost") != null;
    }

    @Nullable
    private KeyStore createKeyStore(KeyStore trustStore) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException, JFedException {
        int i;
        KeyStore keyStore = KeyStore.getInstance("JKS", "SUN");
        keyStore.load(null, KEY_STORE_PASS.toCharArray());
        Certificate[] certs = new Certificate[this.clientCertChain.size()];
        for (i = 0; i < this.clientCertChain.size(); ++i) {
            X509Certificate c = this.clientCertChain.get(i);
            certs[i] = c;
            try {
                c.checkValidity(new Date());
                continue;
            }
            catch (CertificateExpiredException e) {
                throw new JFedException("Certificate " + i + " (of " + this.clientCertChain.size() + ") in the user certificate chain has expired. NotAfter=" + c.getNotAfter() + " now=" + new Date());
            }
            catch (CertificateNotYetValidException e) {
                throw new JFedException("Certificate " + i + " (of " + this.clientCertChain.size() + ") in the user certificate chain is not yet valid. NotBefore=" + c.getNotBefore() + " now=" + new Date());
            }
        }
        keyStore.setKeyEntry("authority", this.privateKey, PRIVATEKEY_STORE_PASS.toCharArray(), certs);
        for (i = 0; i < this.clientCertChain.size(); ++i) {
            trustStore.setCertificateEntry("clientCertificate" + i, this.clientCertChain.get(i));
        }
        return keyStore;
    }

    @Override
    public SfaConnection buildSfaConnection() throws JFedException {
        this.check();
        HttpConParts httpConParts = this.getConnectionHttpClientAndContext();
        if (!this.httpResponseInterceptors.isEmpty()) {
            for (HttpResponseInterceptor httpResponseInterceptor : this.httpResponseInterceptors) {
                httpConParts.getClientBuilder().addInterceptorLast(httpResponseInterceptor);
            }
        }
        try {
            XmlRpcClient xmlRpcClient = new XmlRpcClient();
            xmlRpcClient.setTypeFactory(new XmlRpcTypeNil(xmlRpcClient));
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(this.serverUrl);
            xmlRpcClient.setConfig(config);
            CommonsHttpClientXmlRpcTransportFactory xmlRpcTransportFactory = new CommonsHttpClientXmlRpcTransportFactory(xmlRpcClient, httpConParts.getClientBuilder(), httpConParts.getLocalContext());
            xmlRpcClient.setTransportFactory(xmlRpcTransportFactory);
            ConnectionConfig connectionConfig = this.getCurrentConnectionConfig(ConnectionConfig.Type.SFA);
            BasicSfaConnection res = new BasicSfaConnection(connectionConfig, xmlRpcTransportFactory, xmlRpcClient);
            return res;
        }
        catch (Exception e) {
            throw new JFedException("Error creating XmlRpcClient: " + e.getMessage(), e);
        }
    }

    @Override
    public HttpConnection buildHttpConnection() throws JFedException {
        this.check();
        HttpConParts httpConParts = this.getConnectionHttpClientAndContext();
        if (!this.httpResponseInterceptors.isEmpty()) {
            for (HttpResponseInterceptor httpResponseInterceptor : this.httpResponseInterceptors) {
                httpConParts.getClientBuilder().addInterceptorLast(httpResponseInterceptor);
            }
        }
        ConnectionConfig connectionConfig = this.getCurrentConnectionConfig(ConnectionConfig.Type.HTTP);
        BasicHttpConnection res = new BasicHttpConnection(connectionConfig, httpConParts.getClientBuilder(), new HttpClientContext(), httpConParts.getLocalContext());
        return res;
    }

    @Override
    public ConnectionConfig getCurrentConnectionConfig(ConnectionConfig.Type type) {
        return new ConnectionConfig(this.serverUrl, this.debugInfo, this.proxyInfo, this.authentication, this.login, this.clientCertChain, this.privateKey, this.protocol, this.conTrustStore, this.handleUntrustedCallback, type);
    }

    @Override
    public void set(ConnectionConfig config) {
        this.serverUrlString = config.getServerUrlString();
        this.debugInfo = config.getDebugInfo();
        this.proxyInfo = config.getProxyInfo();
        this.authentication = config.getAuthentication();
        this.login = config.getLogin();
        this.clientCertChain = config.getClientCertChain();
        this.privateKey = config.getPrivateKey();
        this.protocol = config.getProtocol();
        this.conTrustStore = config.getConTrustStore();
        this.handleUntrustedCallback = config.getHandleUntrustedCallback();
    }

    private static class HttpConParts {
        private final HttpClientBuilder clientBuilder;
        private final HttpContext localContext;

        private HttpConParts(HttpClientBuilder clientBuilder, HttpContext localContext) {
            this.clientBuilder = clientBuilder;
            this.localContext = localContext;
        }

        public HttpClientBuilder getClientBuilder() {
            return this.clientBuilder;
        }

        public HttpContext getLocalContext() {
            return this.localContext;
        }
    }

    private static class SpyingTrustStrategy
    implements TrustStrategy {
        private final TrustStrategy orig;
        public X509Certificate[] chain;
        private JFedConnection connection;

        public SpyingTrustStrategy(TrustStrategy orig) {
            this.orig = orig;
        }

        @Override
        public boolean isTrusted(X509Certificate[] certificate, String authType) throws CertificateException {
            if (certificate != null && certificate.length > 0) {
                this.chain = certificate;
                if (this.connection != null) {
                    this.connection.registerServerCertficates(this.chain);
                }
            }
            return this.orig.isTrusted(certificate, authType);
        }

        public void setConnection(JFedConnection connection) {
            LOG.debug("registering connection to SpyingTrustStrategy");
            this.connection = connection;
            if (this.chain != null) {
                connection.registerServerCertficates(this.chain);
            }
        }
    }

    public static class INSECURE_TRUSTALL_HandleUntrustedCallback
    implements HandleUntrustedCallback {
        public INSECURE_TRUSTALL_HandleUntrustedCallback() {
            LOG.warn("SECURITY WARNING: constructing INSECURE_TRUSTALL_HandleUntrustedCallback");
        }

        @Override
        public boolean trust(SSLCertificateDownloader.SSLCertificateJFedInfo sSLCertificateJFedInfo) {
            return true;
        }
    }
}

