/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.connection;

import be.iminds.ilabt.jfed.lowlevel.connection.GeniResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetailsWithCodeValueError;
import be.iminds.ilabt.jfed.lowlevel.connection.XmlRpcApiCallReply;

public class JFedException
extends Exception {
    private final XMLRPCCallDetails xmlRpcResult;
    private final GeniResponseCode geniResponseCode;
    private final XmlRpcApiCallReply reply;

    public JFedException(String s2, Throwable ex, XMLRPCCallDetails xmlRpcResult, GeniResponseCode geniResponseCode) {
        super(s2, ex);
        this.xmlRpcResult = xmlRpcResult;
        this.geniResponseCode = geniResponseCode;
        this.reply = null;
    }

    public JFedException(String s2, Throwable ex, XMLRPCCallDetails xmlRpcResult) {
        super(s2, ex);
        this.xmlRpcResult = xmlRpcResult;
        this.geniResponseCode = null;
        this.reply = null;
    }

    public JFedException(String s2, JFedException ex) {
        super(s2, ex);
        this.xmlRpcResult = ex.getXmlRpcResult();
        this.geniResponseCode = ex.getGeniResponseCode();
        this.reply = ex.reply;
    }

    public JFedException(String s2, Throwable ex) {
        super(s2, ex);
        this.xmlRpcResult = null;
        this.geniResponseCode = null;
        this.reply = null;
    }

    public JFedException(String s2, XMLRPCCallDetails xmlRpcResult, GeniResponseCode geniResponseCode) {
        super(s2);
        this.xmlRpcResult = xmlRpcResult;
        this.geniResponseCode = geniResponseCode;
        this.reply = null;
    }

    public JFedException(String s2) {
        super(s2);
        this.xmlRpcResult = null;
        this.geniResponseCode = null;
        this.reply = null;
    }

    public JFedException(String s2, XmlRpcApiCallReply reply) {
        super(s2);
        this.xmlRpcResult = reply.getXMLRPCCallDetails();
        this.geniResponseCode = reply.getGeniResponseCode();
        this.reply = reply;
    }

    public XMLRPCCallDetails getXmlRpcResult() {
        return this.xmlRpcResult;
    }

    public XMLRPCCallDetailsWithCodeValueError getXmlRpcResultWithCodeValueError() {
        if (this.xmlRpcResult == null) {
            return null;
        }
        if (this.xmlRpcResult instanceof XMLRPCCallDetailsWithCodeValueError) {
            return (XMLRPCCallDetailsWithCodeValueError)this.xmlRpcResult;
        }
        return null;
    }

    public GeniResponseCode getGeniResponseCode() {
        return this.geniResponseCode;
    }

    public XmlRpcApiCallReply getXmlRpcReply() {
        return this.reply;
    }

    public SfaApiCallReply getSfaReply() {
        if (this.reply == null || !(this.reply instanceof SfaApiCallReply)) {
            return null;
        }
        return (SfaApiCallReply)this.reply;
    }

    @Override
    public String toString() {
        if (this.xmlRpcResult != null) {
            return super.toString() + " GeniException.XmlRpcResult=" + this.xmlRpcResult + "}";
        }
        return super.toString();
    }

    @Override
    public String getMessage() {
        Object message = super.getMessage();
        if (this.reply != null) {
            message = (String)message + " reply={code=" + this.reply.getGeniResponseCode() + ", output='" + this.reply.getOutput() + "', valueIsNull=" + (this.reply.getValue() != null ? "false" : "true") + "}";
        }
        return message;
    }
}

