/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.ssh_key_info.pref_ssh_key_info;

import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty.PuTTYPrivateKeyFile;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.PermanentFile;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpContentFile;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpFile;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PreferencesPuttySshKeyInfo
implements PuTTYFilesKeyInfo,
SshFilesKeyInfo {
    @Nonnull
    private final File ppkFile;
    @Nonnull
    private final PuTTYPrivateKeyFile ppk;
    @Nonnull
    private final PublicKey publicKey;
    private PrivateKey privateKey;

    PreferencesPuttySshKeyInfo(@Nonnull File ppkFile, @Nonnull PuTTYPrivateKeyFile ppk) {
        this.ppkFile = ppkFile;
        this.ppk = ppk;
        this.publicKey = ppk.getPublicKey();
        this.privateKey = !ppk.isEncrypted() ? ppk.getPrivateKey() : null;
    }

    @Override
    public boolean canReturnLockedPrivateKeyFile() {
        return false;
    }

    @Override
    public TmpFile getPrivateKeyFile() {
        return this.getUnencryptedPrivateKeyFile();
    }

    @Override
    public boolean canReturnLockedPuttyKeyFile() {
        return true;
    }

    @Override
    public TmpFile getPuttyKeyFile() {
        return new PermanentFile(this.ppkFile);
    }

    @Override
    public TmpFile getUnencryptedPrivateKeyFile() {
        String pemContent = new String(KeyUtil.privateKeyToAnyPem(this.ppk.getPrivateKey()));
        return new TmpContentFile("sskKeyPrefUE", ".pem", pemContent);
    }

    @Override
    public TmpFile getUnlockedPuttyKeyFile() {
        return null;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.ppk.getComment();
    }

    @Override
    public boolean hasUnencryptedPrivateKey() {
        return false;
    }

    @Override
    public boolean isLocked() {
        return this.ppk.isEncrypted();
    }

    @Override
    public boolean unlock(char[] password) {
        if (this.ppk.unlock(new String(password))) {
            this.privateKey = this.ppk.getPrivateKey();
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PuTTYPrivateKeyFile getPPK() {
        return this.ppk;
    }
}

