/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.stitching;

import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingData;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Element;

public class AdvertisementStitchInfo {
    private final String aggregateId;
    private final String aggregateUrl;
    private final String aggregateType;
    private final String nodeId;
    private final String portId;
    private final String linkId;
    private final String linkCapacity;
    private final String remoteLinkId;
    private final String vlanRangeAvailability;
    private final boolean vlanTranslation;

    private AdvertisementStitchInfo(String aggregateId, String aggregateUrl, String aggregateType, String nodeId, String portId, String linkId, String linkCapacity, String remoteLinkId, String vlanRangeAvailability, boolean vlanTranslation) {
        this.aggregateId = aggregateId;
        this.aggregateUrl = aggregateUrl;
        this.aggregateType = aggregateType;
        this.nodeId = nodeId;
        this.portId = portId;
        this.linkId = linkId;
        this.linkCapacity = linkCapacity;
        this.remoteLinkId = remoteLinkId;
        this.vlanRangeAvailability = vlanRangeAvailability;
        this.vlanTranslation = vlanTranslation;
    }

    public static List<AdvertisementStitchInfo> parse(String advertisementRspec) {
        ArrayList<AdvertisementStitchInfo> res = new ArrayList<AdvertisementStitchInfo>();
        Element stitchingElement = StitchingData.extractStitchingElementFromRspec(advertisementRspec);
        assert (stitchingElement != null) : "no stitching data in advertisement RSpec";
        List<Element> aggregateEls = XmlUtil.getDomElementChildElementsNS(stitchingElement, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "aggregate");
        for (Element aggregateEl : aggregateEls) {
            String aggregateId = aggregateEl.getAttribute("id");
            String aggregateUrl = aggregateEl.getAttribute("url");
            String aggregateType = XmlUtil.getDomElementFirstChildElementText(aggregateEl, "aggregatetype");
            List<Element> nodeEls = XmlUtil.getDomElementChildElementsNS(stitchingElement, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "node");
            for (Element nodeEl : nodeEls) {
                String nodeId = nodeEl.getAttribute("id");
                List<Element> portEls = XmlUtil.getDomElementChildElementsNS(stitchingElement, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "port");
                for (Element portEl : portEls) {
                    String portId = portEl.getAttribute("id");
                    List<Element> linkEls = XmlUtil.getDomElementChildElementsNS(stitchingElement, "http://hpn.east.isi.edu/rspec/ext/stitch/0.1/", "link");
                    for (Element linkEl : linkEls) {
                        String linkId = linkEl.getAttribute("id");
                        String linkCapacity = XmlUtil.getDomElementFirstChildElementText(linkEl, "capacity");
                        String remoteLinkId = XmlUtil.getDomElementFirstChildElementText(linkEl, "remoteLinkId");
                        Element scDescriptorEl = XmlUtil.getDomElementFirstChildElement(linkEl, "switchingCapabilityDescriptor");
                        Element scSpecificInfoEl = XmlUtil.getDomElementFirstChildElement(scDescriptorEl, "switchingCapabilitySpecificInfo");
                        Element scSpecificInfo_L2scEl = XmlUtil.getDomElementFirstChildElement(scSpecificInfoEl, "switchingCapabilitySpecificInfo_L2sc");
                        Element vlanRangeAvailabilityEl = XmlUtil.getDomElementFirstChildElement(scSpecificInfo_L2scEl, "vlanRangeAvailability");
                        Element vlanTranslationEl = XmlUtil.getDomElementFirstChildElement(scSpecificInfo_L2scEl, "vlanTranslation");
                        String vlanRangeAvailability = vlanRangeAvailabilityEl.getTextContent();
                        boolean vlanTranslation = Objects.equals(TextUtil.objectToBoolean(vlanTranslationEl.getTextContent()), Boolean.TRUE);
                        res.add(new AdvertisementStitchInfo(aggregateId, aggregateUrl, aggregateType, nodeId, portId, linkId, linkCapacity, remoteLinkId, vlanRangeAvailability, vlanTranslation));
                    }
                }
            }
        }
        return res;
    }

    public String getAggregateId() {
        return this.aggregateId;
    }

    public String getAggregateUrl() {
        return this.aggregateUrl;
    }

    public String getAggregateType() {
        return this.aggregateType;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getPortId() {
        return this.portId;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getLinkCapacity() {
        return this.linkCapacity;
    }

    public String getRemoteLinkId() {
        return this.remoteLinkId;
    }

    public String getVlanRangeAvailability() {
        return this.vlanRangeAvailability;
    }

    public boolean isVlanTranslation() {
        return this.vlanTranslation;
    }
}

