/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.stitching;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.stitching.AdvertisementStitchInfo;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingData;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingHopData;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class StitchingCallData {
    private final Logger log;
    private final GeniUrn authUrn;
    private final String authUrnString;
    private final Server server;
    private final List<StitchingHopData> hopData = new ArrayList<StitchingHopData>();
    private final List<StitchingCallData> dependencies = new ArrayList<StitchingCallData>();
    private final List<StitchingCallData> dependingOnThis = new ArrayList<StitchingCallData>();
    private final Set<Integer> unavailableVlans = new HashSet<Integer>();
    private boolean sawAdvertisementRspec = false;
    private State state = State.NONE;

    public StitchingCallData(String authUrnString, String authUrlString, TestbedInfoSource testbedInfoSource, Logger log) {
        this.log = log == null ? LoggerFactory.getLogger(StitchingCallData.class) : log;
        this.authUrnString = authUrnString;
        this.authUrn = GeniUrn.parse(authUrnString);
        assert (this.authUrn != null);
        Server aggAuth = testbedInfoSource.getByUrnExact(authUrnString);
        if (aggAuth.getDefaultComponentManagerUrn() != null && !Objects.equals(authUrnString, aggAuth.getDefaultComponentManagerUrn())) {
            this.log.info("Created StitchingCallData for " + authUrnString + "  with new auth urn=" + aggAuth.getDefaultComponentManagerUrn());
        } else {
            this.log.info("Created StitchingCallData for " + authUrnString);
        }
        this.server = aggAuth;
    }

    public void addHopData(StitchingHopData hop) {
        assert (!this.hopData.contains(hop));
        this.hopData.add(hop);
    }

    public List<StitchingHopData> getAllHopData() {
        return this.hopData;
    }

    public void linkDeps(Collection<StitchingCallData> allData) {
        for (StitchingCallData d : allData) {
            if (d == this || this.dependencies.contains(d)) continue;
            for (StitchingHopData othersHop : d.hopData) {
                for (StitchingHopData myHop : this.hopData) {
                    if (!myHop.getDependencies().contains(othersHop) || this.dependencies.contains(d)) continue;
                    this.dependencies.add(d);
                    d.dependingOnThis.add(this);
                }
            }
        }
    }

    public void processManifestRspec(String manifestRspec) {
        Element stitchingElement = StitchingData.extractStitchingElementFromRspec(manifestRspec, this.log);
        assert (stitchingElement != null) : "No stitching data in manifest RSpec";
        for (StitchingHopData hop : this.hopData) {
            hop.overwriteWithManifestRspec(manifestRspec, (Element)stitchingElement.cloneNode(true));
        }
    }

    public void exogeniBugWorkAround_registerVlan(int vlan) {
        this.hopData.stream().filter(hop -> Objects.equals(hop.getAggregateUrn(), this.authUrnString)).forEach(hop -> hop.exogeniBugWorkAround_registerManifestVlan(vlan));
    }

    public boolean setVlanUnavailable(int vlan) {
        boolean depFailure;
        this.log.trace("setVlanUnavailable({})", (Object)vlan);
        this.unavailableVlans.add(vlan);
        do {
            depFailure = false;
            HashMap vlansUsedByHopUrn = new HashMap();
            for (StitchingHopData stitchingHopData : this.hopData) {
                Integer suggestedVlan;
                this.log.trace("hop=" + stitchingHopData.getHopUrn() + "  suggestedVlan=" + stitchingHopData.getSuggestedVlan());
                HashSet<Integer> s2 = (HashSet<Integer>)vlansUsedByHopUrn.get(stitchingHopData.getHopUrn());
                if (s2 == null) {
                    s2 = new HashSet<Integer>();
                }
                if ((suggestedVlan = stitchingHopData.getSuggestedVlan()) != null) {
                    s2.add(suggestedVlan);
                }
                vlansUsedByHopUrn.put(stitchingHopData.getHopUrn(), s2);
            }
            this.log.trace("vlansUsedByHopUrn=" + vlansUsedByHopUrn);
            ArrayList<StitchingHopData> changedHops = new ArrayList<StitchingHopData>();
            for (StitchingHopData hop3 : this.hopData) {
                Set sameHopVlans = (Set)vlansUsedByHopUrn.get(hop3.getHopUrn());
                Integer origVlan = hop3.getSuggestedVlan();
                HashSet<Integer> allForbiddenVLANs = new HashSet<Integer>(sameHopVlans);
                if (origVlan != null) {
                    allForbiddenVLANs.remove(origVlan);
                }
                allForbiddenVLANs.addAll(this.unavailableVlans);
                this.log.debug("hop " + hop3.getHopUrn() + " current suggestion=" + hop3.getSuggestedVlan() + " updateSuggestedVlan: forbidden=" + allForbiddenVLANs);
                if (origVlan == null || allForbiddenVLANs.contains(origVlan)) {
                    Integer foundVlan = hop3.updateSuggestedVlan(allForbiddenVLANs, null);
                    this.log.debug("    updated hop VLAN to foundVlan={}", (Object)foundVlan);
                    if (foundVlan == null) {
                        return false;
                    }
                    sameHopVlans.add(foundVlan);
                    if (origVlan != null && !Objects.equals(foundVlan, origVlan)) {
                        sameHopVlans.remove(origVlan);
                    }
                    changedHops.add(hop3);
                    continue;
                }
                this.log.debug("   leaving hop VLAN unchanged");
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(vlan);
            while (!changedHops.isEmpty()) {
                ArrayList<StitchingHopData> curChangedHops = changedHops;
                changedHops = new ArrayList();
                for (StitchingHopData hop4 : curChangedHops) {
                    List<StitchingHopData> dependentHops = hop4.getDependingOnThis();
                    for (StitchingHopData dependantHop : dependentHops) {
                        Integer foundVlan = dependantHop.updateSuggestedVlan(hashSet, hop4.getSuggestedVlan());
                        if (foundVlan == null) {
                            this.unavailableVlans.add(hop4.getSuggestedVlan());
                            depFailure = true;
                            if (dependantHop.getAvailableVlansString().isEmpty()) {
                                return false;
                            }
                        }
                        changedHops.add(dependantHop);
                    }
                }
            }
        } while (depFailure);
        return true;
    }

    public Set<Integer> getUnavailableVlans() {
        return Collections.unmodifiableSet(this.unavailableVlans);
    }

    public List<Integer> getSuggestedVlans() {
        return this.hopData.stream().map(StitchingHopData::getSuggestedVlan).distinct().collect(Collectors.toList());
    }

    public boolean isAllocated() {
        if (this.getServer().isEdgeVlan()) {
            return true;
        }
        return this.state == State.ALLOCATED;
    }

    public void setState(State newState) {
        this.state = newState;
        if (newState == State.ALLOCATED || newState == State.ALLOCATING) {
            for (StitchingCallData dep : this.dependencies) {
                assert (dep.isAllocated() || dep.getServer().isEdgeVlan());
            }
        }
    }

    public State getState() {
        return this.state;
    }

    public boolean areAllDepsReady() {
        for (StitchingCallData dep : this.dependencies) {
            if (dep.isAllocated() || dep.getServer().isEdgeVlan()) continue;
            return false;
        }
        return true;
    }

    public boolean needsAdvertisementRspec() {
        if (this.dependencies.isEmpty()) {
            return false;
        }
        if (!this.getServer().hasFlag(Server.Flag.featureStitchingAdvertisementRspecUptodate)) {
            return false;
        }
        return !this.sawAdvertisementRspec;
    }

    public void seeAdvertismentRspec(@Nullable String rspec) {
        this.sawAdvertisementRspec = true;
        if (rspec != null) {
            List<AdvertisementStitchInfo> advertisementStitchInfos = AdvertisementStitchInfo.parse(rspec);
            for (StitchingHopData hop : this.hopData) {
                AdvertisementStitchInfo bestMatchingInfo = null;
                for (AdvertisementStitchInfo info : advertisementStitchInfos) {
                    if (bestMatchingInfo != null || !Objects.equals(info.getLinkId(), hop.getHopUrn())) continue;
                    bestMatchingInfo = info;
                }
                if (bestMatchingInfo == null) continue;
                hop.processAdvertismentInfo(bestMatchingInfo.getVlanRangeAvailability());
            }
        }
    }

    public boolean areAllDependingOnThisReady() {
        for (StitchingCallData dep : this.dependingOnThis) {
            if (!dep.getServer().hasFlag(Server.Flag.featureStitchingAdvertisementRspecUptodate) || dep.sawAdvertisementRspec) continue;
            return false;
        }
        return true;
    }

    public List<StitchingCallData> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public List<StitchingCallData> getDependingOnThis() {
        return Collections.unmodifiableList(this.dependingOnThis);
    }

    public GeniUrn getAuthUrn() {
        return this.authUrn;
    }

    public String getAuthUrnString() {
        return this.authUrnString;
    }

    public Server getServer() {
        return this.server;
    }

    public String toString() {
        List depUrns = this.dependencies.stream().map(StitchingCallData::getAuthUrnString).collect(Collectors.toList());
        Object hopDataString = "[\n";
        for (StitchingHopData stitchingHopData : this.hopData) {
            hopDataString = (String)hopDataString + TextUtil.indent(4, stitchingHopData + ",\n");
        }
        hopDataString = (String)hopDataString + "]";
        Object res = "\"StitchingCallData\" : {\n";
        res = StitchingCallData.toStringHelper((String)res, "authUrnString", this.authUrnString);
        res = StitchingCallData.toStringHelper((String)res, "hopDataString", hopDataString);
        res = StitchingCallData.toStringHelper((String)res, "dependencies (urns)", depUrns);
        res = (String)res + "}\n";
        return res;
    }

    private static String toStringHelper(String res, String objectName, Object objectValue) {
        if (objectValue == null) {
            return res;
        }
        return res + TextUtil.indent(4, "\"" + objectName + "\" : \"" + objectValue + "\"") + "\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StitchingCallData that = (StitchingCallData)o;
        assert (this.authUrnString.equals(that.authUrnString) == (this == o));
        return Objects.equals(this.authUrnString, that.authUrnString);
    }

    public int hashCode() {
        return this.authUrnString.hashCode();
    }

    public static enum State {
        NONE,
        ALLOCATED,
        ALLOCATING,
        LISTING_RESOURCES,
        ALLOCATING_BUT_MUST_DELETE,
        MUST_DELETE,
        DELETING;

    }
}

