/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.user;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.credential.AbacCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserWithSpeaksFor;
import be.iminds.ilabt.jfed.lowlevel.user.SimpleGeniUser;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidLoginException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGeniUserWithSpeaksFor
extends SimpleGeniUser
implements GeniUserWithSpeaksFor {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleGeniUserWithSpeaksFor.class);
    protected final List<AnyCredential> speaksForCredentials;
    private GeniUrn speaksForUrn;
    private List<X509Certificate> speaksForCertificateChain;
    private PublicKey speaksForPublicKey;

    public SimpleGeniUserWithSpeaksFor(@Nullable Server userAuthorityServer, @Nonnull GeniUrn userUrn, @Nonnull String keyCertContent, @Nullable char[] keyPass, @Nullable File certificateKeyFile, @Nullable File privateKeyFile, @Nonnull List<AnyCredential> speaksForCredentials) throws InvalidSpeaksForException, InvalidLoginException {
        super(userAuthorityServer, userUrn, keyCertContent, keyPass, certificateKeyFile, privateKeyFile);
        this.speaksForCredentials = speaksForCredentials;
        assert (!speaksForCredentials.isEmpty());
        this.deriveSpeaksForDetailsFromCredentials();
        assert (this.speaksForUrn != null);
        assert (this.speaksForCertificateChain != null);
        assert (this.speaksForPublicKey != null);
    }

    public SimpleGeniUserWithSpeaksFor(@Nullable Server userAuthorityServer, @Nonnull GeniUrn userUrn, @Nonnull List<X509Certificate> certificateChain, @Nonnull PrivateKey privateKey, @Nullable File certificateKeyFile, @Nullable File privateKeyFile, @Nonnull List<AnyCredential> speaksForCredentials) throws InvalidSpeaksForException {
        super(userAuthorityServer, userUrn, certificateChain, privateKey, certificateKeyFile, privateKeyFile);
        this.speaksForCredentials = speaksForCredentials;
        assert (!speaksForCredentials.isEmpty());
        this.deriveSpeaksForDetailsFromCredentials();
        assert (this.speaksForUrn != null);
        assert (this.speaksForCertificateChain != null);
        assert (this.speaksForPublicKey != null);
    }

    public SimpleGeniUserWithSpeaksFor(@Nonnull GeniUserWithSpeaksFor geniUser) {
        super(geniUser);
        this.speaksForCredentials = geniUser.getSpeaksForCredentials();
        this.speaksForCertificateChain = geniUser.getSpeaksForUserCertificateChain();
        this.speaksForPublicKey = geniUser.getSpeaksForUserPublicKey();
        this.speaksForUrn = geniUser.getSpeaksForUrn();
    }

    @Override
    @Nonnull
    public List<AnyCredential> getSpeaksForCredentials() {
        return this.speaksForCredentials;
    }

    @Override
    @Nonnull
    public GeniUrn getSpeaksForUrn() {
        return this.speaksForUrn;
    }

    @Override
    @Nonnull
    public List<X509Certificate> getSpeaksForUserCertificateChain() {
        return this.speaksForCertificateChain;
    }

    @Override
    @Nonnull
    public PublicKey getSpeaksForUserPublicKey() {
        return this.speaksForPublicKey;
    }

    private void deriveSpeaksForDetailsFromCredentials() throws InvalidSpeaksForException {
        if (this.speaksForCredentials == null || this.speaksForCredentials.isEmpty()) {
            return;
        }
        for (AnyCredential anyS4Credential : this.speaksForCredentials) {
            if (anyS4Credential == null) {
                throw new InvalidSpeaksForException("Experiment.speaksForCredential is not a valid credential. (null after parsing)");
            }
            if (!(anyS4Credential instanceof AbacCredential)) {
                if (!(anyS4Credential instanceof SfaCredential) || anyS4Credential.isSpeaksFor()) continue;
                throw new InvalidSpeaksForException("Experiment.speaksForCredential is a valid " + anyS4Credential.getClass().getName() + " credential, but only ABAC speaksFor credentials are currently supported. Additionally, the SfaCredential does not appear to be a speaksFor credential.");
            }
            AbacCredential s4abac = (AbacCredential)anyS4Credential;
            if (!s4abac.isSpeaksFor()) {
                throw new InvalidSpeaksForException("Experiment.speaksForCredential is a valid ABAC credential, but it is not a speaksFor credential (which is required).");
            }
            Date now = new Date();
            if (s4abac.getExpiresDate() != null && s4abac.getExpiresDate().before(now)) {
                throw new InvalidSpeaksForException("Experiment.speaksForCredential expired at " + s4abac.getExpires());
            }
            try {
                this.speaksForCertificateChain = s4abac.getSignerCertificates();
                if (this.speaksForCertificateChain == null) {
                    throw new InvalidSpeaksForException("Experiment.speaksForCredential is not a valid ABAC speaksFor credential: the signer certificate(s) could not be found");
                }
            }
            catch (CredentialException e) {
                throw new InvalidSpeaksForException("Invalid speaks_for credential", e);
            }
            for (X509Certificate certificate : this.speaksForCertificateChain) {
                try {
                    certificate.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    LOG.error("The signer certificate in the speaks_for credential has expired.(NotAfter= " + certificate.getNotAfter() + ")", e);
                    throw new InvalidSpeaksForException("The signer certificate in the speaks_for credential has expired. (NotAfter= " + certificate.getNotAfter() + ")", e);
                }
                catch (CertificateNotYetValidException e) {
                    throw new InvalidSpeaksForException("The signer certificate in the speaks_for credential is not yet valid (NotBefore=" + certificate.getNotBefore() + ")", e);
                }
            }
            this.speaksForUrn = s4abac.getSpokenForUrn();
            this.speaksForPublicKey = s4abac.getSpokenForPubKey();
            if (this.speaksForUrn == null) {
                throw new InvalidSpeaksForException("Experiment.speaksForCredential is a valid ABAC speaksFor credential, however the speaks_for user could not be derived from it.");
            }
            if (this.speaksForPublicKey == null) {
                throw new InvalidSpeaksForException("Experiment.speaksForCredential is a valid ABAC speaksFor credential, however the speaks_for public key could not be derived from it.");
            }
            if (this.speaksForCertificateChain == null) continue;
            break;
        }
        if (this.speaksForCertificateChain == null || this.speaksForPublicKey == null || this.speaksForUrn == null) {
            throw new InvalidSpeaksForException("No speaksFor details could be derived from the provided speaksFor credentials.");
        }
    }

    public static class InvalidSpeaksForException
    extends Exception {
        public InvalidSpeaksForException(String message) {
            super(message);
        }

        public InvalidSpeaksForException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidSpeaksForException(Throwable cause) {
            super(cause);
        }
    }
}

