/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.preferences;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.git.SingleSshGitAuthPreferences;
import be.iminds.ilabt.jfed.git.SingleUserPassGitAuthPreferences;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.InvalidSshKeyInfoException;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.pref_ssh_key_info.PreferencesSshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.PreferenceChangeListener;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFedCorePreferences
implements JFedPreferences {
    private static final Logger LOG = LoggerFactory.getLogger(JFedCorePreferences.class);
    @Nullable
    protected final File propertiesFile;
    protected final PropertiesConfiguration config;

    public JFedCorePreferences() {
        this.propertiesFile = JFedUtils.createPreferencesFile("experimenter-ssh.properties");
        if (this.propertiesFile != null) {
            try {
                this.config = new PropertiesConfiguration();
                this.config.setDelimiterParsingDisabled(true);
                this.config.setFile(this.propertiesFile);
                this.config.load();
            }
            catch (ConfigurationException e) {
                LOG.error("Could not create PropertiesConfiguration", e);
                throw new RuntimeException("Could not create PropertiesConfiguration", e);
            }
        } else {
            LOG.error("Fallback: Settings will NOT be saved!");
            this.config = new PropertiesConfiguration();
            this.config.setDelimiterParsingDisabled(true);
        }
        this.config.setThrowExceptionOnMissing(false);
        this.fillinBlanks(this.config);
    }

    protected JFedCorePreferences(File propertiesFile, PropertiesConfiguration config) {
        this.propertiesFile = propertiesFile;
        this.config = config;
        config.setThrowExceptionOnMissing(false);
        this.fillinBlanks(config);
    }

    public JFedCorePreferences makeNoSaveCopy() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.copy(this.config);
        return new JFedCorePreferences(null, config);
    }

    @Override
    public void fillinBlanks() {
        this.fillinBlanks(this.config);
    }

    protected void fillinBlanks(PropertiesConfiguration config) {
        if (!config.containsKey(CorePreferenceKey.PREF_TESTBEDS_JSON_SOURCE.key)) {
            config.setProperty(CorePreferenceKey.PREF_TESTBEDS_JSON_SOURCE.key, "AUTO");
        }
        if (!config.containsKey(CorePreferenceKey.PREF_GUICONFIG_SOURCE.key)) {
            config.setProperty(CorePreferenceKey.PREF_GUICONFIG_SOURCE.key, "AUTO");
        }
        if (!config.containsKey(CorePreferenceKey.PREF_DEBUG_CPU.key)) {
            config.setProperty(CorePreferenceKey.PREF_DEBUG_CPU.key, false);
        }
        if (!config.containsKey(CorePreferenceKey.PREF_LOGGING_OVERWRITE.key)) {
            config.setProperty(CorePreferenceKey.PREF_LOGGING_OVERWRITE.key, false);
        }
        if (!config.containsKey(CorePreferenceKey.PREF_LOGGING_ROOT_LEVEL.key)) {
            config.setProperty(CorePreferenceKey.PREF_LOGGING_ROOT_LEVEL.key, "INFO");
        }
        if (!config.containsKey(CorePreferenceKey.PREF_LOGGING_EXTTERM_LEVEL.key)) {
            config.setProperty(CorePreferenceKey.PREF_LOGGING_EXTTERM_LEVEL.key, "DEBUG");
        }
        if (!config.containsKey(CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_FORCE_EXOSM.key)) {
            config.setProperty(CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_FORCE_EXOSM.key, "AUTO");
        }
        if (!config.containsKey(CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_RECOVER_METHOD.key)) {
            config.setProperty(CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_RECOVER_METHOD.key, "BOTH");
        }
        if (!config.containsKey(CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED.key)) {
            config.setProperty(CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED.key, "ALWAYS");
        }
        if (!config.containsKey(CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH.key)) {
            config.setProperty(CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH.key, "ALWAYS");
        }
        if (!config.containsKey(CorePreferenceKey.PREF_SSHPROXY_DNS_OVER_PROXY_JFED.key)) {
            config.setProperty(CorePreferenceKey.PREF_SSHPROXY_DNS_OVER_PROXY_JFED.key, false);
        }
        if (!config.containsKey(CorePreferenceKey.PREF_SSHPROXY_DNS_OVER_PROXY_SSH.key)) {
            config.setProperty(CorePreferenceKey.PREF_SSHPROXY_DNS_OVER_PROXY_JFED.key, false);
        }
        if (!config.containsKey(CorePreferenceKey.PREF_GIT_AUTH_METHOD.key)) {
            config.setProperty(CorePreferenceKey.PREF_GIT_AUTH_METHOD.key, "SSH_LOGIN");
        }
        if (!config.containsKey(CorePreferenceKey.PREF_SOCKET_CONNECT_TIMEOUT_MS.key)) {
            config.setProperty(CorePreferenceKey.PREF_SOCKET_CONNECT_TIMEOUT_MS.key, 10000);
        }
        if (!config.containsKey(CorePreferenceKey.PREF_SSH_USE_LOGIN_KEY.key)) {
            config.setProperty(CorePreferenceKey.PREF_SSH_USE_LOGIN_KEY.key, true);
        }
        if (!config.containsKey(CorePreferenceKey.PREF_SSH_USE_CUSTOM_KEY.key)) {
            config.setProperty(CorePreferenceKey.PREF_SSH_USE_CUSTOM_KEY.key, false);
        }
        if (!config.containsKey(CorePreferenceKey.PREF_SOCKET_READ_TIMEOUT_MS.key)) {
            config.setProperty(CorePreferenceKey.PREF_SOCKET_READ_TIMEOUT_MS.key, 120000);
        }
        if (!this.getBoolean(CorePreferenceKey.PREF_SSH_USE_LOGIN_KEY, false) && !this.getBoolean(CorePreferenceKey.PREF_SSH_USE_CUSTOM_KEY, false)) {
            config.setProperty(CorePreferenceKey.PREF_SSH_USE_LOGIN_KEY.key, true);
        }
        this.setRetrySettings(this.getRetrySettings());
        if (!config.containsKey(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_RSA.key)) {
            config.setProperty(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_RSA.key, true);
        }
        if (!config.containsKey(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ED25519.key)) {
            config.setProperty(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ED25519.key, true);
        }
        if (!config.containsKey(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ED25519_SK.key)) {
            config.setProperty(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ED25519_SK.key, false);
        }
        if (!config.containsKey(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ECDSA.key)) {
            config.setProperty(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ECDSA.key, true);
        }
        if (!config.containsKey(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ECDSA_SK.key)) {
            config.setProperty(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ECDSA_SK.key, false);
        }
    }

    @Override
    public boolean containsPreference(@Nonnull JFedPreferences.PreferenceKey key) {
        return this.config.containsKey(key.getKey());
    }

    @Override
    public boolean hasKey(@Nonnull JFedPreferences.PreferenceKey key) {
        return this.config.containsKey(key.getKey());
    }

    @Nonnull
    public String getString(@Nonnull JFedPreferences.PreferenceKey key, @Nonnull String defaultValue) {
        String res = this.getString(key);
        return res == null ? defaultValue : res;
    }

    @Override
    @Nullable
    public String getString(@Nonnull JFedPreferences.PreferenceKey key) {
        if (!this.config.containsKey(key.getKey())) {
            return null;
        }
        Object val = this.config.getProperty(key.getKey());
        if (val == null) {
            LOG.warn("BUG in JFedCorePreferences: existing preference for \"" + key.getKey() + "\" returned null. Using fallback to null.");
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        LOG.debug("Preference \"" + key.getKey() + "\" is of type " + val.getClass().getName() + " instead of String. Will convert it to String.");
        return "" + val;
    }

    @Override
    @Nonnull
    public List<String> getStringList(@Nonnull JFedPreferences.PreferenceKey key) {
        if (!this.config.containsKey(key.getKey())) {
            return Collections.emptyList();
        }
        Object val = this.config.getProperty(key.getKey());
        if (val == null) {
            LOG.warn("BUG in JFedCorePreferences: existing preference for \"" + key.getKey() + "\" returned null. Using fallback to empty list.");
            return Collections.emptyList();
        }
        if (val instanceof String) {
            String s2 = (String)val;
            List<String> res = Arrays.asList(s2.split(","));
            assert (res.stream().noneMatch(Objects::isNull));
            return res;
        }
        if (val instanceof List) {
            List res = (List)val;
            assert (res.stream().noneMatch(Objects::isNull));
            return res;
        }
        LOG.debug("Preference \"" + key.getKey() + "\" is of type " + val.getClass().getName() + " instead of String or String List. Will convert it to List with one String.");
        return Collections.singletonList("" + val);
    }

    @Override
    public void setString(@Nonnull JFedPreferences.PreferenceKey key, @Nonnull String value) {
        this.config.setProperty(key.getKey(), value);
    }

    @Override
    public void setStringList(@Nonnull JFedPreferences.PreferenceKey key, @Nonnull List<String> value) {
        assert (value.stream().noneMatch(Objects::isNull));
        this.config.setProperty(key.getKey(), String.join((CharSequence)",", value));
    }

    @Override
    @Nullable
    public Integer getInt(@Nonnull JFedPreferences.PreferenceKey key) {
        if (!this.config.containsKey(key.getKey())) {
            return null;
        }
        return this.config.getInt(key.getKey());
    }

    @Override
    public int getInt(@Nonnull JFedPreferences.PreferenceKey key, int defaultValue) {
        if (!this.config.containsKey(key.getKey())) {
            return defaultValue;
        }
        return this.config.getInt(key.getKey());
    }

    @Override
    public void setInt(@Nonnull JFedPreferences.PreferenceKey key, int value) {
        this.config.setProperty(key.getKey(), value);
    }

    @Override
    public Boolean getBoolean(@Nonnull JFedPreferences.PreferenceKey key) {
        if (!this.config.containsKey(key.getKey())) {
            return null;
        }
        Object val = this.config.getProperty(key.getKey());
        assert (val != null);
        Boolean res = TextUtil.objectToBoolean(val);
        if (res != null) {
            return res;
        }
        throw new IllegalStateException("Stored preference for " + key.getKey() + " is null. This is not a valid boolean value.");
    }

    @Override
    public boolean getBoolean(@Nonnull JFedPreferences.PreferenceKey key, boolean defaultValue) {
        Boolean res = this.getBoolean(key);
        return res == null ? defaultValue : res;
    }

    @Override
    public void setBoolean(@Nonnull JFedPreferences.PreferenceKey key, boolean value) {
        this.config.setProperty(key.getKey(), value);
    }

    @Override
    public File getFile(@Nonnull JFedPreferences.PreferenceKey key) {
        if (!this.config.containsKey(key.getKey())) {
            return null;
        }
        return new File(this.config.getString(key.getKey()));
    }

    @Override
    public void setFile(@Nonnull JFedPreferences.PreferenceKey key, @Nonnull File value) {
        this.config.setProperty(key.getKey(), value.getPath());
    }

    @Override
    public void clear(@Nonnull JFedPreferences.PreferenceKey key) {
        this.config.clearProperty(key.getKey());
    }

    @Override
    @Nullable
    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    @Override
    public void addPreferenceChangeListener(@Nonnull JFedPreferences.PreferenceKey prefDebugCpu, @Nonnull PreferenceChangeListener preferenceChangeListener) {
    }

    @Override
    public void setRetrySettings(@Nonnull RetrySettings retrySettings) {
        this.setInt(CorePreferenceKey.RETRY_TIMEOUT_MAX, retrySettings.getTimeoutMaxRetries());
        this.setInt(CorePreferenceKey.RETRY_BUSY_MAX, retrySettings.getBusyMaxRetries());
        this.setInt(CorePreferenceKey.RETRY_POSTEMPERR_MAX, retrySettings.getPossibleTemporaryErrorMaxRetries());
        this.setString(CorePreferenceKey.RETRY_TIMEOUT_MS_DELAY, "" + retrySettings.getTimeoutMsBeforeRetry());
        this.setString(CorePreferenceKey.RETRY_BUSY_MS_DELAY, "" + retrySettings.getBusyMsBeforeRetry());
        this.setString(CorePreferenceKey.RETRY_POSTEMPERR_MS_DELAY, "" + retrySettings.getPossibleTemporaryErrorMsBeforeRetry());
    }

    @Override
    @Nonnull
    public RetrySettings getRetrySettings() {
        Integer timeoutMaxRetries = this.getInt(CorePreferenceKey.RETRY_TIMEOUT_MAX, 3);
        Integer busyMaxRetries = this.getInt(CorePreferenceKey.RETRY_BUSY_MAX, 100);
        Integer possibleTemporaryErrorMaxRetries = this.getInt(CorePreferenceKey.RETRY_POSTEMPERR_MAX, 3);
        String timeoutMsBeforeRetry = this.getString(CorePreferenceKey.RETRY_TIMEOUT_MS_DELAY, Integer.toString(5000));
        String busyMsBeforeRetry = this.getString(CorePreferenceKey.RETRY_BUSY_MS_DELAY, Integer.toString(5000));
        String possibleTemporaryErrorMsBeforeRetry = this.getString(CorePreferenceKey.RETRY_POSTEMPERR_MS_DELAY, Integer.toString(5000));
        try {
            return new RetrySettings(timeoutMaxRetries, Long.parseLong(timeoutMsBeforeRetry), busyMaxRetries, Long.parseLong(busyMsBeforeRetry), possibleTemporaryErrorMaxRetries, Long.parseLong(possibleTemporaryErrorMsBeforeRetry));
        }
        catch (NumberFormatException e) {
            LOG.error("Error parsing a RetrySettings", e);
            return new RetrySettings();
        }
    }

    public void setScs(Server server) {
        URL u;
        if (server == null) {
            this.clear(CorePreferenceKey.PREF_SCS_URN);
            this.clear(CorePreferenceKey.PREF_SCS_URL);
            return;
        }
        Service service = ApiInfo.findService(server, ApiInfo.ApiName.GENI_SCS, 1);
        if (service == null) {
            throw new RuntimeException("Authority " + server.getDefaultComponentManagerUrn() + " has no SCS service");
        }
        try {
            u = new URL(service.getUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Authority " + server.getDefaultComponentManagerUrn() + " has invalid SCS Url \"" + service.getUrl() + "\"", e);
        }
        try {
            this.setScs(new GeniUrn(service.getUrn()), u);
        }
        catch (GeniUrn.GeniUrnParseException e) {
            throw new RuntimeException("Authority " + server.getDefaultComponentManagerUrn() + " has invalid SCS Urn \"" + service.getUrn() + "\"");
        }
    }

    public void setScs(GeniUrn scsUrn, URL url) {
        if (scsUrn == null && url == null) {
            this.clear(CorePreferenceKey.PREF_SCS_URN);
            this.clear(CorePreferenceKey.PREF_SCS_URL);
            return;
        }
        if (scsUrn != null) {
            this.setString(CorePreferenceKey.PREF_SCS_URN, scsUrn.toString());
        } else {
            this.clear(CorePreferenceKey.PREF_SCS_URN);
        }
        this.setString(CorePreferenceKey.PREF_SCS_URL, url.toString());
    }

    public void setScs(URL url) {
        if (url == null) {
            this.clear(CorePreferenceKey.PREF_SCS_URN);
            this.clear(CorePreferenceKey.PREF_SCS_URL);
            return;
        }
        this.clear(CorePreferenceKey.PREF_SCS_URN);
        this.setString(CorePreferenceKey.PREF_SCS_URL, url.toString());
    }

    public URL getScsUrl() {
        String u = this.getString(CorePreferenceKey.PREF_SCS_URL);
        if (u == null) {
            return null;
        }
        try {
            return new URL(u);
        }
        catch (MalformedURLException e) {
            this.clear(CorePreferenceKey.PREF_SCS_URL);
            throw new RuntimeException("Stored SCS URL is not valid URL (and has been removed from config). value=\"" + u + "\"");
        }
    }

    public GeniUrn getScsUrn() {
        String u = this.getString(CorePreferenceKey.PREF_SCS_URN);
        if (u == null) {
            return null;
        }
        try {
            return new GeniUrn(u);
        }
        catch (GeniUrn.GeniUrnParseException e) {
            this.clear(CorePreferenceKey.PREF_SCS_URN);
            throw new RuntimeException("Stored SCS URN is not valid URN (and has been removed from config). value=\"" + u + "\"");
        }
    }

    @Nonnull
    public static Server createFakeScsServer(@Nonnull URL scsUrl, @Nullable GeniUrn scsUrn) {
        TestbedBuilder testbedBuilder = new TestbedBuilder();
        ServerBuilder serverBuilder = new ServerBuilder();
        ServiceBuilder serviceBuilder = new ServiceBuilder();
        testbedBuilder.addServerBuilder(serverBuilder);
        serverBuilder.addServiceBuilder(serviceBuilder);
        testbedBuilder.setLongName("Config specified SCS");
        serverBuilder.setName("Config specified SCS");
        if (scsUrn != null) {
            testbedBuilder.setDefaultComponentManagerUrn(scsUrn != null ? scsUrn.toString() : null);
            serverBuilder.setDefaultComponentManagerUrn(scsUrn.toString());
        }
        serviceBuilder.setUrn(scsUrn.toString());
        serviceBuilder.setUrl(scsUrl.toExternalForm());
        serviceBuilder.setApi(ApiInfo.ApiName.GENI_SCS.getId());
        serviceBuilder.setApiVersion("1");
        Testbed scsTestbed = testbedBuilder.create();
        Server scsServer = scsTestbed.getServers().get(0);
        return scsServer;
    }

    public Server getScsAuthority(TestbedInfoSource testbedInfoSource) {
        URL scsUrl = this.getScsUrl();
        String scsUrnString = this.getString(CorePreferenceKey.PREF_SCS_URN);
        GeniUrn scsUrn = scsUrnString == null ? null : GeniUrn.parse(scsUrnString);
        Server scsServer = null;
        if (scsUrn != null) {
            scsServer = testbedInfoSource.getByUrnExact(scsUrn);
            Service scsService = ApiInfo.findService(scsServer, ApiInfo.ApiName.GENI_SCS, 1);
            assert (scsServer == null || scsService != null && Objects.equals(scsService.getUrl(), scsUrl.toExternalForm()));
        }
        if (scsServer == null && scsUrl != null) {
            scsServer = testbedInfoSource.getServerByUrl(scsUrl);
        }
        if (scsServer == null && scsUrl != null) {
            scsServer = JFedCorePreferences.createFakeScsServer(scsUrl, scsUrn);
        }
        return scsServer;
    }

    @Override
    @Nullable
    public GitAuthPreferences getGitAuthPreferences(@Nullable GeniUser user) {
        String gitAuthMethod = this.getString(CorePreferenceKey.PREF_GIT_AUTH_METHOD);
        if (gitAuthMethod == null) {
            return null;
        }
        switch (gitAuthMethod.toUpperCase()) {
            default: {
                LOG.error("Unsupported preference for PREF_GIT_AUTH_METHOD: '" + gitAuthMethod + "'");
            }
            case "NONE": {
                return null;
            }
            case "SSH_LOGIN": {
                if (user == null || user.getPrivateKey() == null) {
                    return null;
                }
                return new SingleSshGitAuthPreferences(user.getPrivateKey());
            }
            case "SSH_CUSTOM": {
                String keyFileContent;
                String keyFileName = this.getString(CorePreferenceKey.PREF_GIT_AUTH_KEYFILE);
                if (keyFileName == null) {
                    throw new RuntimeException("Git auth preferences not complete");
                }
                try {
                    keyFileContent = IOUtils.fileToString(keyFileName);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading private SSH key file '" + keyFileName + "'", e);
                }
                return new SingleSshGitAuthPreferences(keyFileContent);
            }
            case "USER_PASS": 
        }
        String username = this.getString(CorePreferenceKey.PREF_GIT_AUTH_USERNAME);
        String pass = this.getString(CorePreferenceKey.PREF_GIT_AUTH_PASSWORD);
        return new SingleUserPassGitAuthPreferences(username, pass);
    }

    @Override
    @Nullable
    public PuTTYFilesKeyInfo getCustomSshKeyInfo() {
        if (this.getBoolean(CorePreferenceKey.PREF_SSH_USE_CUSTOM_KEY, false)) {
            try {
                if (this.config.containsKey(CorePreferenceKey.PREF_SSH_PUTTY_KEY_FILE.getKey())) {
                    return PreferencesSshKeyInfoFactory.createPreferencesPuttySshKeyInfo(this, CorePreferenceKey.PREF_SSH_USE_CUSTOM_KEY, CorePreferenceKey.PREF_SSH_PUTTY_KEY_FILE);
                }
                return PreferencesSshKeyInfoFactory.createPreferencesSshKeyInfo(this, CorePreferenceKey.PREF_SSH_USE_CUSTOM_KEY, CorePreferenceKey.PREF_SSH_PUBLIC_KEY_FILE, CorePreferenceKey.PREF_SSH_PRIVATE_KEY_FILE, CorePreferenceKey.PREF_SSH_PUBLIC_KEY, CorePreferenceKey.PREF_SSH_PRIVATE_KEY);
            }
            catch (InvalidSshKeyInfoException ex) {
                LOG.warn("Could not create a valid SshKeyInfo from the preferences", ex);
                return null;
            }
        }
        return null;
    }

    public List<File> getPublicKeyFiles() {
        ArrayList<File> res = new ArrayList<File>();
        String base = System.getProperty("user.home") + File.separator + ".ssh" + File.separator;
        if (this.getBoolean(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_RSA, false)) {
            res.add(new File(base + "id_rsa.pub"));
        }
        if (this.getBoolean(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ECDSA, false)) {
            res.add(new File(base + "id_ecdsa.pub"));
        }
        if (this.getBoolean(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ECDSA_SK, false)) {
            res.add(new File(base + "id_ecdsa_sk.pub"));
        }
        if (this.getBoolean(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ED25519, false)) {
            res.add(new File(base + "id_ed25519.pub"));
        }
        if (this.getBoolean(CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ED25519_SK, false)) {
            res.add(new File(base + "id_ed25519_sk.pub"));
        }
        return res.stream().filter(File::exists).toList();
    }
}

