/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.scanner;

import be.iminds.ilabt.jfed.scanner.AuthorityType;
import java.security.PrivateKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AuthorityScannerInput {
    final List<String> urns;
    final Set<String> urls;
    final Set<X509Certificate> trustedCerts;
    final List<X509Certificate> userCerts;
    final PrivateKey userPrivateKey;
    final AuthorityType type;
    final boolean userIsOfScannedAuthority;

    public AuthorityScannerInput(List<String> urns, List<String> urls, List<X509Certificate> trustedCerts, List<X509Certificate> userCerts, PrivateKey userPrivateKey, AuthorityType type, boolean userIsOfScannedAuthority) {
        this.urns = urns;
        this.urls = new HashSet<String>(urls);
        this.trustedCerts = new HashSet<X509Certificate>(trustedCerts);
        this.userCerts = userCerts;
        this.userPrivateKey = userPrivateKey;
        this.type = type;
        this.userIsOfScannedAuthority = userIsOfScannedAuthority;
        if (userIsOfScannedAuthority) {
            userCerts.forEach(this::findInUserCerts);
        }
    }

    public void findInAltNames(Collection<List<?>> altNames) {
        if (altNames != null && !altNames.isEmpty()) {
            for (List<?> altName : altNames) {
                Integer nameType = (Integer)altName.get(0);
                if (nameType == 6) {
                    String urn = (String)altName.get(1);
                    this.urns.add(urn);
                    continue;
                }
                String v = (String)altName.get(1);
                if (v.startsWith("http")) {
                    this.urls.add(v);
                }
                if (!v.startsWith("urn:")) continue;
                this.urns.add(v);
            }
        }
    }

    public void findInUserCerts(X509Certificate cert) {
        try {
            this.findInAltNames(cert.getSubjectAlternativeNames());
            this.findInAltNames(cert.getIssuerAlternativeNames());
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
    }
}

