/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ssh_terminal_tool.unix;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalFinder {
    private static final Logger LOG = LoggerFactory.getLogger(TerminalFinder.class);

    private static String quickExecute(String command) throws IOException {
        return TerminalFinder.quickExecute(command, false);
    }

    private static String quickExecute(String command, boolean returnNullOnNonZeroExitValue) throws IOException {
        String line;
        Process cmdProc = Runtime.getRuntime().exec(command);
        Object out = "";
        BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(cmdProc.getInputStream()));
        while ((line = stdoutReader.readLine()) != null) {
            out = (String)out + line;
        }
        stdoutReader.close();
        BufferedReader stderrReader = new BufferedReader(new InputStreamReader(cmdProc.getErrorStream()));
        while ((line = stderrReader.readLine()) != null) {
            out = (String)out + line;
        }
        stderrReader.close();
        try {
            cmdProc.waitFor();
        }
        catch (InterruptedException e) {
            LOG.warn("InterruptedException in quickExecute", e);
        }
        int retValue = cmdProc.exitValue();
        if (returnNullOnNonZeroExitValue && retValue != 0) {
            return null;
        }
        return out;
    }

    public static String checkTerminal(String command) {
        List<String> defaultLocations = Arrays.asList("/usr/bin/", "/bin/", "/usr/local/bin/");
        for (String defaultLocation : defaultLocations) {
            File f = new File(defaultLocation + command);
            if (!f.exists() || f.isDirectory() || !f.canExecute()) continue;
            LOG.debug("Found terminal executable for \"" + command + "\": \"" + f.getPath() + "\"");
            return f.getPath();
        }
        try {
            String whichRes = TerminalFinder.quickExecute("which " + command, true);
            if (whichRes != null && whichRes.contains(command)) {
                LOG.debug("\"which\" found terminal executable for \"" + command + "\": \"" + whichRes + "\"");
                return whichRes;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String findLinuxTerminalCommand() {
        LOG.trace("Auto detecting terminal command");
        for (TerminalCommands terminal : TerminalCommands.values()) {
            String termPath = TerminalFinder.checkTerminal(terminal.command);
            if (termPath == null) continue;
            return termPath + terminal.getArgument();
        }
        return null;
    }

    public static final class TerminalCommands
    extends Enum<TerminalCommands> {
        public static final /* enum */ TerminalCommands KDE = new TerminalCommands("konsole", false);
        public static final /* enum */ TerminalCommands XFCE4 = new TerminalCommands("xfce4-terminal", true);
        public static final /* enum */ TerminalCommands MATE = new TerminalCommands("mate-terminal", true);
        public static final /* enum */ TerminalCommands GNOME = new TerminalCommands("gnome-terminal", true);
        public static final /* enum */ TerminalCommands ENLIGHTENMENT = new TerminalCommands("eterm", true);
        public static final /* enum */ TerminalCommands AFTERSTEP = new TerminalCommands("aterm", false);
        public static final /* enum */ TerminalCommands RXVT = new TerminalCommands("rxvt", false);
        public static final /* enum */ TerminalCommands MRXVT = new TerminalCommands("mrxvt", false);
        public static final /* enum */ TerminalCommands WTERM = new TerminalCommands("wterm", false);
        public static final /* enum */ TerminalCommands TERMINATOR = new TerminalCommands("terminator", "-x %");
        public static final /* enum */ TerminalCommands TERMINOLOGY = new TerminalCommands("terminology", true);
        public static final /* enum */ TerminalCommands X = new TerminalCommands("xterm", false);
        public static final /* enum */ TerminalCommands SHORTCUT = new TerminalCommands("x-terminal-emulator", false);
        private final String command;
        private final String customArgument;
        private static final /* synthetic */ TerminalCommands[] $VALUES;

        public static TerminalCommands[] values() {
            return (TerminalCommands[])$VALUES.clone();
        }

        public static TerminalCommands valueOf(String name) {
            return Enum.valueOf(TerminalCommands.class, name);
        }

        private TerminalCommands(String command, boolean requiresQuotes) {
            this(command, requiresQuotes ? " -e '%'" : " -e %");
        }

        private TerminalCommands(String command, String argument) {
            assert (command != null);
            assert (argument != null);
            this.command = command;
            this.customArgument = argument;
        }

        public String getCommand() {
            return this.command;
        }

        public String getArgument() {
            return this.customArgument;
        }

        private static /* synthetic */ TerminalCommands[] $values() {
            return new TerminalCommands[]{KDE, XFCE4, MATE, GNOME, ENLIGHTENMENT, AFTERSTEP, RXVT, MRXVT, WTERM, TERMINATOR, TERMINOLOGY, X, SHORTCUT};
        }

        static {
            $VALUES = TerminalCommands.$values();
        }
    }
}

