/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public final class SemVer
implements Comparable<SemVer> {
    private final int major;
    private final int minor;
    @Nullable
    private final Integer patch;
    private static final Pattern SEMVER_REGEX = Pattern.compile("^(\\d+)\\.(\\d+)(\\.(\\d+))?$");

    public SemVer(int major, int minor, @Nullable Integer patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public SemVer(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.patch = null;
    }

    public SemVer(@Nonnull String version) throws ParseException {
        Matcher m3 = SEMVER_REGEX.matcher(version);
        if (!m3.matches()) {
            throw new ParseException("Failed to parse version \"" + version + "\"");
        }
        this.major = Integer.parseInt(m3.group(1));
        this.minor = Integer.parseInt(m3.group(2));
        this.patch = m3.group(4) != null ? Integer.valueOf(Integer.parseInt(m3.group(4))) : null;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    @Nullable
    public Integer getPatch() {
        return this.patch;
    }

    @Override
    public int compareTo(@NotNull SemVer o) {
        int cmpMajor = Integer.compare(this.major, o.major);
        if (cmpMajor != 0) {
            return cmpMajor;
        }
        int cmpMinor = Integer.compare(this.minor, o.minor);
        if (cmpMinor != 0) {
            return cmpMinor;
        }
        if (this.patch == null && o.patch == null) {
            return 0;
        }
        if (this.patch == null && o.patch != null) {
            return -1;
        }
        if (this.patch != null && o.patch == null) {
            return 1;
        }
        return Integer.compare(this.patch, o.patch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SemVer)) {
            return false;
        }
        SemVer semVer = (SemVer)o;
        return this.major == semVer.major && this.minor == semVer.minor && Objects.equals(this.patch, semVer.patch);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public String toString() {
        return this.patch == null ? this.major + "." + this.minor : this.major + "." + this.minor + "." + this.patch;
    }

    public static class ParseException
    extends RuntimeException {
        ParseException(String message) {
            super(message);
        }

        ParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

