/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class Slf4jHelper {
    private static final Logger LOG = LoggerFactory.getLogger(Slf4jHelper.class);

    private Slf4jHelper() {
        throw new RuntimeException("This is static only class");
    }

    public static Logger createPrintStreamLogger(PrintStream printStream, Level level) {
        return new PrintStreamLogger(printStream, level);
    }

    public static Logger createPrintWriterLogger(PrintWriter printWriter, Level level) {
        return new PrintWriterLogger(printWriter, level);
    }

    public static Logger createMultiplexLogger(Logger ... loggers) {
        return new MultiplexLogger(loggers);
    }

    private static class PrintStreamLogger
    extends AbstractSlf4JLoggerImpl {
        private final PrintStream out;

        public PrintStreamLogger(PrintStream out) {
            this(out, Level.INFO);
        }

        public PrintStreamLogger(PrintStream out, Level level) {
            super(level);
            this.out = out;
        }

        @Override
        public String getName() {
            return "Test Output Logger";
        }

        @Override
        protected void handle(Level msgLevel, String message, Throwable t) {
            if (!this.level.includes(msgLevel)) {
                return;
            }
            if (t != null) {
                message = (String)message + "\n" + TextUtil.exceptionToString(t);
            }
            this.out.println(this.getName() + " - " + msgLevel + " - " + (String)message);
        }
    }

    public static enum Level {
        TRACE(0),
        DEBUG(1),
        INFO(2),
        WARN(3),
        ERROR(4);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean includes(Level level) {
            return this.getLevel() <= level.getLevel();
        }
    }

    private static class PrintWriterLogger
    extends AbstractSlf4JLoggerImpl {
        private final PrintWriter out;

        public PrintWriterLogger(PrintWriter out) {
            this(out, Level.INFO);
        }

        public PrintWriterLogger(PrintWriter out, Level level) {
            super(level);
            this.out = out;
        }

        @Override
        public String getName() {
            return "Test Output Logger";
        }

        @Override
        protected void handle(Level msgLevel, String message, Throwable t) {
            if (!this.level.includes(msgLevel)) {
                return;
            }
            if (t != null) {
                message = (String)message + "\n" + TextUtil.exceptionToString(t);
            }
            this.out.println(this.getName() + " - " + msgLevel + " - " + (String)message);
        }
    }

    private static class MultiplexLogger
    implements Logger {
        private final Logger[] loggers;

        private MultiplexLogger(Logger[] loggers) {
            this.loggers = loggers;
        }

        @Override
        public String getName() {
            return "MultiplexLogger";
        }

        @Override
        public boolean isTraceEnabled() {
            for (Logger l : this.loggers) {
                if (!l.isTraceEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isTraceEnabled(Marker marker) {
            for (Logger l : this.loggers) {
                if (!l.isTraceEnabled(marker)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isDebugEnabled() {
            for (Logger l : this.loggers) {
                if (!l.isDebugEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isDebugEnabled(Marker marker) {
            for (Logger l : this.loggers) {
                if (!l.isDebugEnabled(marker)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isInfoEnabled() {
            for (Logger l : this.loggers) {
                if (!l.isInfoEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isInfoEnabled(Marker marker) {
            for (Logger l : this.loggers) {
                if (!l.isInfoEnabled(marker)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isWarnEnabled() {
            for (Logger l : this.loggers) {
                if (!l.isWarnEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isWarnEnabled(Marker marker) {
            for (Logger l : this.loggers) {
                if (!l.isWarnEnabled(marker)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isErrorEnabled() {
            for (Logger l : this.loggers) {
                if (!l.isErrorEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isErrorEnabled(Marker marker) {
            for (Logger l : this.loggers) {
                if (!l.isErrorEnabled(marker)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void trace(String s2) {
            for (Logger l : this.loggers) {
                l.trace(s2);
            }
        }

        @Override
        public void trace(String s2, Object o) {
            for (Logger l : this.loggers) {
                l.trace(s2, o);
            }
        }

        @Override
        public void trace(String s2, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.trace(s2, o, o1);
            }
        }

        @Override
        public void trace(String s2, Object ... objects) {
            for (Logger l : this.loggers) {
                l.trace(s2, objects);
            }
        }

        @Override
        public void trace(String s2, Throwable t) {
            for (Logger l : this.loggers) {
                l.trace(s2, t);
            }
        }

        @Override
        public void trace(Marker m3, String s2) {
            for (Logger l : this.loggers) {
                l.trace(m3, s2);
            }
        }

        @Override
        public void trace(Marker m3, String s2, Object o) {
            for (Logger l : this.loggers) {
                l.trace(m3, s2, o);
            }
        }

        @Override
        public void trace(Marker m3, String s2, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.trace(m3, s2, o, o1);
            }
        }

        @Override
        public void trace(Marker m3, String s2, Object ... objects) {
            for (Logger l : this.loggers) {
                l.trace(m3, s2, objects);
            }
        }

        @Override
        public void trace(Marker m3, String s2, Throwable t) {
            for (Logger l : this.loggers) {
                l.trace(m3, s2, t);
            }
        }

        @Override
        public void debug(String s2) {
            for (Logger l : this.loggers) {
                l.debug(s2);
            }
        }

        @Override
        public void debug(String s2, Object o) {
            for (Logger l : this.loggers) {
                l.debug(s2, o);
            }
        }

        @Override
        public void debug(String s2, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.debug(s2, o, o1);
            }
        }

        @Override
        public void debug(String s2, Object ... objects) {
            for (Logger l : this.loggers) {
                l.debug(s2, objects);
            }
        }

        @Override
        public void debug(String s2, Throwable t) {
            for (Logger l : this.loggers) {
                l.debug(s2, t);
            }
        }

        @Override
        public void debug(Marker m3, String s2) {
            for (Logger l : this.loggers) {
                l.debug(m3, s2);
            }
        }

        @Override
        public void debug(Marker m3, String s2, Object o) {
            for (Logger l : this.loggers) {
                l.debug(m3, s2, o);
            }
        }

        @Override
        public void debug(Marker m3, String s2, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.debug(m3, s2, o, o1);
            }
        }

        @Override
        public void debug(Marker m3, String s2, Object ... objects) {
            for (Logger l : this.loggers) {
                l.debug(m3, s2, objects);
            }
        }

        @Override
        public void debug(Marker m3, String s2, Throwable t) {
            for (Logger l : this.loggers) {
                l.debug(m3, s2, t);
            }
        }

        @Override
        public void info(String s2) {
            for (Logger l : this.loggers) {
                l.info(s2);
            }
        }

        @Override
        public void info(String s2, Object o) {
            for (Logger l : this.loggers) {
                l.info(s2, o);
            }
        }

        @Override
        public void info(String s2, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.info(s2, o, o1);
            }
        }

        @Override
        public void info(String s2, Object ... objects) {
            for (Logger l : this.loggers) {
                l.info(s2, objects);
            }
        }

        @Override
        public void info(String s2, Throwable t) {
            for (Logger l : this.loggers) {
                l.info(s2, t);
            }
        }

        @Override
        public void info(Marker m3, String s2) {
            for (Logger l : this.loggers) {
                l.info(m3, s2);
            }
        }

        @Override
        public void info(Marker m3, String s2, Object o) {
            for (Logger l : this.loggers) {
                l.info(m3, s2, o);
            }
        }

        @Override
        public void info(Marker m3, String s2, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.info(m3, s2, o, o1);
            }
        }

        @Override
        public void info(Marker m3, String s2, Object ... objects) {
            for (Logger l : this.loggers) {
                l.info(m3, s2, objects);
            }
        }

        @Override
        public void info(Marker m3, String s2, Throwable t) {
            for (Logger l : this.loggers) {
                l.info(m3, s2, t);
            }
        }

        @Override
        public void warn(String s2) {
            for (Logger l : this.loggers) {
                l.warn(s2);
            }
        }

        @Override
        public void warn(String s2, Object o) {
            for (Logger l : this.loggers) {
                l.warn(s2, o);
            }
        }

        @Override
        public void warn(String s2, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.warn(s2, o, o1);
            }
        }

        @Override
        public void warn(String s2, Object ... objects) {
            for (Logger l : this.loggers) {
                l.warn(s2, objects);
            }
        }

        @Override
        public void warn(String s2, Throwable t) {
            for (Logger l : this.loggers) {
                l.warn(s2, t);
            }
        }

        @Override
        public void warn(Marker m3, String s2) {
            for (Logger l : this.loggers) {
                l.warn(m3, s2);
            }
        }

        @Override
        public void warn(Marker m3, String s2, Object o) {
            for (Logger l : this.loggers) {
                l.warn(m3, s2, o);
            }
        }

        @Override
        public void warn(Marker m3, String s2, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.warn(m3, s2, o, o1);
            }
        }

        @Override
        public void warn(Marker m3, String s2, Object ... objects) {
            for (Logger l : this.loggers) {
                l.warn(m3, s2, objects);
            }
        }

        @Override
        public void warn(Marker m3, String s2, Throwable t) {
            for (Logger l : this.loggers) {
                l.warn(m3, s2, t);
            }
        }

        @Override
        public void error(String s2) {
            for (Logger l : this.loggers) {
                l.error(s2);
            }
        }

        @Override
        public void error(String s2, Object o) {
            for (Logger l : this.loggers) {
                l.error(s2, o);
            }
        }

        @Override
        public void error(String s2, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.error(s2, o, o1);
            }
        }

        @Override
        public void error(String s2, Object ... objects) {
            for (Logger l : this.loggers) {
                l.error(s2, objects);
            }
        }

        @Override
        public void error(String s2, Throwable t) {
            for (Logger l : this.loggers) {
                l.error(s2, t);
            }
        }

        @Override
        public void error(Marker m3, String s2) {
            for (Logger l : this.loggers) {
                l.error(m3, s2);
            }
        }

        @Override
        public void error(Marker m3, String s2, Object o) {
            for (Logger l : this.loggers) {
                l.error(m3, s2, o);
            }
        }

        @Override
        public void error(Marker m3, String s2, Object o, Object o1) {
            for (Logger l : this.loggers) {
                l.error(m3, s2, o, o1);
            }
        }

        @Override
        public void error(Marker m3, String s2, Object ... objects) {
            for (Logger l : this.loggers) {
                l.error(m3, s2, objects);
            }
        }

        @Override
        public void error(Marker m3, String s2, Throwable t) {
            for (Logger l : this.loggers) {
                l.error(m3, s2, t);
            }
        }
    }

    public static abstract class AbstractSlf4JLoggerImpl
    implements Logger {
        protected final Level level;
        private boolean handledExceptionInLogging = false;

        public AbstractSlf4JLoggerImpl(Level level) {
            if (level == null) {
                throw new InvalidParameterException("Logger level may not be null");
            }
            this.level = level;
        }

        protected abstract void handle(Level var1, String var2, Throwable var3);

        @Override
        public boolean isTraceEnabled() {
            return this.level.includes(Level.TRACE);
        }

        @Override
        public boolean isTraceEnabled(Marker marker) {
            return this.level.includes(Level.TRACE);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.level.includes(Level.DEBUG);
        }

        @Override
        public boolean isDebugEnabled(Marker marker) {
            return this.level.includes(Level.DEBUG);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.level.includes(Level.INFO);
        }

        @Override
        public boolean isInfoEnabled(Marker marker) {
            return this.level.includes(Level.INFO);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.level.includes(Level.WARN);
        }

        @Override
        public boolean isWarnEnabled(Marker marker) {
            return this.level.includes(Level.WARN);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.level.includes(Level.ERROR);
        }

        @Override
        public boolean isErrorEnabled(Marker marker) {
            return this.level.includes(Level.ERROR);
        }

        private void callHandle(Level level, String message, Throwable t) {
            block2: {
                try {
                    this.handle(level, message, t);
                }
                catch (Exception e) {
                    if (this.handledExceptionInLogging) break block2;
                    LOG.error("Warning: Exception in " + this.getClass() + ".handle(). Logging will possibly stop working. (NOTE: this error is reported only once.)", e);
                    this.handledExceptionInLogging = true;
                }
            }
        }

        @Override
        public void trace(String s2) {
            this.callHandle(Level.TRACE, s2, null);
        }

        @Override
        public void trace(String s2, Object o) {
            this.callHandle(Level.TRACE, String.format(s2, o), null);
        }

        @Override
        public void trace(String s2, Object o, Object o1) {
            this.callHandle(Level.TRACE, String.format(s2, o, o1), null);
        }

        @Override
        public void trace(String s2, Object ... objects) {
            this.callHandle(Level.TRACE, String.format(s2, objects), null);
        }

        @Override
        public void trace(String s2, Throwable t) {
            this.callHandle(Level.TRACE, s2, t);
        }

        @Override
        public void trace(Marker m3, String s2) {
            this.callHandle(Level.TRACE, s2, null);
        }

        @Override
        public void trace(Marker m3, String s2, Object o) {
            this.callHandle(Level.TRACE, String.format(s2, o), null);
        }

        @Override
        public void trace(Marker m3, String s2, Object o, Object o1) {
            this.callHandle(Level.TRACE, String.format(s2, o, o1), null);
        }

        @Override
        public void trace(Marker m3, String s2, Object ... objects) {
            this.callHandle(Level.TRACE, String.format(s2, objects), null);
        }

        @Override
        public void trace(Marker m3, String s2, Throwable throwable) {
            this.callHandle(Level.TRACE, s2 + "\n" + TextUtil.exceptionToString(throwable), null);
        }

        @Override
        public void debug(String s2) {
            this.callHandle(Level.DEBUG, s2, null);
        }

        @Override
        public void debug(String s2, Object o) {
            this.callHandle(Level.DEBUG, String.format(s2, o), null);
        }

        @Override
        public void debug(String s2, Object o, Object o1) {
            this.callHandle(Level.DEBUG, String.format(s2, o, o1), null);
        }

        @Override
        public void debug(String s2, Object ... objects) {
            this.callHandle(Level.DEBUG, String.format(s2, objects), null);
        }

        @Override
        public void debug(String s2, Throwable t) {
            this.callHandle(Level.DEBUG, s2, t);
        }

        @Override
        public void debug(Marker m3, String s2) {
            this.callHandle(Level.DEBUG, s2, null);
        }

        @Override
        public void debug(Marker m3, String s2, Object o) {
            this.callHandle(Level.DEBUG, String.format(s2, o), null);
        }

        @Override
        public void debug(Marker m3, String s2, Object o, Object o1) {
            this.callHandle(Level.DEBUG, String.format(s2, o, o1), null);
        }

        @Override
        public void debug(Marker m3, String s2, Object ... objects) {
            this.callHandle(Level.DEBUG, String.format(s2, objects), null);
        }

        @Override
        public void debug(Marker m3, String s2, Throwable throwable) {
            this.callHandle(Level.DEBUG, s2 + "\n" + TextUtil.exceptionToString(throwable), null);
        }

        @Override
        public void info(String s2) {
            this.callHandle(Level.INFO, s2, null);
        }

        @Override
        public void info(String s2, Object o) {
            this.callHandle(Level.INFO, String.format(s2, o), null);
        }

        @Override
        public void info(String s2, Object o, Object o1) {
            this.callHandle(Level.INFO, String.format(s2, o, o1), null);
        }

        @Override
        public void info(String s2, Object ... objects) {
            this.callHandle(Level.INFO, String.format(s2, objects), null);
        }

        @Override
        public void info(String s2, Throwable t) {
            this.callHandle(Level.INFO, s2, t);
        }

        @Override
        public void info(Marker m3, String s2) {
            this.callHandle(Level.INFO, s2, null);
        }

        @Override
        public void info(Marker m3, String s2, Object o) {
            this.callHandle(Level.INFO, String.format(s2, o), null);
        }

        @Override
        public void info(Marker m3, String s2, Object o, Object o1) {
            this.callHandle(Level.INFO, String.format(s2, o, o1), null);
        }

        @Override
        public void info(Marker m3, String s2, Object ... objects) {
            this.callHandle(Level.INFO, String.format(s2, objects), null);
        }

        @Override
        public void info(Marker m3, String s2, Throwable throwable) {
            this.callHandle(Level.INFO, s2 + "\n" + TextUtil.exceptionToString(throwable), null);
        }

        @Override
        public void warn(String s2) {
            this.callHandle(Level.WARN, s2, null);
        }

        @Override
        public void warn(String s2, Object o) {
            this.callHandle(Level.WARN, String.format(s2, o), null);
        }

        @Override
        public void warn(String s2, Object o, Object o1) {
            this.callHandle(Level.WARN, String.format(s2, o, o1), null);
        }

        @Override
        public void warn(String s2, Object ... objects) {
            this.callHandle(Level.WARN, String.format(s2, objects), null);
        }

        @Override
        public void warn(String s2, Throwable t) {
            this.callHandle(Level.WARN, s2, t);
        }

        @Override
        public void warn(Marker m3, String s2) {
            this.callHandle(Level.WARN, s2, null);
        }

        @Override
        public void warn(Marker m3, String s2, Object o) {
            this.callHandle(Level.WARN, String.format(s2, o), null);
        }

        @Override
        public void warn(Marker m3, String s2, Object o, Object o1) {
            this.callHandle(Level.WARN, String.format(s2, o, o1), null);
        }

        @Override
        public void warn(Marker m3, String s2, Object ... objects) {
            this.callHandle(Level.WARN, String.format(s2, objects), null);
        }

        @Override
        public void warn(Marker m3, String s2, Throwable throwable) {
            this.callHandle(Level.WARN, s2 + "\n" + TextUtil.exceptionToString(throwable), null);
        }

        @Override
        public void error(String s2) {
            this.callHandle(Level.ERROR, s2, null);
        }

        @Override
        public void error(String s2, Object o) {
            this.callHandle(Level.ERROR, String.format(s2, o), null);
        }

        @Override
        public void error(String s2, Object o, Object o1) {
            this.callHandle(Level.ERROR, String.format(s2, o, o1), null);
        }

        @Override
        public void error(String s2, Object ... objects) {
            this.callHandle(Level.ERROR, String.format(s2, objects), null);
        }

        @Override
        public void error(String s2, Throwable t) {
            this.callHandle(Level.ERROR, s2, t);
        }

        @Override
        public void error(Marker m3, String s2) {
            this.callHandle(Level.ERROR, s2, null);
        }

        @Override
        public void error(Marker m3, String s2, Object o) {
            this.callHandle(Level.ERROR, String.format(s2, o), null);
        }

        @Override
        public void error(Marker m3, String s2, Object o, Object o1) {
            this.callHandle(Level.ERROR, String.format(s2, o, o1), null);
        }

        @Override
        public void error(Marker m3, String s2, Object ... objects) {
            this.callHandle(Level.ERROR, String.format(s2, objects), null);
        }

        @Override
        public void error(Marker m3, String s2, Throwable throwable) {
            this.callHandle(Level.ERROR, s2 + "\n" + TextUtil.exceptionToString(throwable), null);
        }
    }
}

