/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.net.SocketFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSocketFactory
extends SocketFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingSocketFactory.class);
    @Nonnull
    private final SocketFactory realSocketFactory;
    @Nonnull
    private final List<SocketLogger> loggers;

    public LoggingSocketFactory(@Nonnull SocketFactory realSocketFactory) {
        this.realSocketFactory = realSocketFactory;
        this.loggers = new CopyOnWriteArrayList<SocketLogger>();
    }

    public void addSocketLogger(@Nonnull SocketLogger socketLogger) {
        this.loggers.add(socketLogger);
    }

    public void removeSocketLogger(@Nonnull SocketLogger socketLogger) {
        this.loggers.remove(socketLogger);
    }

    protected void fire(SocketLoggerFire f) {
        this.loggers.stream().forEach(l -> {
            try {
                f.fire((SocketLogger)l);
            }
            catch (Exception e) {
                LOG.error("Exception logging socket action.", e);
            }
        });
    }

    @Override
    public Socket createSocket() throws IOException {
        return new LoggingSocket(this.realSocketFactory.createSocket());
    }

    @Override
    public Socket createSocket(String s2, int i) throws IOException, UnknownHostException {
        return new LoggingSocket(this.realSocketFactory.createSocket(s2, i));
    }

    @Override
    public Socket createSocket(String s2, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
        return new LoggingSocket(this.realSocketFactory.createSocket(s2, i, inetAddress, i1));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return new LoggingSocket(this.realSocketFactory.createSocket(inetAddress, i));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        return new LoggingSocket(this.realSocketFactory.createSocket(inetAddress, i, inetAddress1, i1));
    }

    protected static interface SocketLoggerFire {
        public void fire(SocketLogger var1);
    }

    private class LoggingSocket
    extends Socket {
        private final Socket realSocket;
        private AtomicBoolean firstRead = new AtomicBoolean(false);
        private AtomicBoolean firstWrite = new AtomicBoolean(false);

        public LoggingSocket(Socket realSocket) {
            this.realSocket = realSocket;
        }

        @Override
        public void connect(SocketAddress socketAddress) throws IOException {
            LoggingSocketFactory.this.fire(SocketLogger::onConnectStart);
            this.realSocket.connect(socketAddress);
            LoggingSocketFactory.this.fire(SocketLogger::onConnectEnd);
        }

        @Override
        public void connect(SocketAddress socketAddress, int i) throws IOException {
            LoggingSocketFactory.this.fire(SocketLogger::onConnectStart);
            this.realSocket.connect(socketAddress, i);
            LoggingSocketFactory.this.fire(SocketLogger::onConnectEnd);
        }

        @Override
        public void bind(SocketAddress socketAddress) throws IOException {
            this.realSocket.bind(socketAddress);
        }

        @Override
        public InetAddress getInetAddress() {
            return this.realSocket.getInetAddress();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.realSocket.getLocalAddress();
        }

        @Override
        public int getPort() {
            return this.realSocket.getPort();
        }

        @Override
        public int getLocalPort() {
            return this.realSocket.getLocalPort();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.realSocket.getRemoteSocketAddress();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.realSocket.getLocalSocketAddress();
        }

        @Override
        public SocketChannel getChannel() {
            return this.realSocket.getChannel();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.realSocket.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.realSocket.getOutputStream();
        }

        @Override
        public void setTcpNoDelay(boolean b) throws SocketException {
            this.realSocket.setTcpNoDelay(b);
        }

        @Override
        public boolean getTcpNoDelay() throws SocketException {
            return this.realSocket.getTcpNoDelay();
        }

        @Override
        public void setSoLinger(boolean b, int i) throws SocketException {
            this.realSocket.setSoLinger(b, i);
        }

        @Override
        public int getSoLinger() throws SocketException {
            return this.realSocket.getSoLinger();
        }

        @Override
        public void sendUrgentData(int i) throws IOException {
            this.realSocket.sendUrgentData(i);
        }

        @Override
        public void setOOBInline(boolean b) throws SocketException {
            this.realSocket.setOOBInline(b);
        }

        @Override
        public boolean getOOBInline() throws SocketException {
            return this.realSocket.getOOBInline();
        }

        @Override
        public synchronized void setSoTimeout(int i) throws SocketException {
            this.realSocket.setSoTimeout(i);
        }

        @Override
        public synchronized int getSoTimeout() throws SocketException {
            return this.realSocket.getSoTimeout();
        }

        @Override
        public synchronized void setSendBufferSize(int i) throws SocketException {
            this.realSocket.setSendBufferSize(i);
        }

        @Override
        public synchronized int getSendBufferSize() throws SocketException {
            return this.realSocket.getSendBufferSize();
        }

        @Override
        public synchronized void setReceiveBufferSize(int i) throws SocketException {
            this.realSocket.setReceiveBufferSize(i);
        }

        @Override
        public synchronized int getReceiveBufferSize() throws SocketException {
            return this.realSocket.getReceiveBufferSize();
        }

        @Override
        public void setKeepAlive(boolean b) throws SocketException {
            this.realSocket.setKeepAlive(b);
        }

        @Override
        public boolean getKeepAlive() throws SocketException {
            return this.realSocket.getKeepAlive();
        }

        @Override
        public void setTrafficClass(int i) throws SocketException {
            this.realSocket.setTrafficClass(i);
        }

        @Override
        public int getTrafficClass() throws SocketException {
            return this.realSocket.getTrafficClass();
        }

        @Override
        public void setReuseAddress(boolean b) throws SocketException {
            this.realSocket.setReuseAddress(b);
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.realSocket.getReuseAddress();
        }

        @Override
        public synchronized void close() throws IOException {
            this.realSocket.close();
            LoggingSocketFactory.this.fire(SocketLogger::onClose);
        }

        @Override
        public void shutdownInput() throws IOException {
            this.realSocket.shutdownInput();
        }

        @Override
        public void shutdownOutput() throws IOException {
            this.realSocket.shutdownOutput();
        }

        @Override
        public boolean isConnected() {
            return this.realSocket.isConnected();
        }

        @Override
        public boolean isBound() {
            return this.realSocket.isBound();
        }

        @Override
        public boolean isClosed() {
            return this.realSocket.isClosed();
        }

        @Override
        public boolean isInputShutdown() {
            return this.realSocket.isInputShutdown();
        }

        @Override
        public boolean isOutputShutdown() {
            return this.realSocket.isOutputShutdown();
        }

        @Override
        public void setPerformancePreferences(int i, int i1, int i2) {
            this.realSocket.setPerformancePreferences(i, i1, i2);
        }

        private class LoggerOutputStream
        extends OutputStream {
            private OutputStream realOutputStream;

            public LoggerOutputStream(OutputStream realOutputStream) {
                this.realOutputStream = realOutputStream;
            }

            @Override
            public void write(@NotNull byte[] bytes) throws IOException {
                boolean isFirstWrite = LoggingSocket.this.firstWrite.compareAndSet(false, true);
                if (isFirstWrite) {
                    LoggingSocketFactory.this.fire(SocketLogger::onFirstWriteStart);
                }
                this.realOutputStream.write(bytes);
                if (isFirstWrite) {
                    LoggingSocketFactory.this.fire(SocketLogger::onFirstWriteEnd);
                }
            }

            @Override
            public void write(@NotNull byte[] bytes, int i, int i1) throws IOException {
                boolean isFirstWrite = LoggingSocket.this.firstWrite.compareAndSet(false, true);
                if (isFirstWrite) {
                    LoggingSocketFactory.this.fire(SocketLogger::onFirstWriteStart);
                }
                this.realOutputStream.write(bytes, i, i1);
                if (isFirstWrite) {
                    LoggingSocketFactory.this.fire(SocketLogger::onFirstWriteEnd);
                }
            }

            @Override
            public void write(int i) throws IOException {
                boolean isFirstWrite = LoggingSocket.this.firstWrite.compareAndSet(false, true);
                if (isFirstWrite) {
                    LoggingSocketFactory.this.fire(SocketLogger::onFirstWriteStart);
                }
                this.realOutputStream.write(i);
                if (isFirstWrite) {
                    LoggingSocketFactory.this.fire(SocketLogger::onFirstWriteEnd);
                }
            }

            @Override
            public void flush() throws IOException {
                this.realOutputStream.flush();
            }

            @Override
            public void close() throws IOException {
                this.realOutputStream.close();
            }
        }

        private class LoggerInputStream
        extends InputStream {
            private InputStream realInputStream;

            public LoggerInputStream(InputStream realInputStream) {
                this.realInputStream = realInputStream;
            }

            @Override
            public int read(@NotNull byte[] bytes) throws IOException {
                boolean isFirstRead = LoggingSocket.this.firstRead.compareAndSet(false, true);
                if (isFirstRead) {
                    LoggingSocketFactory.this.fire(SocketLogger::onFirstReadStart);
                }
                int res = this.realInputStream.read(bytes);
                if (isFirstRead) {
                    LoggingSocketFactory.this.fire(SocketLogger::onFirstReadEnd);
                }
                return res;
            }

            @Override
            public int read(@NotNull byte[] bytes, int i, int i1) throws IOException {
                boolean isFirstRead = LoggingSocket.this.firstRead.compareAndSet(false, true);
                if (isFirstRead) {
                    LoggingSocketFactory.this.fire(SocketLogger::onFirstReadStart);
                }
                int res = this.realInputStream.read(bytes, i, i1);
                if (isFirstRead) {
                    LoggingSocketFactory.this.fire(SocketLogger::onFirstReadEnd);
                }
                return res;
            }

            @Override
            public long skip(long l) throws IOException {
                return this.realInputStream.skip(l);
            }

            @Override
            public int available() throws IOException {
                return this.realInputStream.available();
            }

            @Override
            public void close() throws IOException {
                this.realInputStream.close();
            }

            @Override
            public synchronized void mark(int i) {
                this.realInputStream.mark(i);
            }

            @Override
            public synchronized void reset() throws IOException {
                this.realInputStream.reset();
            }

            @Override
            public boolean markSupported() {
                return this.realInputStream.markSupported();
            }

            @Override
            public int read() throws IOException {
                boolean isFirstRead = LoggingSocket.this.firstRead.compareAndSet(false, true);
                if (isFirstRead) {
                    LoggingSocketFactory.this.fire(SocketLogger::onFirstReadStart);
                }
                int res = this.realInputStream.read();
                if (isFirstRead) {
                    LoggingSocketFactory.this.fire(SocketLogger::onFirstReadEnd);
                }
                return res;
            }
        }
    }

    public static interface SocketLogger {
        public void onConnectStart();

        public void onConnectEnd();

        public void onFirstReadStart();

        public void onFirstReadEnd();

        public void onFirstWriteStart();

        public void onFirstWriteEnd();

        public void onClose();
    }
}

