/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.List;
import net.schmizz.sshj.common.Base64;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.OpenSSHKnownHosts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSSHKnownHostsInMemory
implements HostKeyVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSSHKnownHostsInMemory.class);
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final List<OpenSSHKnownHosts.KnownHostEntry> entries = new ArrayList<OpenSSHKnownHosts.KnownHostEntry>();

    public OpenSSHKnownHostsInMemory(String contents) throws IOException {
        String[] lines;
        for (String line : lines = contents.split("\n")) {
            try {
                OpenSSHKnownHosts.KnownHostEntry entry = EntryFactory.parseEntry(line);
                if (entry == null) continue;
                this.entries.add(entry);
            }
            catch (SSHException ignore) {
                this.log.debug("Bad line ({}): {} ", (Object)ignore.toString(), (Object)line);
            }
        }
    }

    @Override
    public boolean verify(String hostname, int port, PublicKey key) {
        KeyType type = KeyType.fromKey(key);
        if (type == KeyType.UNKNOWN) {
            return false;
        }
        String adjustedHostname = port != 22 ? "[" + hostname + "]:" + port : hostname;
        for (OpenSSHKnownHosts.KnownHostEntry e : this.entries) {
            try {
                if (!e.appliesTo(type, adjustedHostname)) continue;
                return e.verify(key) || this.hostKeyChangedAction(e, adjustedHostname, key);
            }
            catch (IOException ioe) {
                this.log.error("Error with {}: {}", e, ioe.getMessage(), ioe);
                return false;
            }
        }
        return this.hostKeyUnverifiableAction(adjustedHostname, key);
    }

    private String adjustHostname(String hostname, int port) {
        String lowerHN = hostname.toLowerCase();
        return port != 22 ? "[" + lowerHN + "]:" + port : lowerHN;
    }

    @Override
    public List<String> findExistingAlgorithms(String hostname, int port) {
        String adjustedHostname = this.adjustHostname(hostname, port);
        ArrayList<String> knownHostAlgorithms = new ArrayList<String>();
        for (OpenSSHKnownHosts.KnownHostEntry e : this.entries) {
            try {
                if (!e.appliesTo(adjustedHostname)) continue;
                knownHostAlgorithms.add(e.getType().toString());
            }
            catch (IOException iOException) {}
        }
        return knownHostAlgorithms;
    }

    protected boolean hostKeyUnverifiableAction(String hostname, PublicKey key) {
        return false;
    }

    protected boolean hostKeyChangedAction(OpenSSHKnownHosts.KnownHostEntry entry, String hostname, PublicKey key) {
        this.log.warn("Host key for `{}` has changed!", (Object)hostname);
        return false;
    }

    public List<OpenSSHKnownHosts.KnownHostEntry> entries() {
        return this.entries;
    }

    public static class EntryFactory {
        private EntryFactory() {
        }

        public static OpenSSHKnownHosts.KnownHostEntry parseEntry(String line) throws IOException {
            PublicKey key;
            String sType;
            KeyType type;
            int i;
            if (EntryFactory.isComment(line)) {
                return new OpenSSHKnownHosts.CommentEntry(line);
            }
            String[] split = line.split(" ");
            OpenSSHKnownHosts.Marker marker = OpenSSHKnownHosts.Marker.fromString(split[i = 0]);
            if (marker != null) {
                ++i;
            }
            if (split.length < 3) {
                LOG.error("Error reading entry `{}`", (Object)line);
                return new OpenSSHKnownHosts.BadHostEntry(line);
            }
            String hostnames = split[i++];
            if ((type = KeyType.fromString(sType = split[i++])) != KeyType.UNKNOWN) {
                String sKey = split[i++];
                try {
                    byte[] keyBytes = Base64.decode(sKey);
                    key = new Buffer.PlainBuffer(keyBytes).readPublicKey();
                }
                catch (IOException var13) {
                    LOG.warn("Error decoding Base64 key bytes", var13);
                    return new OpenSSHKnownHosts.BadHostEntry(line);
                }
            }
            if (!EntryFactory.isBits(sType)) {
                LOG.error("Error reading entry `{}`, could not determine type", (Object)line);
                return new OpenSSHKnownHosts.BadHostEntry(line);
            }
            type = KeyType.RSA;
            BigInteger e = new BigInteger(split[i++]);
            BigInteger n = new BigInteger(split[i++]);
            try {
                KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
                key = keyFactory.generatePublic(new RSAPublicKeySpec(n, e));
            }
            catch (Exception var12) {
                LOG.error("Error reading entry `{}`, could not create key", (Object)line, (Object)var12);
                return new OpenSSHKnownHosts.BadHostEntry(line);
            }
            return new OpenSSHKnownHosts.HostEntry(marker, hostnames, type, key);
        }

        private static boolean isBits(String type) {
            try {
                Integer.parseInt(type);
                return true;
            }
            catch (NumberFormatException var3) {
                return false;
            }
        }

        private static boolean isComment(String line) {
            return line.isEmpty() || line.startsWith("#");
        }

        public static boolean isHashed(String line) {
            return line.startsWith("|1|");
        }
    }
}

