/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.SshServerProxyHelper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.conn.HttpRoutedConnection;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLCertificateDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(SSLCertificateDownloader.class);
    private static final Pattern CN_PATTERN = Pattern.compile(".*CN=([^ ,]*)[ ,]*.*");
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    public static X509Certificate getCertificate(URL url) {
        return SSLCertificateDownloader.getCertificate(url, null);
    }

    public static X509Certificate getCertificate(URL url, JFedConnection.SshProxyInfo proxyInfo) {
        SSLCertificateJFedInfo info = SSLCertificateDownloader.getCertificateInfo(url, proxyInfo);
        return info.getCert();
    }

    public static SSLCertificateJFedInfo getCertificateInfo(URL url) {
        return SSLCertificateDownloader.getCertificateInfo(url, null);
    }

    public static SSLCertificateJFedInfo getCertificateInfo(URL url, JFedConnection.SshProxyInfo proxyInfo) {
        try {
            SSLSocket sslSocket;
            int serverPort;
            JFedTrustStore jFedTrustStore = new JFedTrustStore();
            KeyStore trustStore = jFedTrustStore.getTrustStore();
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
            context.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            int n = serverPort = url.getPort() < 0 ? 443 : url.getPort();
            if (proxyInfo == null) {
                factory = context.getSocketFactory();
                sslSocket = (SSLSocket)factory.createSocket(url.getHost(), serverPort);
            } else {
                LOG.info("Tunneling SSL socket over SSH proxy");
                SshServerProxyHelper.SslOverSshProxySocketFactory proxyFact = new SshServerProxyHelper.SslOverSshProxySocketFactory(context, NoopHostnameVerifier.INSTANCE, proxyInfo, url.getHost(), serverPort);
                Socket proxySocket = proxyFact.createSocket(null);
                proxySocket.connect(new InetSocketAddress(url.getHost(), serverPort), 5000);
                sslSocket = (SSLSocket)factory.createSocket(proxySocket, url.getHost(), serverPort, true);
            }
            sslSocket.setSoTimeout(10000);
            try {
                sslSocket.startHandshake();
                sslSocket.close();
                LOG.info("SSL connection setup success");
            }
            catch (SSLException e) {
                LOG.info("SSL connection setup failed", e);
            }
            X509Certificate[] chainArr = tm.chain;
            List<X509Certificate> chain = Arrays.asList(chainArr);
            boolean trusted = true;
            SSLCertificateJFedInfo res = new SSLCertificateJFedInfo(url, url.getHost());
            LOG.debug("Got peer certificates from spy:" + (chain != null ? Collections.singletonList(chain) : null));
            if (chainArr == null || chain == null) {
                LOG.error("Could not obtain server certificate chain");
                return res;
            }
            Boolean selfSigned = false;
            for (X509Certificate cert : chain) {
                try {
                    Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
                    if (altNames != null) {
                        for (List<?> altName : altNames) {
                            Integer nameType = (Integer)altName.get(0);
                            if (nameType != 6) continue;
                            String urn = (String)altName.get(1);
                            GeniUrn geniUrn = GeniUrn.parse(urn);
                            if (geniUrn == null) {
                                LOG.warn("Warning: certificate alternative name URI is not a valid authority urn: \"" + urn + "\"  (will be ignored)");
                                continue;
                            }
                            res.urnAuthPart = geniUrn.getEncodedTopLevelAuthority();
                            res.urn = urn;
                        }
                    }
                }
                catch (CertificateParsingException altNames) {
                    // empty catch block
                }
                if (Objects.equals(cert.getIssuerDN(), cert.getSubjectDN())) {
                    LOG.debug("Certificate has same issues and subject -> it's self signed!");
                    selfSigned = true;
                }
                boolean selfVerifyFailed = false;
                try {
                    cert.verify(cert.getPublicKey());
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                    selfVerifyFailed = true;
                }
                if (selfVerifyFailed) continue;
                LOG.debug("Certificate has signed itself -> it's self signed!");
                selfSigned = true;
            }
            res.cert = chainArr[0];
            res.certchain = chainArr;
            Matcher matchCN = CN_PATTERN.matcher(res.cert.getSubjectX500Principal().toString());
            res.subject = matchCN.matches() ? matchCN.group(1) : null;
            res.subjectMatchesHostname = Objects.equals(res.subject, url.getHost());
            if (!res.subjectMatchesHostname.booleanValue()) {
                trusted = false;
            }
            res.trusted = trusted;
            res.selfSigned = selfSigned;
            return res;
        }
        catch (Exception e) {
            LOG.info("Failed to fetch SSL certificate: " + e.getMessage(), e);
            return new SSLCertificateJFedInfo(url, url.getHost(), e);
        }
    }

    public static void main(String[] args) throws MalformedURLException {
        SSLCertificateJFedInfo cert1 = SSLCertificateDownloader.getCertificateInfo(new URL("https://www.wall3.test.ibbt.be/"));
        System.out.println("returned cert: " + cert1);
    }

    public static class SSLCertificateJFedInfo {
        private X509Certificate cert;
        private X509Certificate[] certchain;
        private String urn;
        private String urnAuthPart;
        private String subject;
        private Boolean selfSigned;
        private Boolean subjectMatchesHostname;
        private final URL url;
        private final String hostname;
        private final boolean connectionError;
        private final Exception connectionException;
        private boolean trusted;

        private SSLCertificateJFedInfo(X509Certificate cert, String urn, String urnAuthPart, String subject, boolean selfSigned, URL url, String hostname) {
            this.cert = cert;
            this.urn = urn;
            this.urnAuthPart = urnAuthPart;
            this.subject = subject;
            this.selfSigned = selfSigned;
            this.url = url;
            this.hostname = hostname;
            this.connectionError = false;
            this.connectionException = null;
            this.trusted = false;
        }

        public SSLCertificateJFedInfo(X509Certificate cert, URL url, String hostname) {
            this.cert = cert;
            this.urn = null;
            this.urnAuthPart = null;
            this.subject = null;
            this.selfSigned = null;
            this.subjectMatchesHostname = null;
            this.url = url;
            this.hostname = hostname;
            this.connectionError = false;
            this.connectionException = null;
            this.trusted = false;
        }

        private SSLCertificateJFedInfo(URL url, String hostname) {
            this.cert = null;
            this.urn = null;
            this.urnAuthPart = null;
            this.subject = null;
            this.selfSigned = null;
            this.subjectMatchesHostname = null;
            this.url = url;
            this.hostname = hostname;
            this.connectionError = false;
            this.connectionException = null;
            this.trusted = false;
        }

        private SSLCertificateJFedInfo(URL url, String hostname, Exception connectionException) {
            this.cert = null;
            this.urn = null;
            this.urnAuthPart = null;
            this.subject = null;
            this.selfSigned = null;
            this.subjectMatchesHostname = null;
            this.url = url;
            this.hostname = hostname;
            this.connectionError = true;
            this.connectionException = connectionException;
            this.trusted = false;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public String getUrn() {
            return this.urn;
        }

        public String getUrnAuthPart() {
            return this.urnAuthPart;
        }

        public String getSubject() {
            return this.subject;
        }

        public Boolean isSelfSigned() {
            return this.selfSigned;
        }

        public Boolean getSubjectMatchesHostname() {
            return this.subjectMatchesHostname;
        }

        public X509Certificate[] getChain() {
            return this.certchain;
        }

        public X509Certificate getChainRoot() {
            if (this.certchain == null) {
                return null;
            }
            return this.certchain[this.certchain.length - 1];
        }

        public URL getUrl() {
            return this.url;
        }

        public String getHostname() {
            return this.hostname;
        }

        public boolean isConnectionError() {
            return this.connectionError;
        }

        public Exception getConnectionException() {
            return this.connectionException;
        }

        public String toString() {
            return "SSLCertificateJFedInfo{cert=" + (this.cert == null ? "none" : "present") + ", certchain has " + (this.certchain == null ? null : Integer.valueOf(this.certchain.length)) + " elements, urn='" + this.urn + "', urnAuthPart='" + this.urnAuthPart + "', subject='" + this.subject + "', selfSigned=" + this.selfSigned + ", subjectMatchesHostname=" + this.subjectMatchesHostname + ", url=" + this.url + ", hostname=" + this.hostname + ", trusted=" + this.trusted + "}";
        }

        public boolean isTrusted() {
            return this.trusted;
        }
    }

    public static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        public X509Certificate[] chain;

        public SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }

    private static class CertificateInterceptor
    implements HttpResponseInterceptor {
        private List<X509Certificate> certificateList;
        private X509Certificate[] certificateArr;

        private CertificateInterceptor() {
        }

        @Override
        public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
            HttpRoutedConnection routedConnection = (HttpRoutedConnection)httpContext.getAttribute("http.connection");
            Certificate[] certificates = routedConnection.getSSLSession() != null ? routedConnection.getSSLSession().getPeerCertificates() : null;
            LOG.debug("processing HttpResponse. secure=" + routedConnection.isSecure() + " certs:" + (certificates == null ? null : Arrays.asList(certificates)));
            if (routedConnection.isSecure() && certificates != null) {
                this.certificateList = new ArrayList<X509Certificate>();
                for (Certificate c : certificates) {
                    if (c instanceof X509Certificate) {
                        this.certificateList.add((X509Certificate)c);
                        continue;
                    }
                    LOG.warn("Not an X509 cert in chain: " + c);
                }
                this.certificateArr = new X509Certificate[this.certificateList.size()];
                this.certificateArr = this.certificateList.toArray(this.certificateArr);
            }
        }
    }
}

