/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlRpcPrintUtil {
    private static final Logger LOG = LoggerFactory.getLogger(XmlRpcPrintUtil.class);

    private static String prependToEachNextLine(String in, String texttoprepend) {
        StringBuilder res = new StringBuilder(in.length() + 100);
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '\n' && i != in.length() - 1) {
                res.append(c).append(texttoprepend);
                continue;
            }
            res.append(c);
        }
        return res.toString();
    }

    public static String xmlRpcObjectToString(Object o) {
        return XmlRpcPrintUtil.printXmlRpcResultObject(o, "", true);
    }

    public static String anyObjectToJsonString(Object o) {
        return XmlRpcPrintUtil.printXmlRpcResultObject(o, "", false);
    }

    /*
     * WARNING - void declaration
     */
    private static String printXmlRpcResultObject(Object o, String texttoprepend, boolean warnForUnsupported) {
        int i;
        Object[] v;
        if (o == null) {
            return "null";
        }
        StringBuilder res = new StringBuilder(100);
        boolean knownClass = false;
        if (o == null || JSONObject.NULL.equals(o)) {
            res.append(XmlRpcPrintUtil.prependToEachNextLine("null", texttoprepend));
            return res.toString();
        }
        if (o instanceof Map) {
            Map h2 = (Map)o;
            if (h2.size() == 0) {
                res.append("{ }");
            } else {
                res.append("{\n");
                int j = 0;
                for (Object key : h2.keySet()) {
                    void var10_12;
                    Object val = h2.get(key);
                    String string = texttoprepend;
                    int shiftLen = 6 + key.toString().length() + 3;
                    if (shiftLen > 15) {
                        shiftLen = 7;
                    }
                    for (int i2 = 0; i2 < shiftLen; ++i2) {
                        String string2 = (String)var10_12 + " ";
                    }
                    if (key instanceof String) {
                        res.append(texttoprepend).append("\"").append(key).append("\": ").append(XmlRpcPrintUtil.printXmlRpcResultObject(val, (String)var10_12, warnForUnsupported));
                    } else {
                        res.append(texttoprepend).append("").append(key).append(": ").append(XmlRpcPrintUtil.printXmlRpcResultObject(val, (String)var10_12, warnForUnsupported));
                    }
                    if (j++ < h2.keySet().size() - 1) {
                        res.append(",");
                    }
                    res.append("\n");
                }
                res.append(texttoprepend).append("}");
            }
            knownClass = true;
        }
        if (o instanceof List) {
            v = (Object[])o;
            if (v.size() == 0) {
                res.append("[ ]");
            } else {
                res.append("[\n");
                i = 0;
                for (Object e : v) {
                    res.append(texttoprepend).append(XmlRpcPrintUtil.printXmlRpcResultObject(e, texttoprepend + "   ", warnForUnsupported));
                    if (i++ < v.size() - 1) {
                        res.append(",");
                    }
                    res.append("\n");
                }
                res.append(texttoprepend).append("]");
            }
            knownClass = true;
        }
        if (o instanceof Object[]) {
            v = (Object[])o;
            if (v.length == 0) {
                res.append("[ ]");
            } else {
                res.append("[\n");
                i = 0;
                for (Iterator<Object> iterator : v) {
                    res.append(texttoprepend).append(XmlRpcPrintUtil.printXmlRpcResultObject(iterator, texttoprepend + "   ", warnForUnsupported));
                    if (i++ < v.length - 1) {
                        res.append(",");
                    }
                    res.append("\n");
                }
                res.append(texttoprepend).append("]");
            }
            knownClass = true;
        }
        if (Objects.equals(o.getClass(), String.class) || Objects.equals(o.getClass(), GeniUrn.class)) {
            String str = o instanceof String ? (String)o : o.toString();
            res.append(XmlRpcPrintUtil.encodeStringToJsonValue(str, texttoprepend));
            knownClass = true;
        }
        if (o instanceof Number) {
            res.append(XmlRpcPrintUtil.prependToEachNextLine(o.toString(), texttoprepend));
            knownClass = true;
        }
        if (o instanceof Boolean) {
            res.append(XmlRpcPrintUtil.prependToEachNextLine(o.toString(), texttoprepend));
            knownClass = true;
        }
        if (!knownClass) {
            if (warnForUnsupported) {
                if (o instanceof Collection) {
                    LOG.warn("printXmlRpcResultObject got an input object containing an unsupported collection class: " + o.getClass().getName() + ". This is not correct, and will be corrected automatically by converting it to a String. Fix the bug in the code!");
                } else {
                    LOG.warn("printXmlRpcResultObject got an input object containing a " + o.getClass().getName() + ". This is not correct, and will be corrected automatically by converting it to a String. Fix the bug in the code!");
                }
            }
            res.append(XmlRpcPrintUtil.encodeStringToJsonValue(o.toString(), texttoprepend));
        }
        return res.toString();
    }

    private static String encodeStringToJsonValue(String str, String texttoprepend) {
        StringBuilder s2 = new StringBuilder();
        block9: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    s2.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    s2.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    s2.append("\\b");
                    continue block9;
                }
                case '\f': {
                    s2.append("\\f");
                    continue block9;
                }
                case '\n': {
                    s2.append("\\n");
                    continue block9;
                }
                case '\r': {
                    s2.append("\\r");
                    continue block9;
                }
                case '\t': {
                    s2.append("\\t");
                    continue block9;
                }
                default: {
                    long l = c | 0x10000;
                    if (l >= 0L && l <= 31L) {
                        s2.append("\\u").append(Integer.toHexString(c | 0x10000).substring(1));
                        continue block9;
                    }
                    s2.append(c);
                    continue block9;
                }
            }
        }
        if (s2.length() > 0xA00000) {
            return "\"" + XmlRpcPrintUtil.prependToEachNextLine("=== WARNING: String to long (" + s2.length() + " chars) to process! ===", texttoprepend) + "\"";
        }
        return "\"" + XmlRpcPrintUtil.prependToEachNextLine(s2.toString(), texttoprepend) + "\"";
    }
}

