/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi;

import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.RewrittenStatement;
import org.skife.jdbi.v2.tweak.StatementRewriter;

public class NamePrependingStatementRewriter
implements StatementRewriter {
    private final StatementRewriter rewriter;

    public NamePrependingStatementRewriter(StatementRewriter rewriter) {
        this.rewriter = rewriter;
    }

    @Override
    public RewrittenStatement rewrite(String sql, Binding params, StatementContext ctx) {
        if (ctx.getSqlObjectType() != null && ctx.getSqlObjectMethod() != null) {
            StringBuilder query = new StringBuilder(sql.length() + 100);
            query.append("/* ");
            String className = ctx.getSqlObjectType().getSimpleName();
            if (!className.isEmpty()) {
                query.append(className).append('.');
            }
            query.append(ctx.getSqlObjectMethod().getName());
            query.append(" */ ");
            query.append(sql);
            return this.rewriter.rewrite(query.toString(), params, ctx);
        }
        return this.rewriter.rewrite(sql, params, ctx);
    }
}

