/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.JodaDateTimeArgument;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class GuavaOptionalJodaTimeArgumentFactory
implements ArgumentFactory<com.google.common.base.Optional<DateTime>> {
    private final Optional<Calendar> calendar;

    public GuavaOptionalJodaTimeArgumentFactory() {
        this.calendar = Optional.empty();
    }

    public GuavaOptionalJodaTimeArgumentFactory(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    @Override
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        if (value instanceof com.google.common.base.Optional) {
            com.google.common.base.Optional optionalValue = (com.google.common.base.Optional)value;
            return optionalValue.isPresent() && optionalValue.get() instanceof DateTime;
        }
        return false;
    }

    @Override
    public Argument build(Class<?> expectedType, com.google.common.base.Optional<DateTime> value, StatementContext ctx) {
        return new JodaDateTimeArgument(value.get(), this.calendar);
    }
}

