/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import com.google.common.base.Optional;
import io.dropwizard.jdbi.args.LocalDateArgument;
import java.time.LocalDate;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class GuavaOptionalLocalDateArgumentFactory
implements ArgumentFactory<Optional<LocalDate>> {
    @Override
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        if (value instanceof Optional) {
            Optional optionalValue = (Optional)value;
            return optionalValue.isPresent() && optionalValue.get() instanceof LocalDate;
        }
        return false;
    }

    @Override
    public Argument build(Class<?> expectedType, Optional<LocalDate> value, StatementContext ctx) {
        return new LocalDateArgument(value.get());
    }
}

