/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.JodaDateTimeArgument;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class JodaDateTimeArgumentFactory
implements ArgumentFactory<DateTime> {
    private final Optional<Calendar> calendar;

    public JodaDateTimeArgumentFactory() {
        this.calendar = Optional.empty();
    }

    public JodaDateTimeArgumentFactory(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    @Override
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof DateTime;
    }

    @Override
    public Argument build(Class<?> expectedType, DateTime value, StatementContext ctx) {
        return new JodaDateTimeArgument(value, this.calendar);
    }
}

