/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.OptionalInt;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class OptionalIntArgumentFactory
implements ArgumentFactory<OptionalInt> {
    @Override
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof OptionalInt;
    }

    @Override
    public Argument build(Class<?> expectedType, OptionalInt value, StatementContext ctx) {
        return new DefaultOptionalArgument(value);
    }

    private static class DefaultOptionalArgument
    implements Argument {
        private final OptionalInt value;

        private DefaultOptionalArgument(OptionalInt value) {
            this.value = value;
        }

        @Override
        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            if (this.value.isPresent()) {
                statement.setInt(position, this.value.getAsInt());
            } else {
                statement.setNull(position, 4);
            }
        }
    }
}

