/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.OptionalLong;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class OptionalLongArgumentFactory
implements ArgumentFactory<OptionalLong> {
    @Override
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof OptionalLong;
    }

    @Override
    public Argument build(Class<?> expectedType, OptionalLong value, StatementContext ctx) {
        return new DefaultOptionalArgument(value);
    }

    private static class DefaultOptionalArgument
    implements Argument {
        private final OptionalLong value;

        private DefaultOptionalArgument(OptionalLong value) {
            this.value = value;
        }

        @Override
        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            if (this.value.isPresent()) {
                statement.setLong(position, this.value.getAsLong());
            } else {
                statement.setNull(position, -5);
            }
        }
    }
}

