/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.ZonedDateTimeArgument;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class ZonedDateTimeArgumentFactory
implements ArgumentFactory<ZonedDateTime> {
    private final Optional<Calendar> calendar;

    public ZonedDateTimeArgumentFactory() {
        this.calendar = Optional.empty();
    }

    public ZonedDateTimeArgumentFactory(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    @Override
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof ZonedDateTime;
    }

    @Override
    public Argument build(Class<?> expectedType, ZonedDateTime value, StatementContext ctx) {
        return new ZonedDateTimeArgument(value, this.calendar);
    }
}

