/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.logging.FormattedLog;
import org.slf4j.LoggerFactory;

public class LogbackLog
extends FormattedLog {
    private final Logger log;
    private final Level level;
    private final String fqcn;

    public LogbackLog() {
        this((Logger)LoggerFactory.getLogger(DBI.class.getPackage().getName()));
    }

    public LogbackLog(Logger log) {
        this(log, Level.DEBUG);
    }

    public LogbackLog(Logger log, Level level) {
        this.log = log;
        this.level = level;
        this.fqcn = LogbackLog.class.getName();
    }

    @Override
    protected final boolean isEnabled() {
        return this.log.isEnabledFor(this.level);
    }

    @Override
    protected final void log(String msg) {
        this.log.log(null, this.fqcn, Level.toLocationAwareLoggerInteger(this.level), msg, null, null);
    }
}

