/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.optional;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

@Singleton
public class OptionalIntParamConverterProvider
implements ParamConverterProvider {
    private final OptionalIntParamConverter paramConverter = new OptionalIntParamConverter();

    @Override
    @Nullable
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        return OptionalInt.class.equals(rawType) ? this.paramConverter : null;
    }

    public static class OptionalIntParamConverter
    implements ParamConverter<OptionalInt> {
        @Override
        public OptionalInt fromString(String value) {
            if (value == null) {
                return OptionalInt.empty();
            }
            try {
                return OptionalInt.of(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public String toString(OptionalInt value) {
            Preconditions.checkArgument(value != null);
            return value.isPresent() ? Integer.toString(value.getAsInt()) : "";
        }
    }
}

