/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.ModuleReaderProxy;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.AutoCloseableConcurrentQueue;
import io.github.classgraph.utils.AutoCloseableExecutorService;
import io.github.classgraph.utils.AutoCloseableFutureListWithCompletionBarrier;
import io.github.classgraph.utils.FastPathResolver;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.JarUtils;
import io.github.classgraph.utils.JarfileMetadataReader;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.Recycler;
import io.github.classgraph.utils.SingletonMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class NestedJarHandler {
    private final ConcurrentLinkedDeque<File> tempFiles = new ConcurrentLinkedDeque();
    private final SingletonMap<String, Map.Entry<File, Set<String>>> nestedPathToJarfileAndRootRelativePathsMap;
    private final SingletonMap<File, Recycler<ZipFile, IOException>> zipFileToRecyclerMap = new SingletonMap<File, Recycler<ZipFile, IOException>>(){

        @Override
        public Recycler<ZipFile, IOException> newInstance(final File zipFile, LogNode log) throws Exception {
            return new Recycler<ZipFile, IOException>(){

                @Override
                public ZipFile newInstance() throws IOException {
                    return new ZipFile(zipFile.getPath());
                }
            };
        }
    };
    private final ConcurrentHashMap<File, File> innerJarToOuterJarMap;
    private final SingletonMap<File, JarfileMetadataReader> zipFileToJarfileMetadataReaderMap = new SingletonMap<File, JarfileMetadataReader>(){

        @Override
        public JarfileMetadataReader newInstance(File canonicalFile, LogNode log) throws Exception {
            return new JarfileMetadataReader(canonicalFile, log);
        }
    };
    private final SingletonMap<ModuleRef, Recycler<ModuleReaderProxy, IOException>> moduleRefToModuleReaderProxyRecyclerMap;
    private final SingletonMap<File, Boolean> mkDirs;
    public static final String TEMP_FILENAME_LEAF_SEPARATOR = "---";
    private static final int NUM_UNZIP_THREADS = 4;

    public NestedJarHandler(final ScanSpec scanSpec, LogNode log) {
        this.innerJarToOuterJarMap = new ConcurrentHashMap();
        this.moduleRefToModuleReaderProxyRecyclerMap = new SingletonMap<ModuleRef, Recycler<ModuleReaderProxy, IOException>>(){

            @Override
            public Recycler<ModuleReaderProxy, IOException> newInstance(final ModuleRef moduleRef, LogNode log) throws Exception {
                return new Recycler<ModuleReaderProxy, IOException>(){

                    @Override
                    public ModuleReaderProxy newInstance() throws IOException {
                        return moduleRef.open();
                    }
                };
            }
        };
        this.nestedPathToJarfileAndRootRelativePathsMap = new SingletonMap<String, Map.Entry<File, Set<String>>>(){

            @Override
            public Map.Entry<File, Set<String>> newInstance(String nestedJarPath, LogNode log) throws Exception {
                Map.Entry parentJarfileAndRootRelativePaths;
                File parentJarFile;
                int lastPlingIdx = nestedJarPath.lastIndexOf(33);
                if (lastPlingIdx < 0) {
                    File canonicalFile;
                    File pathFile;
                    boolean isRemote = nestedJarPath.startsWith("http://") || nestedJarPath.startsWith("https://");
                    File file = pathFile = isRemote ? NestedJarHandler.this.downloadTempFile(nestedJarPath, log) : new File(nestedJarPath);
                    if (isRemote && pathFile == null) {
                        if (log != null) {
                            log.log(nestedJarPath, "Could not download jarfile " + nestedJarPath);
                        }
                        return null;
                    }
                    try {
                        canonicalFile = pathFile.getCanonicalFile();
                    }
                    catch (IOException | SecurityException e) {
                        if (log != null) {
                            log.log(nestedJarPath, "Path component " + nestedJarPath + " could not be canonicalized: " + e);
                        }
                        return null;
                    }
                    if (!FileUtils.canRead(canonicalFile)) {
                        if (log != null) {
                            log.log(nestedJarPath, "Path component " + nestedJarPath + " does not exist");
                        }
                        return null;
                    }
                    if (!canonicalFile.isFile()) {
                        if (log != null) {
                            log.log(nestedJarPath, "Path component " + nestedJarPath + "  is not a file (expected a jarfile)");
                        }
                        return null;
                    }
                    File bareJarfile = scanSpec.stripSFXHeader ? NestedJarHandler.this.stripSFXHeader(canonicalFile, log) : canonicalFile;
                    HashSet rootRelativePaths = new HashSet();
                    return new AbstractMap.SimpleEntry<File, Set<String>>(bareJarfile, rootRelativePaths);
                }
                String parentPath = nestedJarPath.substring(0, lastPlingIdx);
                String childPath = nestedJarPath.substring(lastPlingIdx + 1);
                if (childPath.startsWith("/")) {
                    childPath = childPath.substring(1);
                }
                if ((parentJarFile = (File)(parentJarfileAndRootRelativePaths = (Map.Entry)NestedJarHandler.this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(parentPath, log)).getKey()) == null) {
                    return null;
                }
                String parentJarFilePath = FastPathResolver.resolve(parentJarFile.getPath());
                if (!parentJarFilePath.equals(parentPath)) {
                    return (Map.Entry)NestedJarHandler.this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(parentJarFilePath + "!" + childPath, log);
                }
                Recycler parentJarRecycler = (Recycler)NestedJarHandler.this.zipFileToRecyclerMap.getOrCreateSingleton(parentJarFile.getCanonicalFile(), log);
                try (Recycler.Recyclable parentRecyclable = parentJarRecycler.acquire();){
                    ZipEntry childZipEntry;
                    ZipFile parentZipFile = (ZipFile)parentRecyclable.get();
                    if (childPath.endsWith("/")) {
                        childZipEntry = parentZipFile.getEntry(childPath);
                    } else {
                        childZipEntry = parentZipFile.getEntry(childPath + "/");
                        if (childZipEntry == null) {
                            childZipEntry = parentZipFile.getEntry(childPath);
                        }
                    }
                    if (childZipEntry == null) {
                        if (log != null) {
                            log.log(nestedJarPath, "Child path component " + childPath + " does not exist in jarfile " + parentJarFile);
                        }
                        Map.Entry<File, Set<String>> entry = null;
                        return entry;
                    }
                    if (childZipEntry.isDirectory()) {
                        if (log != null) {
                            log.log(nestedJarPath, "Child path component " + childPath + " in jarfile " + parentJarFile + " is a directory, not a file -- using as scanning root");
                        }
                        ((Set)parentJarfileAndRootRelativePaths.getValue()).add(childPath);
                        Map.Entry entry = parentJarfileAndRootRelativePaths;
                        return entry;
                    }
                    File childJarFile = NestedJarHandler.this.unzipToTempFile(parentZipFile, childZipEntry, log);
                    File noHeaderChildJarFile = scanSpec.stripSFXHeader ? NestedJarHandler.this.stripSFXHeader(childJarFile, log) : childJarFile;
                    NestedJarHandler.this.innerJarToOuterJarMap.put(noHeaderChildJarFile, parentJarFile);
                    HashSet rootRelativePaths = new HashSet();
                    AbstractMap.SimpleEntry<File, Set<String>> simpleEntry = new AbstractMap.SimpleEntry<File, Set<String>>(noHeaderChildJarFile, rootRelativePaths);
                    return simpleEntry;
                }
            }
        };
        this.mkDirs = new SingletonMap<File, Boolean>(){

            @Override
            public Boolean newInstance(File dir, LogNode log) throws Exception {
                File parentDir;
                boolean dirExists = dir.exists();
                if (!dirExists && ((parentDir = dir.getParentFile()) == null || ((Boolean)NestedJarHandler.this.mkDirs.getOrCreateSingleton(parentDir, log)).booleanValue())) {
                    dirExists = dir.mkdir();
                    if (!dirExists) {
                        dirExists = dir.exists();
                    }
                    if (log != null) {
                        if (!dirExists) {
                            log.log("Cannot create directory: " + dir.toPath());
                        } else if (!dir.isDirectory()) {
                            log.log("Can't overwrite a file with a directory: " + dir.toPath());
                        } else {
                            log.log("Creating directory: " + dir.toPath());
                        }
                    }
                    if (!dir.isDirectory()) {
                        dirExists = false;
                    }
                    if (dirExists) {
                        dir.deleteOnExit();
                        NestedJarHandler.this.tempFiles.add(dir);
                    }
                }
                return dirExists;
            }
        };
    }

    public Recycler<ZipFile, IOException> getZipFileRecycler(File zipFile, LogNode log) throws Exception {
        return this.zipFileToRecyclerMap.getOrCreateSingleton(zipFile, log);
    }

    public JarfileMetadataReader getJarfileMetadataReader(File zipFile, String jarfilePackageRoot, LogNode log) throws Exception {
        JarfileMetadataReader jarfileMetadataReader = this.zipFileToJarfileMetadataReaderMap.getOrCreateSingleton(zipFile, log);
        if (!jarfilePackageRoot.isEmpty()) {
            jarfileMetadataReader.addPackageRootPath(jarfilePackageRoot);
        }
        return jarfileMetadataReader;
    }

    public Recycler<ModuleReaderProxy, IOException> getModuleReaderProxyRecycler(ModuleRef moduleRef, LogNode log) throws Exception {
        return this.moduleRefToModuleReaderProxyRecyclerMap.getOrCreateSingleton(moduleRef, log);
    }

    public Map.Entry<File, Set<String>> getInnermostNestedJar(String nestedJarPath, LogNode log) throws Exception {
        return this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(nestedJarPath, log);
    }

    public File getOutermostJar(File jarFile) {
        File lastValid = jarFile;
        File curr = jarFile;
        while (curr != null) {
            lastValid = curr;
            curr = this.innerJarToOuterJarMap.get(curr);
        }
        return lastValid;
    }

    private String leafname(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private String sanitizeFilename(String filename) {
        return filename.replace('/', '_').replace('\\', '_').replace(':', '_').replace('?', '_').replace('&', '_').replace('=', '_').replace(' ', '_');
    }

    private File downloadTempFile(String jarURL, LogNode log) {
        LogNode subLog = log == null ? null : log.log(jarURL, "Downloading URL " + jarURL);
        File tempFile = null;
        try {
            String suffix = TEMP_FILENAME_LEAF_SEPARATOR + this.sanitizeFilename(this.leafname(jarURL));
            tempFile = File.createTempFile("FCS--", suffix);
            tempFile.deleteOnExit();
            this.tempFiles.add(tempFile);
            URL url = new URL(jarURL);
            try (InputStream inputStream = url.openStream();){
                Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (subLog != null) {
                subLog.addElapsedTime();
            }
        }
        catch (Exception e) {
            if (subLog != null) {
                subLog.log("Could not download " + jarURL, e);
            }
            return null;
        }
        if (subLog != null) {
            subLog.log("Downloaded to temporary file " + tempFile);
            subLog.log("***** Note that it is time-consuming to scan jars at http(s) addresses, they must be downloaded for every scan, and the same jars must also be separately downloaded by the ClassLoader *****");
        }
        return tempFile;
    }

    private File unzipToTempFile(ZipFile zipFile, ZipEntry zipEntry, LogNode log) throws IOException {
        String zipEntryPath = zipEntry.getName();
        if (zipEntryPath.startsWith("/")) {
            zipEntryPath = zipEntryPath.substring(1);
        }
        File tempFile = File.createTempFile("FCS--", TEMP_FILENAME_LEAF_SEPARATOR + this.sanitizeFilename(this.leafname(zipEntryPath)));
        tempFile.deleteOnExit();
        this.tempFiles.add(tempFile);
        LogNode subLog = null;
        if (log != null) {
            subLog = log.log(zipFile.getName() + "!/" + zipEntryPath, "Unzipping " + zipFile.getName() + "!/" + zipEntryPath).log("Extracted to temporary file " + tempFile.getPath());
        }
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
            Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (subLog != null) {
            subLog.addElapsedTime();
        }
        return tempFile;
    }

    public File unzipToTempDir(final File jarFile, String packageRoot, LogNode log) throws IOException {
        final LogNode subLog = log == null ? null : log.log("Unzipping " + jarFile + " from package root " + packageRoot);
        final Path tempDirPath = Files.createTempDirectory("FCS--" + this.sanitizeFilename(this.leafname(jarFile.getName())) + "--" + this.sanitizeFilename(packageRoot) + "--", new FileAttribute[0]);
        File tempDir = tempDirPath.toFile();
        tempDir.deleteOnExit();
        this.tempFiles.add(tempDir);
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        ArrayList<String> zipEntryNamesWithoutPrefix = new ArrayList<String>();
        String packageRootPrefix = !packageRoot.endsWith("/") && !packageRoot.isEmpty() ? packageRoot + '/' : packageRoot;
        int packageRootPrefixLen = packageRootPrefix.length();
        try (ZipFile zipFile = new ZipFile(jarFile);){
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                String zipEntryName = zipEntry.getName();
                while (zipEntryName.startsWith("/")) {
                    zipEntryName = zipEntryName.substring(1);
                }
                if (!zipEntryName.startsWith(packageRootPrefix) || zipEntryName.length() <= packageRootPrefixLen) continue;
                zipEntries.add(zipEntry);
                zipEntryNamesWithoutPrefix.add(packageRootPrefixLen == 0 ? zipEntryName : zipEntryName.substring(packageRootPrefixLen));
            }
        }
        var12_12 = null;
        try (final AutoCloseableConcurrentQueue openZipFiles = new AutoCloseableConcurrentQueue();
             AutoCloseableExecutorService executor = new AutoCloseableExecutorService(4);
             AutoCloseableFutureListWithCompletionBarrier futures = new AutoCloseableFutureListWithCompletionBarrier(zipEntries.size(), subLog);){
            for (int i = 0; i < zipEntries.size(); ++i) {
                final ZipEntry zipEntry = (ZipEntry)zipEntries.get(i);
                final String zipEntryNameWithoutPrefix = (String)zipEntryNamesWithoutPrefix.get(i);
                futures.add(executor.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        block22: {
                            ThreadLocal<ZipFile> zipFileTL = new ThreadLocal<ZipFile>();
                            ZipFile zipFile = (ZipFile)zipFileTL.get();
                            if (zipFile == null) {
                                try {
                                    zipFile = new ZipFile(jarFile);
                                    openZipFiles.add(zipFile);
                                    zipFileTL.set(zipFile);
                                }
                                catch (IOException e) {
                                    if (subLog != null) {
                                        subLog.log("Cannot open zipfile: " + jarFile + " : " + e);
                                    }
                                    return null;
                                }
                            }
                            try {
                                Path unzippedFilePath = tempDirPath.resolve(zipEntryNameWithoutPrefix);
                                if (!unzippedFilePath.startsWith(tempDirPath)) {
                                    if (subLog != null) {
                                        subLog.log("Bad path: " + zipEntry.getName());
                                    }
                                    break block22;
                                }
                                File unzippedFile = unzippedFilePath.toFile();
                                if (zipEntry.isDirectory()) {
                                    NestedJarHandler.this.mkDirs.getOrCreateSingleton(unzippedFile, subLog);
                                    break block22;
                                }
                                File parentDir = unzippedFile.getParentFile();
                                boolean parentDirExists = (Boolean)NestedJarHandler.this.mkDirs.getOrCreateSingleton(parentDir, subLog);
                                if (!parentDirExists) break block22;
                                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                                    if (subLog != null) {
                                        subLog.log("Unzipping: " + zipEntry.getName() + " -> " + unzippedFilePath);
                                    }
                                    Files.copy(inputStream, unzippedFilePath, StandardCopyOption.REPLACE_EXISTING);
                                    unzippedFile.deleteOnExit();
                                    NestedJarHandler.this.tempFiles.add(parentDir);
                                }
                            }
                            catch (InvalidPathException ex) {
                                if (subLog == null) break block22;
                                subLog.log("Invalid path: " + zipEntry.getName());
                            }
                        }
                        return null;
                    }
                }));
            }
        }
        catch (Throwable throwable) {
            var12_12 = throwable;
            throw throwable;
        }
        return tempDir;
    }

    private File stripSFXHeader(File zipfile, LogNode log) throws IOException {
        long sfxHeaderBytes = JarUtils.countBytesBeforePKMarker(zipfile);
        if (sfxHeaderBytes == -1L) {
            throw new IOException("Could not find zipfile \"PK\" marker in file " + zipfile);
        }
        if (sfxHeaderBytes == 0L) {
            return zipfile;
        }
        File bareZipfile = File.createTempFile("FCS--", TEMP_FILENAME_LEAF_SEPARATOR + JarUtils.leafName(zipfile.getName()));
        bareZipfile.deleteOnExit();
        this.tempFiles.add(bareZipfile);
        if (log != null) {
            log.log("Zipfile " + zipfile + " contains a self-extracting executable header of " + sfxHeaderBytes + " bytes. Stripping off header to create bare zipfile " + bareZipfile);
        }
        JarUtils.stripSFXHeader(zipfile, sfxHeaderBytes, bareZipfile);
        return bareZipfile;
    }

    public void closeRecyclers() {
        List<Recycler<AutoCloseable, IOException>> recyclers;
        if (this.zipFileToRecyclerMap != null) {
            recyclers = null;
            try {
                recyclers = this.zipFileToRecyclerMap.values();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (recyclers != null) {
                for (Recycler<AutoCloseable, IOException> recycler : recyclers) {
                    recycler.close();
                }
            }
        }
        if (this.moduleRefToModuleReaderProxyRecyclerMap != null) {
            recyclers = null;
            try {
                recyclers = this.moduleRefToModuleReaderProxyRecyclerMap.values();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (recyclers != null) {
                for (Recycler<AutoCloseable, IOException> recycler : recyclers) {
                    recycler.close();
                }
            }
        }
    }

    public void close(LogNode log) {
        this.closeRecyclers();
        if (this.tempFiles != null) {
            LogNode rmLog;
            LogNode logNode = rmLog = this.tempFiles.isEmpty() || log == null ? null : log.log("Removing temporary files");
            while (!this.tempFiles.isEmpty()) {
                File head = this.tempFiles.remove();
                String path = head.getPath();
                boolean success = head.delete();
                if (log == null) continue;
                rmLog.log((success ? "Removed" : "Unable to remove") + " " + path);
            }
        }
    }
}

