/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class Recycler<T extends AutoCloseable, E extends Exception>
implements AutoCloseable {
    private final ConcurrentLinkedQueue<T> allocatedInstances = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<T> unusedInstances = new ConcurrentLinkedQueue();

    public abstract T newInstance() throws E;

    public Recyclable acquire() throws E {
        return new Recyclable();
    }

    @Override
    public void close() {
        AutoCloseable allocatedInstance;
        AutoCloseable unusedInstance;
        HashSet<AutoCloseable> closedInstances = new HashSet<AutoCloseable>();
        while ((unusedInstance = (AutoCloseable)this.unusedInstances.poll()) != null) {
            try {
                unusedInstance.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            closedInstances.add(unusedInstance);
        }
        ArrayList<AutoCloseable> unclosedInstances = new ArrayList<AutoCloseable>();
        while ((allocatedInstance = (AutoCloseable)this.allocatedInstances.poll()) != null) {
            if (closedInstances.contains(allocatedInstance)) continue;
            unclosedInstances.add(allocatedInstance);
        }
        this.allocatedInstances.addAll(unclosedInstances);
    }

    public class Recyclable
    implements AutoCloseable {
        private final T instance;

        public Recyclable() throws Exception {
            AutoCloseable recycledInstance = (AutoCloseable)Recycler.this.unusedInstances.poll();
            if (recycledInstance != null) {
                this.instance = recycledInstance;
            } else {
                Object newInstance = Recycler.this.newInstance();
                if (newInstance == null) {
                    throw new RuntimeException("Failed to allocate a new recyclable instance");
                }
                Recycler.this.allocatedInstances.add(newInstance);
                this.instance = newInstance;
            }
        }

        public T get() {
            return this.instance;
        }

        @Override
        public void close() {
            if (this.instance != null) {
                Recycler.this.unusedInstances.add(this.instance);
            }
        }
    }
}

