/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.sentry.IEnvelopeReader;
import io.sentry.ILogger;
import io.sentry.ISerializer;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeHeader;
import io.sentry.SentryEnvelopeHeaderAdapter;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryEnvelopeItemHeader;
import io.sentry.SentryEnvelopeItemHeaderAdapter;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.Session;
import io.sentry.SessionAdapter;
import io.sentry.UnknownPropertiesTypeAdapterFactory;
import io.sentry.adapters.ContextsDeserializerAdapter;
import io.sentry.adapters.ContextsSerializerAdapter;
import io.sentry.adapters.DateDeserializerAdapter;
import io.sentry.adapters.DateSerializerAdapter;
import io.sentry.adapters.OrientationDeserializerAdapter;
import io.sentry.adapters.OrientationSerializerAdapter;
import io.sentry.adapters.SentryIdDeserializerAdapter;
import io.sentry.adapters.SentryIdSerializerAdapter;
import io.sentry.adapters.SentryLevelDeserializerAdapter;
import io.sentry.adapters.SentryLevelSerializerAdapter;
import io.sentry.adapters.TimeZoneDeserializerAdapter;
import io.sentry.adapters.TimeZoneSerializerAdapter;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.Device;
import io.sentry.protocol.SentryId;
import io.sentry.util.Objects;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GsonSerializer
implements ISerializer {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Gson gson;
    @NotNull
    private final IEnvelopeReader envelopeReader;

    public GsonSerializer(@NotNull ILogger logger2, @NotNull IEnvelopeReader envelopeReader) {
        this.logger = Objects.requireNonNull(logger2, "The ILogger object is required.");
        this.envelopeReader = Objects.requireNonNull(envelopeReader, "The IEnvelopeReader object is required.");
        this.gson = this.provideGson();
    }

    @NotNull
    private Gson provideGson() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter((Type)((Object)SentryId.class), new SentryIdSerializerAdapter(this.logger)).registerTypeAdapter((Type)((Object)SentryId.class), new SentryIdDeserializerAdapter(this.logger)).registerTypeAdapter((Type)((Object)Date.class), new DateSerializerAdapter(this.logger)).registerTypeAdapter((Type)((Object)Date.class), new DateDeserializerAdapter(this.logger)).registerTypeAdapter((Type)((Object)TimeZone.class), new TimeZoneSerializerAdapter(this.logger)).registerTypeAdapter((Type)((Object)TimeZone.class), new TimeZoneDeserializerAdapter(this.logger)).registerTypeAdapter((Type)((Object)Device.DeviceOrientation.class), new OrientationSerializerAdapter(this.logger)).registerTypeAdapter((Type)((Object)Device.DeviceOrientation.class), new OrientationDeserializerAdapter(this.logger)).registerTypeAdapter((Type)((Object)SentryLevel.class), new SentryLevelSerializerAdapter(this.logger)).registerTypeAdapter((Type)((Object)SentryLevel.class), new SentryLevelDeserializerAdapter(this.logger)).registerTypeAdapter((Type)((Object)Contexts.class), new ContextsDeserializerAdapter(this.logger)).registerTypeAdapter((Type)((Object)Contexts.class), new ContextsSerializerAdapter(this.logger)).registerTypeAdapterFactory(UnknownPropertiesTypeAdapterFactory.get()).registerTypeAdapter((Type)((Object)SentryEnvelopeHeader.class), new SentryEnvelopeHeaderAdapter()).registerTypeAdapter((Type)((Object)SentryEnvelopeItemHeader.class), new SentryEnvelopeItemHeaderAdapter()).registerTypeAdapter((Type)((Object)Session.class), new SessionAdapter(this.logger)).create();
    }

    @Override
    @Nullable
    public SentryEvent deserializeEvent(@NotNull Reader reader) {
        Objects.requireNonNull(reader, "The Reader object is required.");
        return this.gson.fromJson(reader, SentryEvent.class);
    }

    @Override
    @Nullable
    public Session deserializeSession(@NotNull Reader reader) {
        Objects.requireNonNull(reader, "The Reader object is required.");
        return this.gson.fromJson(reader, Session.class);
    }

    @Override
    @Nullable
    public SentryEnvelope deserializeEnvelope(@NotNull InputStream inputStream) {
        Objects.requireNonNull(inputStream, "The InputStream object is required.");
        try {
            return this.envelopeReader.read(inputStream);
        }
        catch (IOException e) {
            this.logger.log(SentryLevel.ERROR, "Error deserializing envelope.", e);
            return null;
        }
    }

    @Override
    public void serialize(@NotNull SentryEvent event, @NotNull Writer writer) throws IOException {
        Objects.requireNonNull(event, "The SentryEvent object is required.");
        Objects.requireNonNull(writer, "The Writer object is required.");
        this.gson.toJson((Object)event, (Type)((Object)SentryEvent.class), writer);
        writer.flush();
    }

    @Override
    public void serialize(@NotNull Session session, @NotNull Writer writer) throws IOException {
        Objects.requireNonNull(session, "The Session object is required.");
        Objects.requireNonNull(writer, "The Writer object is required.");
        this.gson.toJson((Object)session, (Type)((Object)Session.class), writer);
        writer.flush();
    }

    @Override
    public void serialize(@NotNull SentryEnvelope envelope, @NotNull Writer writer) throws Exception {
        Objects.requireNonNull(envelope, "The SentryEnvelope object is required.");
        Objects.requireNonNull(writer, "The Writer object is required.");
        this.gson.toJson((Object)envelope.getHeader(), (Type)((Object)SentryEnvelopeHeader.class), writer);
        writer.write("\n");
        for (SentryEnvelopeItem item : envelope.getItems()) {
            this.gson.toJson((Object)item.getHeader(), (Type)((Object)SentryEnvelopeItemHeader.class), writer);
            writer.write("\n");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item.getData()), UTF_8));){
                int charsRead;
                char[] buffer = new char[1024];
                while ((charsRead = reader.read(buffer, 0, buffer.length)) > 0) {
                    writer.write(buffer, 0, charsRead);
                }
            }
            writer.write("\n");
        }
        writer.flush();
    }

    @Override
    public String serialize(@NotNull Map<String, Object> data) throws Exception {
        Objects.requireNonNull(data, "The SentryEnvelope object is required.");
        return this.gson.toJson(data);
    }
}

