/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client.httpclient4;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import net.oauth.client.ExcerptInputStream;
import net.oauth.client.httpclient4.HttpClientPool;
import net.oauth.client.httpclient4.HttpMethodResponse;
import net.oauth.http.HttpClient;
import net.oauth.http.HttpMessage;
import net.oauth.http.HttpResponseMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient4
implements HttpClient {
    private final HttpClientPool clientPool;
    private static final HttpClientPool SHARED_CLIENT = new SingleClient();

    public HttpClient4() {
        this(SHARED_CLIENT);
    }

    public HttpClient4(HttpClientPool clientPool) {
        this.clientPool = clientPool;
    }

    @Override
    public HttpResponseMessage execute(HttpMessage request, Map<String, Object> parameters) throws IOException {
        HttpRequestBase httpRequest;
        String method = request.method;
        String url = request.url.toExternalForm();
        InputStream body = request.getBody();
        boolean isDelete = "DELETE".equalsIgnoreCase(method);
        boolean isPost = "POST".equalsIgnoreCase(method);
        boolean isPut = "PUT".equalsIgnoreCase(method);
        byte[] excerpt = null;
        if (isPost || isPut) {
            Object entityEnclosingMethod;
            Object object = entityEnclosingMethod = isPost ? new HttpPost(url) : new HttpPut(url);
            if (body != null) {
                ExcerptInputStream excerptInputStream = new ExcerptInputStream(body);
                excerpt = excerptInputStream.getExcerpt();
                String string = request.removeHeaders("Content-Length");
                ((HttpEntityEnclosingRequestBase)entityEnclosingMethod).setEntity(new InputStreamEntity((InputStream)excerptInputStream, string == null ? -1L : Long.parseLong(string)));
            }
            httpRequest = entityEnclosingMethod;
        } else {
            httpRequest = isDelete ? new HttpDelete(url) : new HttpGet(url);
        }
        for (Map.Entry entry : request.headers) {
            httpRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        HttpParams params = httpRequest.getParams();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue().toString();
            if ("followRedirects".equals(name)) {
                params.setBooleanParameter("http.protocol.handle-redirects", Boolean.parseBoolean(value));
                continue;
            }
            if ("readTimeout".equals(name)) {
                params.setIntParameter("http.socket.timeout", Integer.parseInt(value));
                continue;
            }
            if (!"connectTimeout".equals(name)) continue;
            params.setIntParameter("http.connection.timeout", Integer.parseInt(value));
        }
        params.setBooleanParameter("http.protocol.expect-continue", false);
        org.apache.http.client.HttpClient httpClient = this.clientPool.getHttpClient(new URL(httpRequest.getURI().toString()));
        HttpResponse httpResponse = httpClient.execute(httpRequest);
        return new HttpMethodResponse(httpRequest, httpResponse, excerpt, request.getContentCharset());
    }

    private static class SingleClient
    implements HttpClientPool {
        private final org.apache.http.client.HttpClient client;

        SingleClient() {
            DefaultHttpClient client = new DefaultHttpClient();
            ClientConnectionManager mgr = client.getConnectionManager();
            if (!(mgr instanceof ThreadSafeClientConnManager)) {
                HttpParams params = client.getParams();
                client = new DefaultHttpClient(new ThreadSafeClientConnManager(params, mgr.getSchemeRegistry()), params);
            }
            this.client = client;
        }

        public org.apache.http.client.HttpClient getHttpClient(URL server) {
            return this.client;
        }
    }
}

