/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import com.hierynomus.asn1.ASN1InputStream;
import com.hierynomus.asn1.encodingrules.ASN1Decoder;
import com.hierynomus.asn1.encodingrules.der.DERDecoder;
import com.hierynomus.asn1.types.constructed.ASN1Sequence;
import com.hierynomus.asn1.types.primitive.ASN1Integer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SignatureException;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.AbstractSignatureDSA;
import net.schmizz.sshj.signature.Signature;

public class SignatureECDSA
extends AbstractSignatureDSA {
    private String keyTypeName;

    public SignatureECDSA(String algorithm, String keyTypeName) {
        super(algorithm, keyTypeName);
        this.keyTypeName = keyTypeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(byte[] sig) {
        byte[] byArray;
        ByteArrayInputStream bais = new ByteArrayInputStream(sig);
        ASN1InputStream asn1InputStream = new ASN1InputStream((ASN1Decoder)new DERDecoder(), bais);
        try {
            ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
            ASN1Integer r = (ASN1Integer)sequence.get(0);
            ASN1Integer s2 = (ASN1Integer)sequence.get(1);
            Buffer.PlainBuffer buf = new Buffer.PlainBuffer();
            buf.putMPInt(r.getValue());
            buf.putMPInt(s2.getValue());
            byArray = buf.getCompactData();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(asn1InputStream, bais);
            throw throwable;
        }
        IOUtils.closeQuietly(asn1InputStream, bais);
        return byArray;
    }

    @Override
    public boolean verify(byte[] sig) {
        try {
            byte[] sigBlob = this.extractSig(sig, this.keyTypeName);
            Buffer.PlainBuffer sigbuf = new Buffer.PlainBuffer(sigBlob);
            BigInteger r = sigbuf.readMPInt();
            BigInteger s2 = sigbuf.readMPInt();
            return this.signature.verify(this.encodeAsnSignature(r, s2));
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
        catch (IOException e) {
            throw new SSHRuntimeException(e);
        }
    }

    public static class Factory521
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureECDSA("SHA512withECDSA", KeyType.ECDSA521.toString());
        }

        @Override
        public String getName() {
            return KeyType.ECDSA521.toString();
        }
    }

    public static class Factory384
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureECDSA("SHA384withECDSA", KeyType.ECDSA384.toString());
        }

        @Override
        public String getName() {
            return KeyType.ECDSA384.toString();
        }
    }

    public static class Factory256
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureECDSA("SHA256withECDSA", KeyType.ECDSA256.toString());
        }

        @Override
        public String getName() {
            return KeyType.ECDSA256.toString();
        }
    }
}

