/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.xa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.postgresql.PGConnection;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.Logger;
import org.postgresql.ds.PGPooledConnection;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.xa.PGXAException;
import org.postgresql.xa.RecoveredXid;

public class PGXAConnection
extends PGPooledConnection
implements XAConnection,
XAResource {
    private final BaseConnection conn;
    private final Logger logger;
    private Xid currentXid;
    private int state;
    private static final int STATE_IDLE = 0;
    private static final int STATE_ACTIVE = 1;
    private static final int STATE_ENDED = 2;
    private boolean localAutoCommitMode = true;

    private void debug(String s2) {
        this.logger.debug("XAResource " + Integer.toHexString(this.hashCode()) + ": " + s2);
    }

    public PGXAConnection(BaseConnection conn) throws SQLException {
        super(conn, true, true);
        this.conn = conn;
        this.state = 0;
        this.logger = conn.getLogger();
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.logger.logDebug()) {
            this.debug("PGXAConnection.getConnection called");
        }
        Connection conn = super.getConnection();
        if (this.state == 0) {
            conn.setAutoCommit(true);
        }
        ConnectionHandler handler = new ConnectionHandler(conn);
        return (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class, PGConnection.class}, (InvocationHandler)handler);
    }

    @Override
    public XAResource getXAResource() {
        return this;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.logger.logDebug()) {
            this.debug("starting transaction xid = " + xid);
        }
        if (flags != 0 && flags != 0x8000000 && flags != 0x200000) {
            throw new PGXAException(GT.tr("Invalid flags"), -5);
        }
        if (xid == null) {
            throw new PGXAException(GT.tr("xid must not be null"), -5);
        }
        if (this.state == 1) {
            throw new PGXAException(GT.tr("Connection is busy with another transaction"), -6);
        }
        if (flags == 0x8000000) {
            throw new PGXAException(GT.tr("suspend/resume not implemented"), -3);
        }
        if (flags == 0x200000) {
            if (this.state != 2) {
                throw new PGXAException(GT.tr("Transaction interleaving not implemented"), -3);
            }
            if (!xid.equals(this.currentXid)) {
                throw new PGXAException(GT.tr("Transaction interleaving not implemented"), -3);
            }
        } else if (this.state == 2) {
            throw new PGXAException(GT.tr("Transaction interleaving not implemented"), -3);
        }
        try {
            this.localAutoCommitMode = this.conn.getAutoCommit();
            this.conn.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new PGXAException(GT.tr("Error disabling autocommit"), ex, -3);
        }
        this.state = 1;
        this.currentXid = xid;
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (this.logger.logDebug()) {
            this.debug("ending transaction xid = " + xid);
        }
        if (flags != 0x2000000 && flags != 0x20000000 && flags != 0x4000000) {
            throw new PGXAException(GT.tr("Invalid flags"), -5);
        }
        if (xid == null) {
            throw new PGXAException(GT.tr("xid must not be null"), -5);
        }
        if (this.state != 1 || !this.currentXid.equals(xid)) {
            throw new PGXAException(GT.tr("tried to call end without corresponding start call"), -6);
        }
        if (flags == 0x2000000) {
            throw new PGXAException(GT.tr("suspend/resume not implemented"), -3);
        }
        this.state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        if (this.logger.logDebug()) {
            this.debug("preparing transaction xid = " + xid);
        }
        if (!this.currentXid.equals(xid)) {
            throw new PGXAException(GT.tr("Not implemented: Prepare must be issued using the same connection that started the transaction"), -3);
        }
        if (this.state != 2) {
            throw new PGXAException(GT.tr("Prepare called before end"), -5);
        }
        this.state = 0;
        this.currentXid = null;
        if (!this.conn.haveMinimumServerVersion("8.1")) {
            throw new PGXAException(GT.tr("Server versions prior to 8.1 do not support two-phase commit."), -3);
        }
        try {
            String s2 = RecoveredXid.xidToString(xid);
            try (Statement stmt = this.conn.createStatement();){
                stmt.executeUpdate("PREPARE TRANSACTION '" + s2 + "'");
            }
            this.conn.setAutoCommit(this.localAutoCommitMode);
            return 0;
        }
        catch (SQLException ex) {
            throw new PGXAException(GT.tr("Error preparing transaction"), ex, -3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int flag) throws XAException {
        Xid[] xidArray;
        if (flag != 0x1000000 && flag != 0x800000 && flag != 0 && flag != 0x1800000) {
            throw new PGXAException(GT.tr("Invalid flag"), -5);
        }
        if ((flag & 0x1000000) == 0) {
            return new Xid[0];
        }
        Statement stmt = this.conn.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT gid FROM pg_prepared_xacts where database = current_database()");
            LinkedList<Xid> l = new LinkedList<Xid>();
            while (rs.next()) {
                Xid recoveredXid = RecoveredXid.stringToXid(rs.getString(1));
                if (recoveredXid == null) continue;
                l.add(recoveredXid);
            }
            rs.close();
            xidArray = l.toArray(new Xid[l.size()]);
        }
        catch (Throwable throwable) {
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException ex) {
                throw new PGXAException(GT.tr("Error during recover"), ex, -3);
            }
        }
        stmt.close();
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        block8: {
            if (this.logger.logDebug()) {
                this.debug("rolling back xid = " + xid);
            }
            try {
                if (this.currentXid != null && xid.equals(this.currentXid)) {
                    this.state = 0;
                    this.currentXid = null;
                    this.conn.rollback();
                    this.conn.setAutoCommit(this.localAutoCommitMode);
                    break block8;
                }
                String s2 = RecoveredXid.xidToString(xid);
                this.conn.setAutoCommit(true);
                try (Statement stmt = this.conn.createStatement();){
                    stmt.executeUpdate("ROLLBACK PREPARED '" + s2 + "'");
                }
            }
            catch (SQLException ex) {
                if (PSQLState.UNDEFINED_OBJECT.getState().equals(ex.getSQLState())) {
                    throw new PGXAException(GT.tr("Error rolling back prepared transaction"), ex, -4);
                }
                throw new PGXAException(GT.tr("Error rolling back prepared transaction"), ex, -3);
            }
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.logger.logDebug()) {
            this.debug("committing xid = " + xid + (onePhase ? " (one phase) " : " (two phase)"));
        }
        if (xid == null) {
            throw new PGXAException(GT.tr("xid must not be null"), -5);
        }
        if (onePhase) {
            this.commitOnePhase(xid);
        } else {
            this.commitPrepared(xid);
        }
    }

    private void commitOnePhase(Xid xid) throws XAException {
        try {
            if (this.currentXid == null || !this.currentXid.equals(xid)) {
                throw new PGXAException(GT.tr("Not implemented: one-phase commit must be issued using the same connection that was used to start it"), -3);
            }
            if (this.state != 2) {
                throw new PGXAException(GT.tr("commit called before end"), -6);
            }
            this.state = 0;
            this.currentXid = null;
            this.conn.commit();
            this.conn.setAutoCommit(this.localAutoCommitMode);
        }
        catch (SQLException ex) {
            throw new PGXAException(GT.tr("Error during one-phase commit"), ex, -3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPrepared(Xid xid) throws XAException {
        try {
            if (this.state != 0 || this.conn.getTransactionState() != 0) {
                throw new PGXAException(GT.tr("Not implemented: 2nd phase commit must be issued using an idle connection"), -3);
            }
            String s2 = RecoveredXid.xidToString(xid);
            this.localAutoCommitMode = this.conn.getAutoCommit();
            this.conn.setAutoCommit(true);
            Statement stmt = this.conn.createStatement();
            try {
                stmt.executeUpdate("COMMIT PREPARED '" + s2 + "'");
            }
            finally {
                stmt.close();
                this.conn.setAutoCommit(this.localAutoCommitMode);
            }
        }
        catch (SQLException ex) {
            throw new PGXAException(GT.tr("Error committing prepared transaction"), ex, -3);
        }
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return xares == this;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        throw new PGXAException(GT.tr("Heuristic commit/rollback not supported"), -4);
    }

    @Override
    public int getTransactionTimeout() {
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) {
        return false;
    }

    private class ConnectionHandler
    implements InvocationHandler {
        private Connection con;

        public ConnectionHandler(Connection con) {
            this.con = con;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            if (PGXAConnection.this.state != 0 && ((methodName = method.getName()).equals("commit") || methodName.equals("rollback") || methodName.equals("setSavePoint") || methodName.equals("setAutoCommit") && ((Boolean)args[0]).booleanValue())) {
                throw new PSQLException(GT.tr("Transaction control methods setAutoCommit(true), commit, rollback and setSavePoint not allowed while an XA transaction is active."), PSQLState.OBJECT_NOT_IN_STATE);
            }
            try {
                InvocationHandler h2;
                Object arg;
                if (method.getName().equals("equals") && Proxy.isProxyClass((arg = args[0]).getClass()) && (h2 = Proxy.getInvocationHandler(arg)) instanceof ConnectionHandler) {
                    args = new Object[]{((ConnectionHandler)h2).con};
                }
                return method.invoke((Object)this.con, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

