/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake;

import java.io.IOException;
import java.io.Writer;
import org.rendersnake.internal.CharactersWriteable;
import org.rendersnake.internal.WriteBuffer;

public class HtmlAttributes
implements CharactersWriteable {
    public static boolean RENDER_DATA_TEST_ATTRIBUTE = true;
    final WriteBuffer out = new WriteBuffer(64);

    public HtmlAttributes() {
    }

    public HtmlAttributes(HtmlAttributes other) {
        this.out.append(other.toHtml());
    }

    public HtmlAttributes(String key, String value) {
        this.add(key, value, true);
    }

    public HtmlAttributes add(String key, String value) {
        return this.add(key, value, true);
    }

    public HtmlAttributes add(String key, String value, boolean doEscape) {
        if (value == null) {
            return this;
        }
        this.out.append(' ');
        this.out.append(key);
        this.out.append('=');
        this.out.append('\"');
        if (doEscape) {
            for (int i = 0; i < value.length(); ++i) {
                char each = value.charAt(i);
                if ('\"' == each) {
                    this.out.append("&quot;");
                    continue;
                }
                if ('\'' == each) {
                    this.out.append("&#39;");
                    continue;
                }
                if ('<' == each) {
                    this.out.append("&lt;");
                    continue;
                }
                if ('>' == each) {
                    this.out.append("&gt;");
                    continue;
                }
                if ('&' == each) {
                    this.out.append("&amp;");
                    continue;
                }
                this.out.append(each);
            }
        } else {
            this.out.append(value);
        }
        this.out.append('\"');
        return this;
    }

    public HtmlAttributes add(String key, Integer value) {
        if (value == null) {
            return this;
        }
        this.out.append(' ');
        this.out.append(key);
        this.out.append('=');
        this.out.append(value);
        return this;
    }

    public HtmlAttributes addScript(String key, String value, boolean doEscape) {
        if (value == null) {
            return this;
        }
        this.out.append(' ');
        this.out.append(key);
        this.out.append('=');
        this.out.append('\"');
        this.out.append(value);
        this.out.append('\"');
        return this;
    }

    public String toString() {
        return super.toString() + "[" + this.out.toString() + "]";
    }

    public void writeCharsOn(Writer writer) throws IOException {
        this.out.writeCharsOn(writer);
    }

    public String toHtml() {
        return this.out.toString();
    }

    public HtmlAttributes flashvars(String flashvars) {
        return this.add("flashvars", flashvars, true);
    }

    public HtmlAttributes allowFullscreen(boolean allow) {
        return this.add("allowFullScreen", Boolean.toString(allow), false);
    }

    public HtmlAttributes allowScriptAccess(String allow) {
        return this.add("allowScriptAccess", allow, true);
    }

    public HtmlAttributes xml_lang(String xmlLang) {
        return this.add("xml:lang", xmlLang, true);
    }

    public HtmlAttributes dataTest(String value) {
        if (RENDER_DATA_TEST_ATTRIBUTE) {
            return this.add("data-test", value, true);
        }
        return this;
    }

    public HtmlAttributes min(Integer min2) {
        return this.add("min", min2);
    }

    public HtmlAttributes max(Integer max) {
        return this.add("max", max);
    }

    public HtmlAttributes value(Integer value) {
        return this.add("value", value);
    }

    public HtmlAttributes data(String extension, String data) {
        return this.add("data-" + extension, data, true);
    }

    public HtmlAttributes data(String extension, Integer number) {
        return this.add("data-" + extension, number);
    }

    public HtmlAttributes summary(String summary) {
        return this.add("summary", summary, true);
    }

    public HtmlAttributes marginheight(String marginheight) {
        return this.add("marginheight", marginheight, true);
    }

    public HtmlAttributes for_(String for_) {
        return this.add("for", for_, true);
    }

    public HtmlAttributes accept(String accept) {
        return this.add("accept", accept, true);
    }

    public HtmlAttributes bgcolor(String bgcolor) {
        return this.add("bgcolor", bgcolor, true);
    }

    public HtmlAttributes accept_charset(String accept_charset) {
        return this.add("accept-charset", accept_charset, true);
    }

    public HtmlAttributes scheme(String scheme) {
        return this.add("scheme", scheme, true);
    }

    public HtmlAttributes border(String border) {
        return this.add("border", border, true);
    }

    public HtmlAttributes vspace(String vspace) {
        return this.add("vspace", vspace, true);
    }

    public HtmlAttributes href(String href) {
        return this.add("href", href, true);
    }

    public HtmlAttributes onDblclick(String ondblclick) {
        return this.addScript("ondblclick", ondblclick, true);
    }

    public HtmlAttributes charset(String charset) {
        return this.add("charset", charset, true);
    }

    public HtmlAttributes longdesc(String longdesc) {
        return this.add("longdesc", longdesc, true);
    }

    public HtmlAttributes noshade(String noshade) {
        return this.add("noshade", noshade, true);
    }

    public HtmlAttributes declare(String declare) {
        return this.add("declare", declare, true);
    }

    public HtmlAttributes content(String content) {
        return this.add("content", content, true);
    }

    public HtmlAttributes cite(String cite) {
        return this.add("cite", cite, true);
    }

    public HtmlAttributes standby(String standby) {
        return this.add("standby", standby, true);
    }

    public HtmlAttributes start(String start) {
        return this.add("start", start, true);
    }

    public HtmlAttributes onMousedown(String onmousedown) {
        return this.addScript("onmousedown", onmousedown, true);
    }

    public HtmlAttributes language(String language) {
        return this.add("language", language, true);
    }

    public HtmlAttributes nohref(String nohref) {
        return this.add("nohref", nohref, true);
    }

    public HtmlAttributes vlink(String vlink) {
        return this.add("vlink", vlink, true);
    }

    public HtmlAttributes face(String face) {
        return this.add("face", face, true);
    }

    public HtmlAttributes rev(String rev) {
        return this.add("rev", rev, true);
    }

    public HtmlAttributes hspace(String hspace) {
        return this.add("hspace", hspace, true);
    }

    public HtmlAttributes link(String link) {
        return this.add("link", link, true);
    }

    public HtmlAttributes onUnload(String onunload) {
        return this.addScript("onunload", onunload, true);
    }

    public HtmlAttributes data(String data) {
        return this.add("data", data, true);
    }

    public HtmlAttributes marginwidth(String marginwidth) {
        return this.add("marginwidth", marginwidth, true);
    }

    public HtmlAttributes accesskey(String accesskey) {
        return this.add("accesskey", accesskey, true);
    }

    public HtmlAttributes version(String version) {
        return this.add("version", version, true);
    }

    public HtmlAttributes http_equiv(String http_equiv) {
        return this.add("http-equiv", http_equiv, true);
    }

    public HtmlAttributes clear(String clear) {
        return this.add("clear", clear, true);
    }

    public HtmlAttributes valuetype(String valuetype) {
        return this.add("valuetype", valuetype, true);
    }

    public HtmlAttributes defer(String defer) {
        return this.add("defer", defer, true);
    }

    public HtmlAttributes title(String title) {
        return this.add("title", title, true);
    }

    public HtmlAttributes enctype(String enctype) {
        return this.add("enctype", enctype, true);
    }

    public HtmlAttributes src(String src) {
        return this.add("src", src, true);
    }

    public HtmlAttributes datetime(String datetime) {
        return this.add("datetime", datetime, true);
    }

    public HtmlAttributes codetype(String codetype) {
        return this.add("codetype", codetype, true);
    }

    public HtmlAttributes charoff(String charoff) {
        return this.add("charoff", charoff, true);
    }

    public HtmlAttributes onKeydown(String onkeydown) {
        return this.addScript("onkeydown", onkeydown, true);
    }

    public HtmlAttributes onKeypress(String onkeypress) {
        return this.addScript("onkeypress", onkeypress, true);
    }

    public HtmlAttributes onSubmit(String onsubmit) {
        return this.addScript("onsubmit", onsubmit, true);
    }

    public HtmlAttributes alink(String alink) {
        return this.add("alink", alink, true);
    }

    public HtmlAttributes background(String background) {
        return this.add("background", background, true);
    }

    public HtmlAttributes method(String method) {
        return this.add("method", method, true);
    }

    public HtmlAttributes archive(String archive) {
        return this.add("archive", archive, true);
    }

    public HtmlAttributes prompt(String prompt) {
        return this.add("prompt", prompt, true);
    }

    public HtmlAttributes rel(String rel) {
        return this.add("rel", rel, true);
    }

    public HtmlAttributes checked(String checked) {
        return this.add("checked", checked, true);
    }

    public HtmlAttributes required(String required) {
        return this.add("required", required, true);
    }

    public HtmlAttributes autofocus(String autofocus) {
        return this.add("autofocus", autofocus, true);
    }

    public HtmlAttributes readonly(String readonly) {
        return this.add("readonly", readonly, true);
    }

    public HtmlAttributes headers(String headers) {
        return this.add("headers", headers, true);
    }

    public HtmlAttributes cols(String cols) {
        return this.add("cols", cols, true);
    }

    public HtmlAttributes cols(Integer cols) {
        return this.add("cols", cols);
    }

    public HtmlAttributes char_(String char_) {
        return this.add("char", char_, true);
    }

    public HtmlAttributes cellpadding(String cellpadding) {
        return this.add("cellpadding", cellpadding, true);
    }

    public HtmlAttributes type(String type) {
        return this.add("type", type, true);
    }

    public HtmlAttributes cellspacing(String cellspacing) {
        return this.add("cellspacing", cellspacing, true);
    }

    public HtmlAttributes hreflang(String hreflang) {
        return this.add("hreflang", hreflang, true);
    }

    public HtmlAttributes frameborder(String frameborder) {
        return this.add("frameborder", frameborder, true);
    }

    public HtmlAttributes compact(String compact) {
        return this.add("compact", compact, true);
    }

    public HtmlAttributes height(String height) {
        return this.add("height", height, true);
    }

    public HtmlAttributes height(Integer height) {
        return this.add("height", height);
    }

    public HtmlAttributes maxlength(String maxlength) {
        return this.add("maxlength", maxlength, true);
    }

    public HtmlAttributes maxlength(int maxlength) {
        return this.add("maxlength", maxlength);
    }

    public HtmlAttributes onBlur(String onblur) {
        return this.addScript("onblur", onblur, true);
    }

    public HtmlAttributes value(String value) {
        return this.add("value", value, true);
    }

    public HtmlAttributes action(String action) {
        return this.add("action", action, true);
    }

    public HtmlAttributes text(String text) {
        return this.add("text", text, true);
    }

    public HtmlAttributes colspan(String colspan) {
        return this.add("colspan", colspan, true);
    }

    public HtmlAttributes onMouseout(String onmouseout) {
        return this.addScript("onmouseout", onmouseout, true);
    }

    public HtmlAttributes width(String width) {
        return this.add("width", width, true);
    }

    public HtmlAttributes width(Integer width) {
        return this.add("width", width);
    }

    public HtmlAttributes align(String align) {
        return this.add("align", align, true);
    }

    public HtmlAttributes abbr(String abbr) {
        return this.add("abbr", abbr, true);
    }

    public HtmlAttributes class_(String class_) {
        return this.add("class", class_, true);
    }

    public HtmlAttributes onKeyup(String onkeyup) {
        return this.addScript("onkeyup", onkeyup, true);
    }

    public HtmlAttributes label(String label) {
        return this.add("label", label, true);
    }

    public HtmlAttributes onFocus(String onfocus) {
        return this.addScript("onfocus", onfocus, true);
    }

    public HtmlAttributes shape(String shape) {
        return this.add("shape", shape, true);
    }

    public HtmlAttributes code(String code) {
        return this.add("code", code, true);
    }

    public HtmlAttributes rowspan(String rowspan) {
        return this.add("rowspan", rowspan, true);
    }

    public HtmlAttributes noresize(String noresize) {
        return this.add("noresize", noresize, true);
    }

    public HtmlAttributes size(String size) {
        return this.add("size", size, true);
    }

    public HtmlAttributes size(Integer size) {
        return this.add("size", size);
    }

    public HtmlAttributes onReset(String onreset) {
        return this.addScript("onreset", onreset, true);
    }

    public HtmlAttributes rows(String rows) {
        return this.add("rows", rows, true);
    }

    public HtmlAttributes rows(Integer rows) {
        return this.add("rows", rows);
    }

    public HtmlAttributes frame(String frame) {
        return this.add("frame", frame, true);
    }

    public HtmlAttributes onSelect(String onselect) {
        return this.addScript("onselect", onselect, true);
    }

    public HtmlAttributes scrolling(String scrolling) {
        return this.add("scrolling", scrolling, true);
    }

    public HtmlAttributes media(String media) {
        return this.add("media", media, true);
    }

    public HtmlAttributes span(String span) {
        return this.add("span", span, true);
    }

    public HtmlAttributes scope(String scope) {
        return this.add("scope", scope, true);
    }

    public HtmlAttributes usemap(String usemap) {
        return this.add("usemap", usemap, true);
    }

    public HtmlAttributes object(String object) {
        return this.add("object", object, true);
    }

    public HtmlAttributes lang(String lang) {
        return this.add("lang", lang, true);
    }

    public HtmlAttributes id(String id) {
        return this.add("id", id, true);
    }

    public HtmlAttributes selected(String selected) {
        return this.add("selected", selected, true);
    }

    public HtmlAttributes ismap(String ismap) {
        return this.add("ismap", ismap, true);
    }

    public HtmlAttributes style(String style) {
        return this.add("style", style, true);
    }

    public HtmlAttributes dir(String dir) {
        return this.add("dir", dir, true);
    }

    public HtmlAttributes alt(String alt) {
        return this.add("alt", alt, true);
    }

    public HtmlAttributes name(String name) {
        return this.add("name", name, true);
    }

    public HtmlAttributes onMouseup(String onmouseup) {
        return this.addScript("onmouseup", onmouseup, true);
    }

    public HtmlAttributes nowrap(String nowrap) {
        return this.add("nowrap", nowrap, true);
    }

    public HtmlAttributes multiple(String multiple) {
        return this.add("multiple", multiple, true);
    }

    public HtmlAttributes classid(String classid) {
        return this.add("classid", classid, true);
    }

    public HtmlAttributes profile(String profile) {
        return this.add("profile", profile, true);
    }

    public HtmlAttributes axis(String axis) {
        return this.add("axis", axis, true);
    }

    public HtmlAttributes onMousemove(String onmousemove) {
        return this.addScript("onmousemove", onmousemove, true);
    }

    public HtmlAttributes tabindex(String tabindex) {
        return this.add("tabindex", tabindex, true);
    }

    public HtmlAttributes onChange(String onchange) {
        return this.addScript("onchange", onchange, true);
    }

    public HtmlAttributes rules(String rules) {
        return this.add("rules", rules, true);
    }

    public HtmlAttributes onMouseover(String onmouseover) {
        return this.addScript("onmouseover", onmouseover, true);
    }

    public HtmlAttributes coords(String coords) {
        return this.add("coords", coords, true);
    }

    public HtmlAttributes color(String color) {
        return this.add("color", color, true);
    }

    public HtmlAttributes onLoad(String onload) {
        return this.addScript("onload", onload, true);
    }

    public HtmlAttributes target(String target) {
        return this.add("target", target, true);
    }

    public HtmlAttributes onClick(String onclick) {
        return this.addScript("onclick", onclick, true);
    }

    public HtmlAttributes valign(String valign) {
        return this.add("valign", valign, true);
    }

    public HtmlAttributes disabled(String disabled) {
        return this.add("disabled", disabled, true);
    }

    public HtmlAttributes codebase(String codebase) {
        return this.add("codebase", codebase, true);
    }

    public HtmlAttributes onContextmenu(String script) {
        return this.addScript("oncontextmenu", script, true);
    }

    public HtmlAttributes onFormchange(String script) {
        return this.addScript("onformchange", script, true);
    }

    public HtmlAttributes onForminput(String script) {
        return this.addScript("onforminput", script, true);
    }

    public HtmlAttributes onInput(String script) {
        return this.addScript("oninput", script, true);
    }

    public HtmlAttributes onInvalid(String script) {
        return this.addScript("oninvalid", script, true);
    }

    public HtmlAttributes onCanplay(String script) {
        return this.addScript("oncanplay", script, true);
    }

    public HtmlAttributes onCanplaythrough(String script) {
        return this.addScript("oncanplaythrough", script, true);
    }

    public HtmlAttributes onDurationchange(String script) {
        return this.addScript("ondurationchange", script, true);
    }

    public HtmlAttributes onEmptied(String script) {
        return this.addScript("onemptied", script, true);
    }

    public HtmlAttributes onEnded(String script) {
        return this.addScript("onended", script, true);
    }

    public HtmlAttributes onLoadeddata(String script) {
        return this.addScript("onloadeddata", script, true);
    }

    public HtmlAttributes onLoadedmetadata(String script) {
        return this.addScript("onloadedmetadata", script, true);
    }

    public HtmlAttributes onLoadstart(String script) {
        return this.addScript("onloadstart", script, true);
    }

    public HtmlAttributes onPause(String script) {
        return this.addScript("onpause", script, true);
    }

    public HtmlAttributes onPlay(String script) {
        return this.addScript("onplay", script, true);
    }

    public HtmlAttributes onPlaying(String script) {
        return this.addScript("onplaying", script, true);
    }

    public HtmlAttributes onProgress(String script) {
        return this.addScript("onprogress", script, true);
    }

    public HtmlAttributes onRatechange(String script) {
        return this.addScript("onratechange", script, true);
    }

    public HtmlAttributes onReadystatechange(String script) {
        return this.addScript("onreadystatechange", script, true);
    }

    public HtmlAttributes onSeeked(String script) {
        return this.addScript("onseeked", script, true);
    }

    public HtmlAttributes onSeeking(String script) {
        return this.addScript("onseeking", script, true);
    }

    public HtmlAttributes onStalled(String script) {
        return this.addScript("onstalled", script, true);
    }

    public HtmlAttributes onSuspend(String script) {
        return this.addScript("onsuspend", script, true);
    }

    public HtmlAttributes onTimeupdate(String script) {
        return this.addScript("ontimeupdate", script, true);
    }

    public HtmlAttributes onVolumechange(String script) {
        return this.addScript("onvolumechange", script, true);
    }

    public HtmlAttributes onWaiting(String script) {
        return this.addScript("onwaiting", script, true);
    }

    public HtmlAttributes onDrag(String script) {
        return this.addScript("ondrag", script, true);
    }

    public HtmlAttributes onDragend(String script) {
        return this.addScript("ondragend", script, true);
    }

    public HtmlAttributes onDragenter(String script) {
        return this.addScript("ondragenter", script, true);
    }

    public HtmlAttributes onDragleave(String script) {
        return this.addScript("ondragleave", script, true);
    }

    public HtmlAttributes onDragover(String script) {
        return this.addScript("ondragover", script, true);
    }

    public HtmlAttributes onDragstart(String script) {
        return this.addScript("ondragstart", script, true);
    }

    public HtmlAttributes onDrop(String script) {
        return this.addScript("ondrop", script, true);
    }

    public HtmlAttributes onMousewheel(String script) {
        return this.addScript("onmousewheel", script, true);
    }

    public HtmlAttributes onScroll(String script) {
        return this.addScript("onscroll", script, true);
    }

    public HtmlAttributes contenteditable(String truefalse) {
        return this.add("contenteditable", truefalse, true);
    }

    public HtmlAttributes contextmenu(String menu_id) {
        return this.add("contextmenu", menu_id, true);
    }

    public HtmlAttributes draggable(String truefalseauto) {
        return this.add("draggable", truefalseauto, true);
    }

    public HtmlAttributes dropzone(String copymovelink) {
        return this.add("dropzone", copymovelink, true);
    }

    public HtmlAttributes hidden(String hidden) {
        return this.add("hidden", hidden, true);
    }

    public HtmlAttributes spellcheck(String truefalse) {
        return this.add("spellcheck", truefalse, true);
    }

    public HtmlAttributes onAfterprint(String script) {
        return this.addScript("onafterprint", script, true);
    }

    public HtmlAttributes onBeforeprint(String script) {
        return this.addScript("onbeforeprint", script, true);
    }

    public HtmlAttributes onBeforeonload(String script) {
        return this.addScript("onbeforeonload", script, true);
    }

    public HtmlAttributes onError(String script) {
        return this.addScript("onerror", script, true);
    }

    public HtmlAttributes onHaschange(String script) {
        return this.addScript("onhaschange", script, true);
    }

    public HtmlAttributes onMessage(String script) {
        return this.addScript("onmessage", script, true);
    }

    public HtmlAttributes onOffline(String script) {
        return this.addScript("onoffline", script, true);
    }

    public HtmlAttributes onOnline(String script) {
        return this.addScript("ononline", script, true);
    }

    public HtmlAttributes onPagehide(String script) {
        return this.addScript("onpagehide", script, true);
    }

    public HtmlAttributes onPageshow(String script) {
        return this.addScript("onpageshow", script, true);
    }

    public HtmlAttributes onPopstate(String script) {
        return this.addScript("onpopstate", script, true);
    }

    public HtmlAttributes onRedo(String script) {
        return this.addScript("onredo", script, true);
    }

    public HtmlAttributes onResize(String script) {
        return this.addScript("onresize", script, true);
    }

    public HtmlAttributes onStorage(String script) {
        return this.addScript("onstorage", script, true);
    }

    public HtmlAttributes onUndo(String script) {
        return this.addScript("onundo", script, true);
    }

    public HtmlAttributes dataTheme(String dataTheme) {
        return this.add("data-theme", dataTheme, false);
    }

    public HtmlAttributes dataPosition(String dataPosition) {
        return this.add("data-position", dataPosition, false);
    }

    public HtmlAttributes dataNoBackButton(boolean noBackButton) {
        return this.add("data-nobackbtn", String.valueOf(noBackButton), false);
    }

    public HtmlAttributes dataTransition(String transition) {
        return this.add("data-transition", transition, false);
    }

    public HtmlAttributes dataRel(String rel) {
        return this.add("data-rel", rel, false);
    }

    public HtmlAttributes dataIcon(String icon) {
        return this.add("data-icon", icon, false);
    }

    public HtmlAttributes dataIconPos(String pos) {
        return this.add("data-iconpos", pos, false);
    }

    public HtmlAttributes role(String role) {
        return this.add("role", role, false);
    }

    public HtmlAttributes dataInset(boolean inset) {
        return this.add("data-inset", String.valueOf(inset), false);
    }

    public HtmlAttributes dataInline(boolean inline) {
        return this.add("data-inline", String.valueOf(inline), false);
    }

    public HtmlAttributes dataRole(String role) {
        return this.add("data-role", role, false);
    }

    public HtmlAttributes dataCollapsed(boolean collapsed) {
        return this.add("data-collapsed", String.valueOf(collapsed), false);
    }

    public HtmlAttributes dataType(String type) {
        return this.add("data-type", type, false);
    }

    public HtmlAttributes dataDirection(String direction) {
        return this.add("data-direction", direction, false);
    }

    public HtmlAttributes dataScroll(String xy) {
        return this.add("data-scroll", xy, false);
    }

    public HtmlAttributes dataInline(String inline) {
        return this.add("data-inline", inline, false);
    }

    public HtmlAttributes dataMini(boolean isMini) {
        return this.add("data-mini", Boolean.toString(isMini), false);
    }

    public HtmlAttributes dataContentTheme(String dataContentTheme) {
        return this.add("data-content-theme", dataContentTheme, false);
    }

    public HtmlAttributes dataAjax(boolean enabled) {
        return this.add("data-ajax", Boolean.toString(enabled), false);
    }

    public HtmlAttributes selected_if(boolean condition) {
        return condition ? this.selected("selected") : this;
    }

    public HtmlAttributes checked_if(boolean condition) {
        return condition ? this.checked("checked") : this;
    }

    public HtmlAttributes disabled_if(boolean condition) {
        return condition ? this.disabled("disabled") : this;
    }

    public HtmlAttributes autofocus_if(boolean condition) {
        return condition ? this.autofocus("autofocus") : this;
    }

    public HtmlAttributes required_if(boolean condition) {
        return condition ? this.required("required") : this;
    }
}

