/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.rendersnake.CanvasMacros;
import org.rendersnake.HtmlAttributes;
import org.rendersnake.PageContext;
import org.rendersnake.Renderable;
import org.rendersnake.RequestUtils;
import org.rendersnake.error.RenderException;
import org.rendersnake.internal.CharactersWriteable;
import org.rendersnake.internal.ContextMap;
import org.rendersnake.internal.HtmlEscapeHandler;
import org.rendersnake.internal.SinkCanvas;
import org.rendersnake.internal.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlCanvas {
    public static HtmlEscapeHandler HTML_ESCAPE_HANDLER;
    public static final boolean NO_ESCAPE = false;
    protected Writer out;
    protected ArrayList<String> openTagStack = new ArrayList(INITIAL_STACK_CAPACITY);
    public static int INITIAL_STACK_CAPACITY;
    private int lastId = 0;
    private PageContext pageContext;
    private CanvasMacros<? extends HtmlCanvas> canvasMacros;

    public HtmlCanvas(Writer output) {
        this.out = output;
    }

    public HtmlCanvas() {
        this.out = new StringWriter(1024);
    }

    public CanvasMacros<?> macros() {
        if (this.canvasMacros == null) {
            this.canvasMacros = this.createMacros();
        }
        return this.canvasMacros;
    }

    public HtmlCanvas content(String aString) throws IOException {
        this.write(aString);
        return this.close();
    }

    public HtmlCanvas content(String aString, boolean escapeNeeded) throws IOException {
        this.write(aString, escapeNeeded);
        return this.close();
    }

    public HtmlCanvas createLocalCanvas() {
        return new HtmlCanvas();
    }

    public CanvasMacros<? extends HtmlCanvas> createMacros() {
        return new CanvasMacros<HtmlCanvas>(this);
    }

    public Writer getOutputWriter() {
        return this.out;
    }

    public String nextId() {
        ++this.lastId;
        return "" + 'i' + 'd' + this.lastId;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("[depth=");
        buffer.append(this.openTagStack.size());
        buffer.append(']');
        buffer.append(this.openTagStack);
        return buffer.toString();
    }

    public String toHtml() {
        return this.out.toString();
    }

    private static HtmlEscapeHandler getHtmlEscapeHandler() {
        if (HTML_ESCAPE_HANDLER == null) {
            throw new IllegalStateException("HTML Escape Handler not set.Either the Apache commons lang3 library is missing oryou need to provide an implementation of HtmlEscapeHandler yourself.");
        }
        return HTML_ESCAPE_HANDLER;
    }

    public HtmlCanvas write(String unescapedString) throws IOException {
        if (unescapedString == null) {
            return this;
        }
        HtmlCanvas.getHtmlEscapeHandler().escapeHtml(this.out, unescapedString);
        return this;
    }

    public HtmlCanvas write(char ch) throws IOException {
        this.out.append(ch);
        return this;
    }

    public HtmlCanvas write(String text, boolean escapeNeeded) throws IOException {
        if (text == null) {
            return this;
        }
        if (escapeNeeded) {
            HtmlCanvas.getHtmlEscapeHandler().escapeHtml(this.out, text);
        } else {
            this.out.write(text);
        }
        return this;
    }

    public HtmlCanvas cdata() throws IOException {
        this.out.write("/*<![CDATA[*/");
        this.openTagStack.add("/*]]>*/");
        return this;
    }

    public HtmlCanvas _cdata() throws IOException {
        return this.close("/*]]>*/");
    }

    public HtmlCanvas close() throws IOException {
        if (this.openTagStack.isEmpty()) {
            throw RenderException.emptyStack();
        }
        this.out.write(this.openTagStack.remove(this.openTagStack.size() - 1));
        return this;
    }

    public HtmlCanvas close(String expectedTag) throws IOException {
        if (this.openTagStack.isEmpty()) {
            throw RenderException.emptyStack();
        }
        String popped = this.openTagStack.remove(this.openTagStack.size() - 1);
        if (!popped.equals(expectedTag)) {
            throw RenderException.unexpectedTag(popped, expectedTag);
        }
        this.out.write(popped);
        return this;
    }

    public HtmlCanvas render(Renderable component) throws IOException {
        if (component == null) {
            return this;
        }
        if (this.pageContext != null) {
            this.pageContext.beginRender();
            component.renderOn(this);
            this.pageContext.endRender();
        } else {
            component.renderOn(this);
        }
        return this;
    }

    public HtmlCanvas render_if(Renderable component, boolean condition) throws IOException {
        return condition ? this.render(component) : this;
    }

    public HtmlAttributes attributes() {
        return new HtmlAttributes();
    }

    public HtmlCanvas tag(String tagName) throws IOException {
        if (tagName == null) {
            throw RenderException.nullTag();
        }
        this.out.write(60);
        this.out.write(tagName);
        this.out.write(62);
        StringBuilder buffer = new StringBuilder(tagName.length() + 3);
        buffer.append('<').append('/').append(tagName).append('>');
        this.openTagStack.add(buffer.toString());
        return this;
    }

    public HtmlCanvas tag_close(String tagName) throws IOException {
        if (tagName == null) {
            throw RenderException.nullTag();
        }
        StringBuilder buffer = new StringBuilder(tagName.length() + 3);
        buffer.append('<').append('/').append(tagName).append('>');
        return this.close(buffer.toString());
    }

    public HtmlCanvas tag(String tagName, CharactersWriteable attrs) throws IOException {
        if (tagName == null) {
            throw RenderException.nullTag();
        }
        this.out.write(60);
        this.out.append(tagName);
        attrs.writeCharsOn(this.out);
        this.out.write(62);
        this.openTagStack.add("</" + tagName + '>');
        return this;
    }

    public boolean hasPageContext() {
        return this.pageContext != null;
    }

    public PageContext getPageContext() {
        if (null == this.pageContext) {
            this.pageContext = this.createPageContext();
        }
        return this.pageContext;
    }

    @Deprecated
    public ContextMap getSession() {
        return RequestUtils.getSession(this);
    }

    @Deprecated
    public ContextMap getRequestParameters() {
        return RequestUtils.getParameters(this);
    }

    @Deprecated
    public ContextMap getPathParameters() {
        return this.getPageContext().getContextMap("http.request.path");
    }

    public HtmlCanvas if_(boolean condition) throws IOException {
        if (condition) {
            return this;
        }
        return new SinkCanvas(this);
    }

    public HtmlCanvas _if() throws IOException {
        return this;
    }

    protected PageContext createPageContext() {
        return new PageContext();
    }

    public HtmlCanvas a() throws IOException {
        this.out.write("<a>");
        this.openTagStack.add("</a>");
        return this;
    }

    public HtmlCanvas a(CharactersWriteable attrs) throws IOException {
        this.out.write("<a");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</a>");
        return this;
    }

    public HtmlCanvas _a() throws IOException {
        return this.close("</a>");
    }

    public HtmlCanvas abbr() throws IOException {
        this.out.write("<abbr>");
        this.openTagStack.add("</abbr>");
        return this;
    }

    public HtmlCanvas abbr(CharactersWriteable attrs) throws IOException {
        this.out.write("<abbr");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</abbr>");
        return this;
    }

    public HtmlCanvas _abbr() throws IOException {
        return this.close("</abbr>");
    }

    public HtmlCanvas acronym() throws IOException {
        this.out.write("<acronym>");
        this.openTagStack.add("</acronym>");
        return this;
    }

    public HtmlCanvas acronym(CharactersWriteable attrs) throws IOException {
        this.out.write("<acronym");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</acronym>");
        return this;
    }

    public HtmlCanvas _acronym() throws IOException {
        return this.close("</acronym>");
    }

    public HtmlCanvas em() throws IOException {
        this.out.write("<em>");
        this.openTagStack.add("</em>");
        return this;
    }

    public HtmlCanvas em(CharactersWriteable attrs) throws IOException {
        this.out.write("<em");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</em>");
        return this;
    }

    public HtmlCanvas _em() throws IOException {
        return this.close("</em>");
    }

    public HtmlCanvas strong() throws IOException {
        this.out.write("<strong>");
        this.openTagStack.add("</strong>");
        return this;
    }

    public HtmlCanvas strong(CharactersWriteable attrs) throws IOException {
        this.out.write("<strong");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</strong>");
        return this;
    }

    public HtmlCanvas _strong() throws IOException {
        return this.close("</strong>");
    }

    public HtmlCanvas cite() throws IOException {
        this.out.write("<cite>");
        this.openTagStack.add("</cite>");
        return this;
    }

    public HtmlCanvas cite(CharactersWriteable attrs) throws IOException {
        this.out.write("<cite");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</cite>");
        return this;
    }

    public HtmlCanvas _cite() throws IOException {
        return this.close("</cite>");
    }

    public HtmlCanvas dfn() throws IOException {
        this.out.write("<dfn>");
        this.openTagStack.add("</dfn>");
        return this;
    }

    public HtmlCanvas dfn(CharactersWriteable attrs) throws IOException {
        this.out.write("<dfn");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</dfn>");
        return this;
    }

    public HtmlCanvas _dfn() throws IOException {
        return this.close("</dfn>");
    }

    public HtmlCanvas code() throws IOException {
        this.out.write("<code>");
        this.openTagStack.add("</code>");
        return this;
    }

    public HtmlCanvas code(CharactersWriteable attrs) throws IOException {
        this.out.write("<code");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</code>");
        return this;
    }

    public HtmlCanvas _code() throws IOException {
        return this.close("</code>");
    }

    public HtmlCanvas samp() throws IOException {
        this.out.write("<samp>");
        this.openTagStack.add("</samp>");
        return this;
    }

    public HtmlCanvas samp(CharactersWriteable attrs) throws IOException {
        this.out.write("<samp");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</samp>");
        return this;
    }

    public HtmlCanvas _samp() throws IOException {
        return this.close("</samp>");
    }

    public HtmlCanvas kbd() throws IOException {
        this.out.write("<kbd>");
        this.openTagStack.add("</kbd>");
        return this;
    }

    public HtmlCanvas kbd(CharactersWriteable attrs) throws IOException {
        this.out.write("<kbd");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</kbd>");
        return this;
    }

    public HtmlCanvas _kbd() throws IOException {
        return this.close("</kbd>");
    }

    public HtmlCanvas var() throws IOException {
        this.out.write("<var>");
        this.openTagStack.add("</var>");
        return this;
    }

    public HtmlCanvas var(CharactersWriteable attrs) throws IOException {
        this.out.write("<var");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</var>");
        return this;
    }

    public HtmlCanvas _var() throws IOException {
        return this.close("</var>");
    }

    public HtmlCanvas address() throws IOException {
        this.out.write("<address>");
        this.openTagStack.add("</address>");
        return this;
    }

    public HtmlCanvas address(CharactersWriteable attrs) throws IOException {
        this.out.write("<address");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</address>");
        return this;
    }

    public HtmlCanvas _address() throws IOException {
        return this.close("</address>");
    }

    @Deprecated
    public HtmlCanvas applet() throws IOException {
        this.out.write("<applet>");
        this.openTagStack.add("</applet>");
        return this;
    }

    @Deprecated
    public HtmlCanvas applet(CharactersWriteable attrs) throws IOException {
        this.out.write("<applet");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</applet>");
        return this;
    }

    public HtmlCanvas _applet() throws IOException {
        return this.close("</applet>");
    }

    public HtmlCanvas area(CharactersWriteable attrs) throws IOException {
        this.out.write("<area");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(47);
        this.out.write(62);
        return this;
    }

    public HtmlCanvas map() throws IOException {
        this.out.write("<map>");
        this.openTagStack.add("</map>");
        return this;
    }

    public HtmlCanvas map(CharactersWriteable attrs) throws IOException {
        this.out.write("<map");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</map>");
        return this;
    }

    public HtmlCanvas _map() throws IOException {
        return this.close("</map>");
    }

    public HtmlCanvas b() throws IOException {
        this.out.write("<b>");
        this.openTagStack.add("</b>");
        return this;
    }

    public HtmlCanvas b(CharactersWriteable attrs) throws IOException {
        this.out.write("<b");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</b>");
        return this;
    }

    public HtmlCanvas _b() throws IOException {
        return this.close("</b>");
    }

    public HtmlCanvas tt() throws IOException {
        this.out.write("<tt>");
        this.openTagStack.add("</tt>");
        return this;
    }

    public HtmlCanvas tt(CharactersWriteable attrs) throws IOException {
        this.out.write("<tt");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</tt>");
        return this;
    }

    public HtmlCanvas _tt() throws IOException {
        return this.close("</tt>");
    }

    public HtmlCanvas i() throws IOException {
        this.out.write("<i>");
        this.openTagStack.add("</i>");
        return this;
    }

    public HtmlCanvas i(CharactersWriteable attrs) throws IOException {
        this.out.write("<i");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</i>");
        return this;
    }

    public HtmlCanvas _i() throws IOException {
        return this.close("</i>");
    }

    public HtmlCanvas big() throws IOException {
        this.out.write("<big>");
        this.openTagStack.add("</big>");
        return this;
    }

    public HtmlCanvas big(CharactersWriteable attrs) throws IOException {
        this.out.write("<big");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</big>");
        return this;
    }

    public HtmlCanvas _big() throws IOException {
        return this.close("</big>");
    }

    public HtmlCanvas small() throws IOException {
        this.out.write("<small>");
        this.openTagStack.add("</small>");
        return this;
    }

    public HtmlCanvas small(CharactersWriteable attrs) throws IOException {
        this.out.write("<small");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</small>");
        return this;
    }

    public HtmlCanvas _small() throws IOException {
        return this.close("</small>");
    }

    @Deprecated
    public HtmlCanvas strike() throws IOException {
        this.out.write("<strike>");
        this.openTagStack.add("</strike>");
        return this;
    }

    @Deprecated
    public HtmlCanvas strike(CharactersWriteable attrs) throws IOException {
        this.out.write("<strike");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</strike>");
        return this;
    }

    public HtmlCanvas _strike() throws IOException {
        return this.close("</strike>");
    }

    @Deprecated
    public HtmlCanvas s() throws IOException {
        this.out.write("<s>");
        this.openTagStack.add("</s>");
        return this;
    }

    @Deprecated
    public HtmlCanvas s(CharactersWriteable attrs) throws IOException {
        this.out.write("<s");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</s>");
        return this;
    }

    public HtmlCanvas _s() throws IOException {
        return this.close("</s>");
    }

    @Deprecated
    public HtmlCanvas u() throws IOException {
        this.out.write("<u>");
        this.openTagStack.add("</u>");
        return this;
    }

    @Deprecated
    public HtmlCanvas u(CharactersWriteable attrs) throws IOException {
        this.out.write("<u");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</u>");
        return this;
    }

    public HtmlCanvas _u() throws IOException {
        return this.close("</u>");
    }

    public HtmlCanvas base(CharactersWriteable attrs) throws IOException {
        this.out.write("<base");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(47);
        this.out.write(62);
        return this;
    }

    @Deprecated
    public HtmlCanvas basefont() throws IOException {
        this.out.write("<basefont>");
        this.openTagStack.add("</basefont>");
        return this;
    }

    @Deprecated
    public HtmlCanvas basefont(CharactersWriteable attrs) throws IOException {
        this.out.write("<basefont");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</basefont>");
        return this;
    }

    @Deprecated
    public HtmlCanvas font() throws IOException {
        this.out.write("<font>");
        this.openTagStack.add("</font>");
        return this;
    }

    @Deprecated
    public HtmlCanvas font(CharactersWriteable attrs) throws IOException {
        this.out.write("<font");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</font>");
        return this;
    }

    public HtmlCanvas _font() throws IOException {
        return this.close("</font>");
    }

    public HtmlCanvas bdo() throws IOException {
        this.out.write("<bdo>");
        this.openTagStack.add("</bdo>");
        return this;
    }

    public HtmlCanvas bdo(CharactersWriteable attrs) throws IOException {
        this.out.write("<bdo");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</bdo>");
        return this;
    }

    public HtmlCanvas _bdo() throws IOException {
        return this.close("</bdo>");
    }

    public HtmlCanvas body() throws IOException {
        this.out.write("<body>");
        this.openTagStack.add("</body>");
        return this;
    }

    public HtmlCanvas body(CharactersWriteable attrs) throws IOException {
        this.out.write("<body");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</body>");
        return this;
    }

    public HtmlCanvas _body() throws IOException {
        return this.close("</body>");
    }

    public HtmlCanvas br() throws IOException {
        this.out.write("<br/>");
        return this;
    }

    public HtmlCanvas br(CharactersWriteable attrs) throws IOException {
        this.out.write("<br");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write("/>");
        return this;
    }

    public HtmlCanvas button() throws IOException {
        this.out.write("<button>");
        this.openTagStack.add("</button>");
        return this;
    }

    public HtmlCanvas button(CharactersWriteable attrs) throws IOException {
        this.out.write("<button");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</button>");
        return this;
    }

    public HtmlCanvas _button() throws IOException {
        return this.close("</button>");
    }

    public HtmlCanvas caption() throws IOException {
        this.out.write("<caption>");
        this.openTagStack.add("</caption>");
        return this;
    }

    public HtmlCanvas caption(CharactersWriteable attrs) throws IOException {
        this.out.write("<caption");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</caption>");
        return this;
    }

    public HtmlCanvas _caption() throws IOException {
        return this.close("</caption>");
    }

    @Deprecated
    public HtmlCanvas center() throws IOException {
        this.out.write("<center>");
        this.openTagStack.add("</center>");
        return this;
    }

    public HtmlCanvas col(CharactersWriteable attrs) throws IOException {
        this.out.write("<col");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(47);
        this.out.write(62);
        return this;
    }

    public HtmlCanvas colgroup() throws IOException {
        this.out.write("<colgroup>");
        this.openTagStack.add("</colgroup>");
        return this;
    }

    public HtmlCanvas colgroup(CharactersWriteable attrs) throws IOException {
        this.out.write("<colgroup");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</colgroup>");
        return this;
    }

    public HtmlCanvas _colgroup() throws IOException {
        return this.close("</colgroup>");
    }

    public HtmlCanvas dd() throws IOException {
        this.out.write("<dd>");
        this.openTagStack.add("</dd>");
        return this;
    }

    public HtmlCanvas dd(CharactersWriteable attrs) throws IOException {
        this.out.write("<dd");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</dd>");
        return this;
    }

    public HtmlCanvas _dd() throws IOException {
        return this.close("</dd>");
    }

    public HtmlCanvas dl() throws IOException {
        this.out.write("<dl>");
        this.openTagStack.add("</dl>");
        return this;
    }

    public HtmlCanvas dl(CharactersWriteable attrs) throws IOException {
        this.out.write("<dl");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</dl>");
        return this;
    }

    public HtmlCanvas _dl() throws IOException {
        return this.close("</dl>");
    }

    public HtmlCanvas dt() throws IOException {
        this.out.write("<dt>");
        this.openTagStack.add("</dt>");
        return this;
    }

    public HtmlCanvas dt(CharactersWriteable attrs) throws IOException {
        this.out.write("<dt");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</dt>");
        return this;
    }

    public HtmlCanvas _dt() throws IOException {
        return this.close("</dt>");
    }

    public HtmlCanvas del() throws IOException {
        this.out.write("<del>");
        this.openTagStack.add("</del>");
        return this;
    }

    public HtmlCanvas del(CharactersWriteable attrs) throws IOException {
        this.out.write("<del");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</del>");
        return this;
    }

    public HtmlCanvas _del() throws IOException {
        return this.close("</del>");
    }

    public HtmlCanvas ins() throws IOException {
        this.out.write("<ins>");
        this.openTagStack.add("</ins>");
        return this;
    }

    public HtmlCanvas ins(CharactersWriteable attrs) throws IOException {
        this.out.write("<ins");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</ins>");
        return this;
    }

    public HtmlCanvas _ins() throws IOException {
        return this.close("</ins>");
    }

    @Deprecated
    public HtmlCanvas dir() throws IOException {
        this.out.write("<dir>");
        this.openTagStack.add("</dir>");
        return this;
    }

    @Deprecated
    public HtmlCanvas dir(CharactersWriteable attrs) throws IOException {
        this.out.write("<dir");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</dir>");
        return this;
    }

    public HtmlCanvas _dir() throws IOException {
        return this.close("</dir>");
    }

    @Deprecated
    public HtmlCanvas menu() throws IOException {
        this.out.write("<menu>");
        this.openTagStack.add("</menu>");
        return this;
    }

    @Deprecated
    public HtmlCanvas menu(CharactersWriteable attrs) throws IOException {
        this.out.write("<menu");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</menu>");
        return this;
    }

    public HtmlCanvas _menu() throws IOException {
        return this.close("</menu>");
    }

    public HtmlCanvas div() throws IOException {
        this.out.write("<div>");
        this.openTagStack.add("</div>");
        return this;
    }

    public HtmlCanvas div(CharactersWriteable attrs) throws IOException {
        this.out.write("<div");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</div>");
        return this;
    }

    public HtmlCanvas _div() throws IOException {
        return this.close("</div>");
    }

    public HtmlCanvas span() throws IOException {
        this.out.write("<span>");
        this.openTagStack.add("</span>");
        return this;
    }

    public HtmlCanvas span(CharactersWriteable attrs) throws IOException {
        this.out.write("<span");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</span>");
        return this;
    }

    public HtmlCanvas _span() throws IOException {
        return this.close("</span>");
    }

    public HtmlCanvas fieldset() throws IOException {
        this.out.write("<fieldset>");
        this.openTagStack.add("</fieldset>");
        return this;
    }

    public HtmlCanvas fieldset(CharactersWriteable attrs) throws IOException {
        this.out.write("<fieldset");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</fieldset>");
        return this;
    }

    public HtmlCanvas _fieldset() throws IOException {
        return this.close("</fieldset>");
    }

    public HtmlCanvas form() throws IOException {
        this.out.write("<form>");
        this.openTagStack.add("</form>");
        return this;
    }

    public HtmlCanvas form(CharactersWriteable attrs) throws IOException {
        this.out.write("<form");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</form>");
        return this;
    }

    public HtmlCanvas _form() throws IOException {
        return this.close("</form>");
    }

    public HtmlCanvas frame(CharactersWriteable attrs) throws IOException {
        this.out.write("<frame");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(47);
        this.out.write(62);
        return this;
    }

    public HtmlCanvas frameset() throws IOException {
        this.out.write("<frameset>");
        this.openTagStack.add("</frameset>");
        return this;
    }

    public HtmlCanvas frameset(CharactersWriteable attrs) throws IOException {
        this.out.write("<frameset");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</frameset>");
        return this;
    }

    public HtmlCanvas _frameset() throws IOException {
        return this.close("</frameset>");
    }

    public HtmlCanvas h1() throws IOException {
        this.out.write("<h1>");
        this.openTagStack.add("</h1>");
        return this;
    }

    public HtmlCanvas h1(CharactersWriteable attrs) throws IOException {
        this.out.write("<h1");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</h1>");
        return this;
    }

    public HtmlCanvas _h1() throws IOException {
        return this.close("</h1>");
    }

    public HtmlCanvas h2() throws IOException {
        this.out.write("<h2>");
        this.openTagStack.add("</h2>");
        return this;
    }

    public HtmlCanvas h2(CharactersWriteable attrs) throws IOException {
        this.out.write("<h2");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</h2>");
        return this;
    }

    public HtmlCanvas _h2() throws IOException {
        return this.close("</h2>");
    }

    public HtmlCanvas h3() throws IOException {
        this.out.write("<h3>");
        this.openTagStack.add("</h3>");
        return this;
    }

    public HtmlCanvas h3(CharactersWriteable attrs) throws IOException {
        this.out.write("<h3");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</h3>");
        return this;
    }

    public HtmlCanvas _h3() throws IOException {
        return this.close("</h3>");
    }

    public HtmlCanvas h4() throws IOException {
        this.out.write("<h4>");
        this.openTagStack.add("</h4>");
        return this;
    }

    public HtmlCanvas h4(CharactersWriteable attrs) throws IOException {
        this.out.write("<h4");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</h4>");
        return this;
    }

    public HtmlCanvas _h4() throws IOException {
        return this.close("</h4>");
    }

    public HtmlCanvas h5() throws IOException {
        this.out.write("<h5>");
        this.openTagStack.add("</h5>");
        return this;
    }

    public HtmlCanvas h5(CharactersWriteable attrs) throws IOException {
        this.out.write("<h5");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</h5>");
        return this;
    }

    public HtmlCanvas _h5() throws IOException {
        return this.close("</h5>");
    }

    public HtmlCanvas h6() throws IOException {
        this.out.write("<h6>");
        this.openTagStack.add("</h6>");
        return this;
    }

    public HtmlCanvas h6(CharactersWriteable attrs) throws IOException {
        this.out.write("<h6");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</h6>");
        return this;
    }

    public HtmlCanvas _h6() throws IOException {
        return this.close("</h6>");
    }

    public HtmlCanvas head() throws IOException {
        this.out.write("<head>");
        this.openTagStack.add("</head>");
        return this;
    }

    public HtmlCanvas head(CharactersWriteable attrs) throws IOException {
        this.out.write("<head");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</head>");
        return this;
    }

    public HtmlCanvas _head() throws IOException {
        return this.close("</head>");
    }

    public HtmlCanvas hr() throws IOException {
        this.out.write("<hr/>");
        return this;
    }

    public HtmlCanvas hr(CharactersWriteable attrs) throws IOException {
        this.out.write("<hr");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write("/>");
        return this;
    }

    public HtmlCanvas html() throws IOException {
        this.out.write("<html>");
        this.openTagStack.add("</html>");
        return this;
    }

    public HtmlCanvas html(CharactersWriteable attrs) throws IOException {
        this.out.write("<html");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</html>");
        return this;
    }

    public HtmlCanvas _html() throws IOException {
        return this.close("</html>");
    }

    public HtmlCanvas iframe() throws IOException {
        this.out.write("<iframe>");
        this.openTagStack.add("</iframe>");
        return this;
    }

    public HtmlCanvas iframe(CharactersWriteable attrs) throws IOException {
        this.out.write("<iframe");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</iframe>");
        return this;
    }

    public HtmlCanvas _iframe() throws IOException {
        return this.close("</iframe>");
    }

    public HtmlCanvas img(CharactersWriteable attrs) throws IOException {
        this.out.write("<img");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(47);
        this.out.write(62);
        return this;
    }

    public HtmlCanvas input() throws IOException {
        this.out.write("<input/>");
        return this;
    }

    public HtmlCanvas input(CharactersWriteable attrs) throws IOException {
        this.out.write("<input");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write("/>");
        return this;
    }

    @Deprecated
    public HtmlCanvas isindex() throws IOException {
        this.out.write("<isindex>");
        this.openTagStack.add("</isindex>");
        return this;
    }

    @Deprecated
    public HtmlCanvas isindex(CharactersWriteable attrs) throws IOException {
        this.out.write("<isindex");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</isindex>");
        return this;
    }

    public HtmlCanvas label() throws IOException {
        this.out.write("<label>");
        this.openTagStack.add("</label>");
        return this;
    }

    public HtmlCanvas label(CharactersWriteable attrs) throws IOException {
        this.out.write("<label");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</label>");
        return this;
    }

    public HtmlCanvas _label() throws IOException {
        return this.close("</label>");
    }

    public HtmlCanvas legend() throws IOException {
        this.out.write("<legend>");
        this.openTagStack.add("</legend>");
        return this;
    }

    public HtmlCanvas legend(CharactersWriteable attrs) throws IOException {
        this.out.write("<legend");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</legend>");
        return this;
    }

    public HtmlCanvas _legend() throws IOException {
        return this.close("</legend>");
    }

    public HtmlCanvas li() throws IOException {
        this.out.write("<li>");
        this.openTagStack.add("</li>");
        return this;
    }

    public HtmlCanvas li(CharactersWriteable attrs) throws IOException {
        this.out.write("<li");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</li>");
        return this;
    }

    public HtmlCanvas _li() throws IOException {
        return this.close("</li>");
    }

    public HtmlCanvas ol() throws IOException {
        this.out.write("<ol>");
        this.openTagStack.add("</ol>");
        return this;
    }

    public HtmlCanvas ol(CharactersWriteable attrs) throws IOException {
        this.out.write("<ol");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</ol>");
        return this;
    }

    public HtmlCanvas _ol() throws IOException {
        return this.close("</ol>");
    }

    public HtmlCanvas ul() throws IOException {
        this.out.write("<ul>");
        this.openTagStack.add("</ul>");
        return this;
    }

    public HtmlCanvas ul(CharactersWriteable attrs) throws IOException {
        this.out.write("<ul");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</ul>");
        return this;
    }

    public HtmlCanvas _ul() throws IOException {
        return this.close("</ul>");
    }

    public HtmlCanvas link(CharactersWriteable attrs) throws IOException {
        this.out.write("<link");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(47);
        this.out.write(62);
        return this;
    }

    public HtmlCanvas meta(CharactersWriteable attrs) throws IOException {
        this.out.write("<meta");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(47);
        this.out.write(62);
        return this;
    }

    public HtmlCanvas noframes() throws IOException {
        this.out.write("<noframes>");
        this.openTagStack.add("</noframes>");
        return this;
    }

    public HtmlCanvas noframes(CharactersWriteable attrs) throws IOException {
        this.out.write("<noframes");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</noframes>");
        return this;
    }

    public HtmlCanvas _noframes() throws IOException {
        return this.close("</noframes>");
    }

    public HtmlCanvas noscript() throws IOException {
        this.out.write("<noscript>");
        this.openTagStack.add("</noscript>");
        return this;
    }

    public HtmlCanvas noscript(CharactersWriteable attrs) throws IOException {
        this.out.write("<noscript");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</noscript>");
        return this;
    }

    public HtmlCanvas _noscript() throws IOException {
        return this.close("</noscript>");
    }

    public HtmlCanvas object() throws IOException {
        this.out.write("<object>");
        this.openTagStack.add("</object>");
        return this;
    }

    public HtmlCanvas object(CharactersWriteable attrs) throws IOException {
        this.out.write("<object");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</object>");
        return this;
    }

    public HtmlCanvas _object() throws IOException {
        return this.close("</object>");
    }

    public HtmlCanvas optgroup() throws IOException {
        this.out.write("<optgroup>");
        this.openTagStack.add("</optgroup>");
        return this;
    }

    public HtmlCanvas optgroup(CharactersWriteable attrs) throws IOException {
        this.out.write("<optgroup");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</optgroup>");
        return this;
    }

    public HtmlCanvas _optgroup() throws IOException {
        return this.close("</optgroup>");
    }

    public HtmlCanvas option() throws IOException {
        this.out.write("<option>");
        this.openTagStack.add("</option>");
        return this;
    }

    public HtmlCanvas option(CharactersWriteable attrs) throws IOException {
        this.out.write("<option");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</option>");
        return this;
    }

    public HtmlCanvas _option() throws IOException {
        return this.close("</option>");
    }

    public HtmlCanvas select() throws IOException {
        this.out.write("<select>");
        this.openTagStack.add("</select>");
        return this;
    }

    public HtmlCanvas select(CharactersWriteable attrs) throws IOException {
        this.out.write("<select");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</select>");
        return this;
    }

    public HtmlCanvas _select() throws IOException {
        return this.close("</select>");
    }

    public HtmlCanvas p() throws IOException {
        this.out.write("<p>");
        this.openTagStack.add("</p>");
        return this;
    }

    public HtmlCanvas p(CharactersWriteable attrs) throws IOException {
        this.out.write("<p");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</p>");
        return this;
    }

    public HtmlCanvas _p() throws IOException {
        return this.close("</p>");
    }

    public HtmlCanvas param(CharactersWriteable attrs) throws IOException {
        this.out.write("<param");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(47);
        this.out.write(62);
        return this;
    }

    public HtmlCanvas pre() throws IOException {
        this.out.write("<pre>");
        this.openTagStack.add("</pre>");
        return this;
    }

    public HtmlCanvas pre(CharactersWriteable attrs) throws IOException {
        this.out.write("<pre");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</pre>");
        return this;
    }

    public HtmlCanvas _pre() throws IOException {
        return this.close("</pre>");
    }

    public HtmlCanvas blockquote() throws IOException {
        this.out.write("<blockquote>");
        this.openTagStack.add("</blockquote>");
        return this;
    }

    public HtmlCanvas blockquote(CharactersWriteable attrs) throws IOException {
        this.out.write("<blockquote");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</blockquote>");
        return this;
    }

    public HtmlCanvas _blockquote() throws IOException {
        return this.close("</blockquote>");
    }

    public HtmlCanvas q() throws IOException {
        this.out.write("<q>");
        this.openTagStack.add("</q>");
        return this;
    }

    public HtmlCanvas q(CharactersWriteable attrs) throws IOException {
        this.out.write("<q");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</q>");
        return this;
    }

    public HtmlCanvas _q() throws IOException {
        return this.close("</q>");
    }

    public HtmlCanvas script() throws IOException {
        this.out.write("<script>");
        this.openTagStack.add("</script>");
        return this;
    }

    public HtmlCanvas script(CharactersWriteable attrs) throws IOException {
        this.out.write("<script");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</script>");
        return this;
    }

    public HtmlCanvas _script() throws IOException {
        return this.close("</script>");
    }

    public HtmlCanvas style() throws IOException {
        this.out.write("<style>");
        this.openTagStack.add("</style>");
        return this;
    }

    public HtmlCanvas style(CharactersWriteable attrs) throws IOException {
        this.out.write("<style");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</style>");
        return this;
    }

    public HtmlCanvas _style() throws IOException {
        return this.close("</style>");
    }

    public HtmlCanvas sub() throws IOException {
        this.out.write("<sub>");
        this.openTagStack.add("</sub>");
        return this;
    }

    public HtmlCanvas sub(CharactersWriteable attrs) throws IOException {
        this.out.write("<sub");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</sub>");
        return this;
    }

    public HtmlCanvas _sub() throws IOException {
        return this.close("</sub>");
    }

    public HtmlCanvas sup() throws IOException {
        this.out.write("<sup>");
        this.openTagStack.add("</sup>");
        return this;
    }

    public HtmlCanvas sup(CharactersWriteable attrs) throws IOException {
        this.out.write("<sup");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</sup>");
        return this;
    }

    public HtmlCanvas _sup() throws IOException {
        return this.close("</sup>");
    }

    public HtmlCanvas textarea() throws IOException {
        this.out.write("<textarea>");
        this.openTagStack.add("</textarea>");
        return this;
    }

    public HtmlCanvas textarea(CharactersWriteable attrs) throws IOException {
        this.out.write("<textarea");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</textarea>");
        return this;
    }

    public HtmlCanvas _textarea() throws IOException {
        return this.close("</textarea>");
    }

    public HtmlCanvas title() throws IOException {
        this.out.write("<title>");
        this.openTagStack.add("</title>");
        return this;
    }

    public HtmlCanvas title(CharactersWriteable attrs) throws IOException {
        this.out.write("<title");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</title>");
        return this;
    }

    public HtmlCanvas _title() throws IOException {
        return this.close("</title>");
    }

    public HtmlCanvas table() throws IOException {
        this.out.write("<table>");
        this.openTagStack.add("</table>");
        return this;
    }

    public HtmlCanvas table(CharactersWriteable attrs) throws IOException {
        this.out.write("<table");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</table>");
        return this;
    }

    public HtmlCanvas _table() throws IOException {
        return this.close("</table>");
    }

    public HtmlCanvas tbody() throws IOException {
        this.out.write("<tbody>");
        this.openTagStack.add("</tbody>");
        return this;
    }

    public HtmlCanvas tbody(CharactersWriteable attrs) throws IOException {
        this.out.write("<tbody");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</tbody>");
        return this;
    }

    public HtmlCanvas _tbody() throws IOException {
        return this.close("</tbody>");
    }

    public HtmlCanvas tfoot() throws IOException {
        this.out.write("<tfoot>");
        this.openTagStack.add("</tfoot>");
        return this;
    }

    public HtmlCanvas tfoot(CharactersWriteable attrs) throws IOException {
        this.out.write("<tfoot");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</tfoot>");
        return this;
    }

    public HtmlCanvas _tfoot() throws IOException {
        return this.close("</tfoot>");
    }

    public HtmlCanvas thead() throws IOException {
        this.out.write("<thead>");
        this.openTagStack.add("</thead>");
        return this;
    }

    public HtmlCanvas thead(CharactersWriteable attrs) throws IOException {
        this.out.write("<thead");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</thead>");
        return this;
    }

    public HtmlCanvas _thead() throws IOException {
        return this.close("</thead>");
    }

    public HtmlCanvas td() throws IOException {
        this.out.write("<td>");
        this.openTagStack.add("</td>");
        return this;
    }

    public HtmlCanvas td(CharactersWriteable attrs) throws IOException {
        this.out.write("<td");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</td>");
        return this;
    }

    public HtmlCanvas _td() throws IOException {
        return this.close("</td>");
    }

    public HtmlCanvas th() throws IOException {
        this.out.write("<th>");
        this.openTagStack.add("</th>");
        return this;
    }

    public HtmlCanvas th(CharactersWriteable attrs) throws IOException {
        this.out.write("<th");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</th>");
        return this;
    }

    public HtmlCanvas _th() throws IOException {
        return this.close("</th>");
    }

    public HtmlCanvas tr() throws IOException {
        this.out.write("<tr>");
        this.openTagStack.add("</tr>");
        return this;
    }

    public HtmlCanvas tr(CharactersWriteable attrs) throws IOException {
        this.out.write("<tr");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</tr>");
        return this;
    }

    public HtmlCanvas _tr() throws IOException {
        return this.close("</tr>");
    }

    public HtmlCanvas article() throws IOException {
        this.out.write("<article>");
        this.openTagStack.add("</article>");
        return this;
    }

    public HtmlCanvas article(CharactersWriteable attrs) throws IOException {
        this.out.write("<article");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</article>");
        return this;
    }

    public HtmlCanvas _article() throws IOException {
        return this.close("</article>");
    }

    public HtmlCanvas aside() throws IOException {
        this.out.write("<aside>");
        this.openTagStack.add("</aside>");
        return this;
    }

    public HtmlCanvas aside(CharactersWriteable attrs) throws IOException {
        this.out.write("<aside");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</aside>");
        return this;
    }

    public HtmlCanvas _aside() throws IOException {
        return this.close("</aside>");
    }

    public HtmlCanvas audio() throws IOException {
        this.out.write("<audio>");
        this.openTagStack.add("</audio>");
        return this;
    }

    public HtmlCanvas audio(CharactersWriteable attrs) throws IOException {
        this.out.write("<audio");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</audio>");
        return this;
    }

    public HtmlCanvas _audio() throws IOException {
        return this.close("</audio>");
    }

    public HtmlCanvas canvas() throws IOException {
        this.out.write("<canvas>");
        this.openTagStack.add("</canvas>");
        return this;
    }

    public HtmlCanvas canvas(CharactersWriteable attrs) throws IOException {
        this.out.write("<canvas");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</canvas>");
        return this;
    }

    public HtmlCanvas _canvas() throws IOException {
        return this.close("</canvas>");
    }

    public HtmlCanvas command() throws IOException {
        this.out.write("<command>");
        this.openTagStack.add("</command>");
        return this;
    }

    public HtmlCanvas command(CharactersWriteable attrs) throws IOException {
        this.out.write("<command");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</command>");
        return this;
    }

    public HtmlCanvas _command() throws IOException {
        return this.close("</command>");
    }

    public HtmlCanvas datalist() throws IOException {
        this.out.write("<datalist>");
        this.openTagStack.add("</datalist>");
        return this;
    }

    public HtmlCanvas datalist(CharactersWriteable attrs) throws IOException {
        this.out.write("<datalist");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</datalist>");
        return this;
    }

    public HtmlCanvas _datalist() throws IOException {
        return this.close("</datalist>");
    }

    public HtmlCanvas details() throws IOException {
        this.out.write("<details>");
        this.openTagStack.add("</details>");
        return this;
    }

    public HtmlCanvas details(CharactersWriteable attrs) throws IOException {
        this.out.write("<details");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</details>");
        return this;
    }

    public HtmlCanvas _details() throws IOException {
        return this.close("</details>");
    }

    public HtmlCanvas embed() throws IOException {
        this.out.write("<embed>");
        this.openTagStack.add("</embed>");
        return this;
    }

    public HtmlCanvas embed(CharactersWriteable attrs) throws IOException {
        this.out.write("<embed");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</embed>");
        return this;
    }

    public HtmlCanvas _embed() throws IOException {
        return this.close("</embed>");
    }

    public HtmlCanvas figcaption() throws IOException {
        this.out.write("<figcaption>");
        this.openTagStack.add("</figcaption>");
        return this;
    }

    public HtmlCanvas figcaption(CharactersWriteable attrs) throws IOException {
        this.out.write("<figcaption");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</figcaption>");
        return this;
    }

    public HtmlCanvas _figcaption() throws IOException {
        return this.close("</figcaption>");
    }

    public HtmlCanvas figure() throws IOException {
        this.out.write("<figure>");
        this.openTagStack.add("</figure>");
        return this;
    }

    public HtmlCanvas figure(CharactersWriteable attrs) throws IOException {
        this.out.write("<figure");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</figure>");
        return this;
    }

    public HtmlCanvas _figure() throws IOException {
        return this.close("</figure>");
    }

    public HtmlCanvas footer() throws IOException {
        this.out.write("<footer>");
        this.openTagStack.add("</footer>");
        return this;
    }

    public HtmlCanvas footer(CharactersWriteable attrs) throws IOException {
        this.out.write("<footer");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</footer>");
        return this;
    }

    public HtmlCanvas _footer() throws IOException {
        return this.close("</footer>");
    }

    public HtmlCanvas header() throws IOException {
        this.out.write("<header>");
        this.openTagStack.add("</header>");
        return this;
    }

    public HtmlCanvas header(CharactersWriteable attrs) throws IOException {
        this.out.write("<header");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</header>");
        return this;
    }

    public HtmlCanvas _header() throws IOException {
        return this.close("</header>");
    }

    public HtmlCanvas hgroup() throws IOException {
        this.out.write("<hgroup>");
        this.openTagStack.add("</hgroup>");
        return this;
    }

    public HtmlCanvas hgroup(CharactersWriteable attrs) throws IOException {
        this.out.write("<hgroup");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</hgroup>");
        return this;
    }

    public HtmlCanvas _hgroup() throws IOException {
        return this.close("</hgroup>");
    }

    public HtmlCanvas keygen() throws IOException {
        this.out.write("<keygen>");
        this.openTagStack.add("</keygen>");
        return this;
    }

    public HtmlCanvas keygen(CharactersWriteable attrs) throws IOException {
        this.out.write("<keygen");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</keygen>");
        return this;
    }

    public HtmlCanvas _keygen() throws IOException {
        return this.close("</keygen>");
    }

    public HtmlCanvas mark() throws IOException {
        this.out.write("<mark>");
        this.openTagStack.add("</mark>");
        return this;
    }

    public HtmlCanvas mark(CharactersWriteable attrs) throws IOException {
        this.out.write("<mark");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</mark>");
        return this;
    }

    public HtmlCanvas _mark() throws IOException {
        return this.close("</mark>");
    }

    public HtmlCanvas meter() throws IOException {
        this.out.write("<meter>");
        this.openTagStack.add("</meter>");
        return this;
    }

    public HtmlCanvas meter(CharactersWriteable attrs) throws IOException {
        this.out.write("<meter");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</meter>");
        return this;
    }

    public HtmlCanvas _meter() throws IOException {
        return this.close("</meter>");
    }

    public HtmlCanvas nav() throws IOException {
        this.out.write("<nav>");
        this.openTagStack.add("</nav>");
        return this;
    }

    public HtmlCanvas nav(CharactersWriteable attrs) throws IOException {
        this.out.write("<nav");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</nav>");
        return this;
    }

    public HtmlCanvas _nav() throws IOException {
        return this.close("</nav>");
    }

    public HtmlCanvas output() throws IOException {
        this.out.write("<output>");
        this.openTagStack.add("</output>");
        return this;
    }

    public HtmlCanvas output(CharactersWriteable attrs) throws IOException {
        this.out.write("<output");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</output>");
        return this;
    }

    public HtmlCanvas _output() throws IOException {
        return this.close("</output>");
    }

    public HtmlCanvas progress() throws IOException {
        this.out.write("<progress>");
        this.openTagStack.add("</progress>");
        return this;
    }

    public HtmlCanvas progress(CharactersWriteable attrs) throws IOException {
        this.out.write("<progress");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</progress>");
        return this;
    }

    public HtmlCanvas _progress() throws IOException {
        return this.close("</progress>");
    }

    public HtmlCanvas rp() throws IOException {
        this.out.write("<rp>");
        this.openTagStack.add("</rp>");
        return this;
    }

    public HtmlCanvas rp(CharactersWriteable attrs) throws IOException {
        this.out.write("<rp");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</rp>");
        return this;
    }

    public HtmlCanvas _rp() throws IOException {
        return this.close("</rp>");
    }

    public HtmlCanvas rt() throws IOException {
        this.out.write("<rt>");
        this.openTagStack.add("</rt>");
        return this;
    }

    public HtmlCanvas rt(CharactersWriteable attrs) throws IOException {
        this.out.write("<rt");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</rt>");
        return this;
    }

    public HtmlCanvas _rt() throws IOException {
        return this.close("</rt>");
    }

    public HtmlCanvas ruby() throws IOException {
        this.out.write("<ruby>");
        this.openTagStack.add("</ruby>");
        return this;
    }

    public HtmlCanvas ruby(CharactersWriteable attrs) throws IOException {
        this.out.write("<ruby");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</ruby>");
        return this;
    }

    public HtmlCanvas _ruby() throws IOException {
        return this.close("</ruby>");
    }

    public HtmlCanvas section() throws IOException {
        this.out.write("<section>");
        this.openTagStack.add("</section>");
        return this;
    }

    public HtmlCanvas section(CharactersWriteable attrs) throws IOException {
        this.out.write("<section");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</section>");
        return this;
    }

    public HtmlCanvas _section() throws IOException {
        return this.close("</section>");
    }

    public HtmlCanvas source() throws IOException {
        this.out.write("<source>");
        this.openTagStack.add("</source>");
        return this;
    }

    public HtmlCanvas source(CharactersWriteable attrs) throws IOException {
        this.out.write("<source");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</source>");
        return this;
    }

    public HtmlCanvas _source() throws IOException {
        return this.close("</source>");
    }

    public HtmlCanvas summary() throws IOException {
        this.out.write("<summary>");
        this.openTagStack.add("</summary>");
        return this;
    }

    public HtmlCanvas summary(CharactersWriteable attrs) throws IOException {
        this.out.write("<summary");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</summary>");
        return this;
    }

    public HtmlCanvas _summary() throws IOException {
        return this.close("</summary>");
    }

    public HtmlCanvas time() throws IOException {
        this.out.write("<time>");
        this.openTagStack.add("</time>");
        return this;
    }

    public HtmlCanvas time(CharactersWriteable attrs) throws IOException {
        this.out.write("<time");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</time>");
        return this;
    }

    public HtmlCanvas _time() throws IOException {
        return this.close("</time>");
    }

    public HtmlCanvas video() throws IOException {
        this.out.write("<video>");
        this.openTagStack.add("</video>");
        return this;
    }

    public HtmlCanvas video(CharactersWriteable attrs) throws IOException {
        this.out.write("<video");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</video>");
        return this;
    }

    public HtmlCanvas _video() throws IOException {
        return this.close("</video>");
    }

    public HtmlCanvas wbr() throws IOException {
        this.out.write("<wbr>");
        this.openTagStack.add("</wbr>");
        return this;
    }

    public HtmlCanvas wbr(CharactersWriteable attrs) throws IOException {
        this.out.write("<wbr");
        if (attrs != null) {
            attrs.writeCharsOn(this.out);
        }
        this.out.write(62);
        this.openTagStack.add("</wbr>");
        return this;
    }

    public HtmlCanvas _wbr() throws IOException {
        return this.close("</wbr>");
    }

    public HtmlCanvas write(Integer i) throws IOException {
        if (null == i) {
            return this;
        }
        this.out.append(Integer.toString(i));
        return this;
    }

    public HtmlCanvas content(Integer i) throws IOException {
        if (null == i) {
            return this.close();
        }
        this.out.append(Integer.toString(i));
        return this.close();
    }

    static {
        StringEscapeUtils.init();
        INITIAL_STACK_CAPACITY = 32;
    }
}

