/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.Renderable;

public class StringResource
implements Renderable {
    private static final Map<String, String> CACHE = new ConcurrentHashMap<String, String>();
    public static final boolean DO_NOT_CACHE = false;
    private String content;
    private boolean escapeNeeded = false;

    public StringResource(String location) {
        this.content = StringResource.get(location);
    }

    public StringResource(String location, boolean escapeNeeded) {
        this.content = StringResource.get(location);
        this.escapeNeeded = escapeNeeded;
    }

    public static String get(String location) {
        return StringResource.get(location, true);
    }

    public static void flush(String location) {
        CACHE.remove(location);
    }

    public static void flush() {
        CACHE.clear();
    }

    public static String get(String location, boolean doCache) {
        String content = null;
        if (doCache) {
            content = CACHE.get(location);
        }
        if (content == null) {
            content = StringResource.contentOrNull(location);
            if (content == null) {
                content = "[StringResource] Missing or error reading resource:" + location;
            } else if (doCache) {
                CACHE.put(location, content);
            }
        }
        return content;
    }

    public static StringResource valueOf(String location) {
        return new StringResource(location);
    }

    private static String contentOrNull(String location) {
        if (location.startsWith("http://")) {
            return StringResource.fetchContentOrNull(location);
        }
        String content = null;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (is == null) {
            is = StringResource.class.getResourceAsStream(location);
        }
        if (is != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                StringBuilder builder = new StringBuilder(256);
                while (reader.ready()) {
                    builder.append(reader.readLine()).append('\n');
                }
                content = builder.toString();
            }
            catch (IOException e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Unable to fetch content from:" + location);
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fetchContentOrNull(String urlToRead) {
        BufferedReader rd = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL url = new URL(urlToRead);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Unable to fetch content from:" + urlToRead);
            String string = null;
            return string;
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (Exception ex) {}
            }
        }
        return result.toString();
    }

    public void renderOn(HtmlCanvas html) throws IOException {
        html.write(this.content, this.escapeNeeded);
    }
}

