/*
 * Decompiled with CFR 0.152.
 */
package org.rendersnake.ext.jquery;

import java.io.IOException;
import org.rendersnake.HtmlCanvas;
import org.rendersnake.Renderable;

public class JQueryLibrary
implements Renderable {
    public static String BASE_RESOURCE_URL = "http://code.jquery.com";
    private String url;

    public JQueryLibrary(String url) {
        this.url = url;
    }

    public static JQueryLibrary core(String version) {
        return new JQueryLibrary(BASE_RESOURCE_URL + "/jquery-" + version + ".min.js");
    }

    public static JQueryLibrary ui(String version) {
        return new JQueryLibrary(BASE_RESOURCE_URL + "/ui/" + version + "/jquery-ui.min.js");
    }

    public static JQueryLibrary baseTheme(String version) {
        return JQueryLibrary.theme(version, "base");
    }

    public static JQueryLibrary theme(String version, String theme) {
        return new JQueryLibrary(BASE_RESOURCE_URL + "/ui/" + version + "/themes/" + theme + "/jquery-ui.css");
    }

    public static JQueryLibrary mobileTheme(String version) {
        return new JQueryLibrary(BASE_RESOURCE_URL + "/mobile/" + version + "/jquery.mobile-" + version + ".min.css");
    }

    public static JQueryLibrary mobileStructure(String version) {
        return new JQueryLibrary(BASE_RESOURCE_URL + "/mobile/" + version + "/jquery.mobile.structure-" + version + ".min.css");
    }

    public static JQueryLibrary mobile(String version) {
        return new JQueryLibrary(BASE_RESOURCE_URL + "/mobile/" + version + "/jquery.mobile-" + version + ".min.js");
    }

    public void renderOn(HtmlCanvas html) throws IOException {
        if (this.url.endsWith(".js")) {
            html.script(html.attributes().type("text/javascript").src(this.url))._script();
            return;
        }
        if (this.url.endsWith(".css")) {
            html.link(html.attributes().type("text/css").href(this.url).rel("stylesheet"));
            return;
        }
        throw new IllegalStateException("Unknown resource type:" + this.url);
    }
}

