/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.ArrayList;
import java.util.List;
import org.skife.jdbi.org.antlr.runtime.ANTLRStringStream;
import org.skife.jdbi.org.antlr.runtime.Token;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.SqlScriptParser;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.tweak.StatementLocator;

public class Script {
    private final Handle handle;
    private final StatementLocator locator;
    private final String name;
    private final StatementContext statementContext;

    Script(Handle h2, StatementLocator locator, String name, StatementContext statementContext) {
        this.handle = h2;
        this.locator = locator;
        this.name = name;
        this.statementContext = statementContext;
    }

    public int[] execute() {
        List<String> statements = this.getStatements();
        Batch b = this.handle.createBatch();
        for (String s2 : statements) {
            b.add(s2);
        }
        return b.execute();
    }

    public void executeAsSeparateStatements() {
        for (String s2 : this.getStatements()) {
            this.handle.execute(s2, new Object[0]);
        }
    }

    public List<String> getStatements() {
        String script;
        try {
            script = this.locator.locate(this.name, this.statementContext);
        }
        catch (Exception e) {
            throw new UnableToExecuteStatementException(String.format("Error while loading script [%s]", this.name), e, this.statementContext);
        }
        return this.splitToStatements(script);
    }

    private List<String> splitToStatements(String script) {
        final ArrayList<String> statements = new ArrayList<String>();
        String lastStatement = new SqlScriptParser(new SqlScriptParser.TokenHandler(){

            @Override
            public void handle(Token t, StringBuilder sb) {
                Script.this.addStatement(sb.toString(), statements);
                sb.setLength(0);
            }
        }).parse(new ANTLRStringStream(script));
        this.addStatement(lastStatement, statements);
        return statements;
    }

    private void addStatement(String statement, List<String> statements) {
        String trimmedStatement = statement.trim();
        if (trimmedStatement.isEmpty()) {
            return;
        }
        statements.add(trimmedStatement);
    }
}

