/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.spring;

import java.util.HashSet;
import java.util.Set;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DBIUtil {
    private static final Set<Handle> TRANSACTIONAL_HANDLES = new HashSet<Handle>();

    public static Handle getHandle(IDBI dbi) {
        Handle bound = (Handle)TransactionSynchronizationManager.getResource((Object)dbi);
        if (bound == null) {
            bound = dbi.open();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationManager.bindResource((Object)dbi, (Object)bound);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new Adapter(dbi, bound));
                TRANSACTIONAL_HANDLES.add(bound);
            }
        }
        return bound;
    }

    public static void closeIfNeeded(Handle h2) {
        if (!TRANSACTIONAL_HANDLES.contains(h2)) {
            h2.close();
        }
    }

    private static class Adapter
    extends TransactionSynchronizationAdapter {
        private final IDBI dbi;
        private final Handle handle;

        Adapter(IDBI dbi, Handle handle) {
            this.dbi = dbi;
            this.handle = handle;
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.dbi, (Object)this.handle);
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)this.dbi);
        }

        public void beforeCompletion() {
            TRANSACTIONAL_HANDLES.remove(this.handle);
            TransactionSynchronizationManager.unbindResource((Object)this.dbi);
        }
    }
}

