/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.lang.reflect.Method;
import org.skife.jdbi.cglib.proxy.MethodProxy;
import org.skife.jdbi.com.fasterxml.classmate.members.ResolvedMethod;
import org.skife.jdbi.v2.Call;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.OutParameters;
import org.skife.jdbi.v2.sqlobject.CustomizingStatementHandler;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.SqlCall;
import org.skife.jdbi.v2.sqlobject.SqlObject;

class CallHandler
extends CustomizingStatementHandler {
    private final String sql;
    private final boolean returnOutParams;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CallHandler(Class<?> sqlObjectType, ResolvedMethod method) {
        super(sqlObjectType, method);
        if (null != method.getReturnType()) {
            if (!method.getReturnType().isInstanceOf(OutParameters.class)) throw new IllegalArgumentException("@SqlCall methods may only return null or OutParameters at present");
            this.returnOutParams = true;
        } else {
            this.returnOutParams = false;
        }
        this.sql = SqlObject.getSql(((Method)method.getRawMember()).getAnnotation(SqlCall.class), (Method)method.getRawMember());
    }

    @Override
    public Object invoke(HandleDing ding, Object target, Object[] args, MethodProxy mp) {
        Handle h2 = ding.getHandle();
        Call call = h2.createCall(this.sql);
        this.applyCustomizers(call, args);
        this.applyBinders(call, args);
        OutParameters ou = call.invoke();
        if (this.returnOutParams) {
            return ou;
        }
        return null;
    }
}

