/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.lang.reflect.Method;
import org.skife.jdbi.cglib.proxy.MethodProxy;
import org.skife.jdbi.com.fasterxml.classmate.members.ResolvedMethod;
import org.skife.jdbi.v2.GeneratedKeys;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.UnableToCreateSqlObjectException;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.sqlobject.CustomizingStatementHandler;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.ResultReturnThing;
import org.skife.jdbi.v2.sqlobject.SqlObject;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

class UpdateHandler
extends CustomizingStatementHandler {
    private final String sql;
    private final Returner returner;

    UpdateHandler(Class<?> sqlObjectType, ResolvedMethod method) {
        super(sqlObjectType, method);
        boolean isGetGeneratedKeys = ((Method)method.getRawMember()).isAnnotationPresent(GetGeneratedKeys.class);
        if (!isGetGeneratedKeys && this.returnTypeIsInvalid(((Method)method.getRawMember()).getReturnType())) {
            throw new UnableToCreateSqlObjectException(this.invalidReturnTypeMessage(method));
        }
        this.sql = SqlObject.getSql(((Method)method.getRawMember()).getAnnotation(SqlUpdate.class), (Method)method.getRawMember());
        if (isGetGeneratedKeys) {
            ResultSetMapper mapper;
            final ResultReturnThing magic = ResultReturnThing.forType(method);
            final GetGeneratedKeys ggk = ((Method)method.getRawMember()).getAnnotation(GetGeneratedKeys.class);
            try {
                mapper = ggk.value().newInstance();
            }
            catch (Exception e) {
                throw new UnableToCreateStatementException("Unable to instantiate result set mapper for statement", e);
            }
            this.returner = new Returner(){

                @Override
                public Object value(Update update2, HandleDing baton) {
                    GeneratedKeys o = update2.executeAndReturnGeneratedKeys(mapper, ggk.columnName());
                    return magic.result(o, baton);
                }
            };
        } else {
            this.returner = new Returner(){

                @Override
                public Object value(Update update2, HandleDing baton) {
                    return update2.execute();
                }
            };
        }
    }

    @Override
    public Object invoke(HandleDing h2, Object target, Object[] args, MethodProxy mp) {
        Update q = h2.getHandle().createStatement(this.sql);
        this.applyCustomizers(q, args);
        this.applyBinders(q, args);
        return this.returner.value(q, h2);
    }

    private boolean returnTypeIsInvalid(Class<?> type) {
        return !Number.class.isAssignableFrom(type) && !type.equals(Integer.TYPE) && !type.equals(Long.TYPE) && !type.equals(Void.TYPE);
    }

    private String invalidReturnTypeMessage(ResolvedMethod method) {
        return method.getDeclaringType() + "." + method + " method is annotated with @SqlUpdate so should return void or Number but is returning: " + method.getReturnType();
    }

    private static interface Returner {
        public Object value(Update var1, HandleDing var2);
    }
}

