/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.tweak.StatementLocator;

@Retention(value=RetentionPolicy.RUNTIME)
@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface OverrideStatementLocatorWith {
    public Class<? extends StatementLocator> value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            StatementLocator f;
            OverrideStatementLocatorWith sl = (OverrideStatementLocatorWith)annotation;
            try {
                f = this.instantiate(sl.value(), sqlObjectType, method);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to instantiate a statement locator", e);
            }
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement q) {
                    q.setStatementLocator(f);
                }
            };
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            StatementLocator f;
            OverrideStatementLocatorWith sl = (OverrideStatementLocatorWith)annotation;
            try {
                f = this.instantiate(sl.value(), sqlObjectType, null);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to instantiate a statement locator", e);
            }
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement q) {
                    q.setStatementLocator(f);
                }
            };
        }

        private StatementLocator instantiate(Class<? extends StatementLocator> value, Class sqlObjectType, Method m3) throws Exception {
            try {
                Constructor<? extends StatementLocator> no_arg = value.getConstructor(new Class[0]);
                return no_arg.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor<? extends StatementLocator> class_arg = value.getConstructor(Class.class);
                    return class_arg.newInstance(sqlObjectType);
                }
                catch (NoSuchMethodException e1) {
                    if (m3 != null) {
                        Constructor<? extends StatementLocator> c_m_arg = value.getConstructor(Class.class, Method.class);
                        return c_m_arg.newInstance(sqlObjectType, m3);
                    }
                    throw new IllegalStateException("Unable to instantiate, no viable constructor " + value.getName());
                }
            }
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            throw new UnsupportedOperationException("Not applicable to parameter");
        }
    }
}

