/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public enum LongColumnMapper implements ResultColumnMapper<Long>
{
    PRIMITIVE(false),
    WRAPPER(true);

    private final boolean nullable;

    private LongColumnMapper(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public Long mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        long value = r.getLong(columnNumber);
        return this.nullable && r.wasNull() ? null : Long.valueOf(value);
    }

    @Override
    public Long mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        long value = r.getLong(columnLabel);
        return this.nullable && r.wasNull() ? null : Long.valueOf(value);
    }
}

