/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.fedmon.app;

import be.iminds.ilabt.fedmon.app.CombinedWebApiConfiguration;
import be.iminds.ilabt.jfed.bugreport.service.JFedBugReportWebApiApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.util.sentry.SentryUtil;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.migrations.MigrationsBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import org.skife.jdbi.v2.DBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedWebApiApplication
extends FedmonWebApiServiceApplication<CombinedWebApiConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedWebApiApplication.class);

    public static void main(String[] args) throws Exception {
        new CombinedWebApiApplication().run(args);
    }

    @Override
    public String getName() {
        return "fedmon-webapi";
    }

    @Override
    public void initialize(Bootstrap<CombinedWebApiConfiguration> bootstrap) {
        SentryUtil.initSentry();
        bootstrap.addBundle(new MigrationsBundle<CombinedWebApiConfiguration>(){

            public DataSourceFactory getDataSourceFactory(CombinedWebApiConfiguration configuration) {
                return configuration.getDataSourceFactory();
            }

            @Override
            public String getMigrationsFileName() {
                return "all-migrations.xml";
            }
        });
    }

    @Override
    public void initializeDaosAndResources(CombinedWebApiConfiguration configuration, Environment environment, DBI jdbi) {
        this.sharedResourceCache = FedmonWebApiServiceApplication.initializeDaosAndResourcesHelper(configuration, environment, jdbi, this.getEmailSender());
        JFedBugReportWebApiApplication.initializeDaosAndResourcesHelper(configuration, environment, jdbi, this.emailSender);
    }
}

