/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.jira;

import be.iminds.ilabt.jfed.bugreport.jira.JiraCallClient;
import be.iminds.ilabt.jfed.bugreport.jira.JiraClient;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthJiraCallClient
implements JiraCallClient {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthJiraCallClient.class);
    @Nonnull
    private final String jiraBaseUrl;
    @Nonnull
    private final String username;
    @Nonnull
    private final String password;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public BasicAuthJiraCallClient(@Nonnull String jiraBaseUrl, @Nonnull String username, @Nonnull String password) {
        this.jiraBaseUrl = jiraBaseUrl;
        this.username = username;
        this.password = password;
    }

    @Override
    @Nonnull
    public Map get(@Nonnull String path, @Nonnull Map<String, String> parameters) throws JiraClient.JiraException {
        try {
            int statusCode;
            String url = this.jiraBaseUrl + (this.jiraBaseUrl.endsWith("/") ? "" : "/") + path;
            URIBuilder uriBuilder = new URIBuilder(url);
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                uriBuilder.setParameter(e.getKey(), e.getValue());
            }
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
            provider.setCredentials(AuthScope.ANY, credentials);
            HttpHost httpHost = HttpHost.create(this.jiraBaseUrl);
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(httpHost, new BasicScheme());
            HttpClientContext context = HttpClientContext.create();
            context.setCredentialsProvider(provider);
            context.setAuthCache(authCache);
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider(provider).build();
            HttpGet httpUriRequest = new HttpGet(uriBuilder.build());
            httpUriRequest.addHeader("Accept", "*/*");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpUriRequest, context);
            HttpEntity entity = response.getEntity();
            int n = statusCode = response.getStatusLine() == null ? -1 : response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                String resultContent = entity != null ? IOUtils.streamToString(entity.getContent(), "UTF-8") : "";
                throw new JiraClient.JiraException("Error calling jira. Got status " + statusCode + " url=" + uriBuilder.build().toASCIIString() + " content=" + resultContent);
            }
            if (entity != null) {
                return MAPPER.readValue(entity.getContent(), Map.class);
            }
            throw new JiraClient.JiraException("no content returned");
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new JiraClient.JiraException("Internal bug: Problem constructing URL", e);
        }
        catch (IOException e) {
            throw new JiraClient.JiraException("Error querying jira", e);
        }
    }

    @Override
    @Nullable
    public Map post(@Nonnull String path, @Nullable String contentType, @Nullable String content) throws JiraClient.JiraException {
        LOG.debug("POST @ " + path + " content:\n" + content);
        try {
            int statusCode;
            String url = this.jiraBaseUrl + (this.jiraBaseUrl.endsWith("/") ? "" : "/") + path;
            URIBuilder uriBuilder = new URIBuilder(url);
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
            provider.setCredentials(AuthScope.ANY, credentials);
            HttpHost httpHost = HttpHost.create(this.jiraBaseUrl);
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(httpHost, new BasicScheme());
            HttpClientContext context = HttpClientContext.create();
            context.setCredentialsProvider(provider);
            context.setAuthCache(authCache);
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider(provider).build();
            HttpPost httpUriRequest = new HttpPost(uriBuilder.build());
            if (content != null && contentType != null) {
                StringEntity body = new StringEntity(content, ContentType.create(contentType, StandardCharsets.UTF_8.name()));
                httpUriRequest.setEntity(body);
            }
            httpUriRequest.addHeader("Accept", "*/*");
            httpUriRequest.addHeader("X-ExperimentalApi", "opt-in");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpUriRequest, context);
            HttpEntity entity = response.getEntity();
            int n = statusCode = response.getStatusLine() == null ? -1 : response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                String resultContent = entity != null ? IOUtils.streamToString(entity.getContent(), "UTF-8") : "";
                throw new JiraClient.JiraException("Error calling jira. Got status " + statusCode + " url=" + uriBuilder.build().toASCIIString() + " content=" + resultContent);
            }
            if (entity != null) {
                return MAPPER.readValue(entity.getContent(), Map.class);
            }
            return null;
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new JiraClient.JiraException("Internal bug: Problem constructing URL", e);
        }
        catch (IOException e) {
            throw new JiraClient.JiraException("Error querying jira", e);
        }
    }
}

