/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.bugreport.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
public class ConnectivityTestResult {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectivityTestResult.class);
    private String name;
    private Status status;
    private String message;
    private String exception;

    @JsonCreator
    public ConnectivityTestResult(@JsonProperty(value="name") String name, @JsonProperty(value="status") Status status, @JsonProperty(value="message") String message, @JsonProperty(value="exception") String exception) {
        this.name = name;
        this.status = status;
        this.message = message;
        this.exception = exception;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @JsonProperty
    public String getException() {
        return this.exception;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + this.getClass().getName() + " to JSON", e);
            return "Exception converting Testbed " + this.getClass().getName() + " to JSON: " + e.getMessage();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectivityTestResult)) {
            return false;
        }
        ConnectivityTestResult that = (ConnectivityTestResult)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return this.exception != null ? this.exception.equals(that.exception) : that.exception == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        return result;
    }

    public static enum Status {
        SUCCEEDED,
        WARNING,
        FAILED,
        SKIPPED;

    }
}

